<?php

use App\Http\Controllers\AddonController;
use Illuminate\Support\Facades\Route;
use Modules\GlobalSetting\app\Http\Controllers\LanguageController;
use Modules\GlobalSetting\app\Http\Controllers\DbbackupController;
use App\Http\Controllers\AdminLoginController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BookController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\ProviderController;
use App\Http\Controllers\StaffController;
use Illuminate\Http\Request;
use Modules\Page\app\Http\Controllers\Api\PageController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\PaypalController;
use App\Http\Controllers\MollieController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\SocialiteController;
use App\Http\Controllers\TransactionController;
use Illuminate\Support\Facades\Auth;
use Modules\Categories\app\Http\Controllers\CategoriesController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\ChatbotController;
use App\Http\Controllers\Admin\ParadigmPdfBuilderController;
use App\Http\Controllers\Admin\ParadigmFormTemplateController;
use App\Http\Controllers\Admin\ParadigmResultsController;
use Illuminate\Support\Facades\Artisan;
use Modules\GlobalSetting\app\Http\Controllers\SocialLinkController;
use App\Http\Controllers\ProviderSocialLinkController;
use Modules\GlobalSetting\app\Http\Controllers\admin\SocialMediaShareController;
use App\Models\ParadigmFormTemplate;

Route::get('/storage-link', function () {
    Artisan::call('storage:link');
    return redirect()->route('home');
})->name('storage-link')->middleware('admin.auth');

Route::get('/storage-linkadmin', function () {
    Artisan::call('storage:link');
    return redirect()->route('login');
})->name('storage-linkadmin')->middleware('admin.auth');

Route::get('db_backup', function () {
    Artisan::call('backup:run');
    return redirect()->route('admin.db-settings')->with('success', 'Database backup completed successfully');
})->middleware('admin.auth');
Route::group(['prefix' => 'user'], function() {
    Route::get('/login', function () {
        return view('user.login');
    })->name('userlogin');
    Route::get('/register', function () {
        return view('user.register');
    })->name('userregister');
    Route::get('/register-account', function () {
        return view('user.register-account');
    })->name('user.register.account');
    Route::post('/userregister', [AuthController::class, 'register'])->name('userregister.submit');
    Route::post('/booking/dispute',[BookingController::class,'requestDispute'])->name('user.requestDispute');

});

Route::get('auth/redirect/{provider}', [SocialiteController::class, 'redirectToProvider'])->name('auth.redirect');
Route::get('auth/{provider}-callback', [SocialiteController::class, 'handleProviderCallback'])->name('auth.callback');
Route::get('auth/{provider}/callback', [SocialiteController::class, 'handleProviderCallback']);

Route::get('admin/login', function (Request $request) {
    if(Auth::check() && (Auth::user()->user_type == 1 || Auth::user()->user_type == 5 )){
        return redirect()->route('admin.dashboard');
    }
    return view('admin.login');

})->name('login');

Route::get('admin', function () {
    if(Auth::check() && (Auth::user()->user_type == 1 || Auth::user()->user_type == 5 )){
        return redirect()->route('admin.dashboard');
    }
    return view('admin.login');
})->name('adminlogin');

Route::post('/admin/login-process', [AdminLoginController::class, 'login']);
Route::get('/admin/logout', [AdminLoginController::class, 'logout'])->name('admin.logout');

Route::group(['prefix' => 'admin', 'middleware' => ['admin.auth', 'permission']], function() {
    Route::get('/dashboard',[AdminDashboardController::class,'index'] )->name('admin.dashboard');
    
    // Edit Media Routes
    Route::prefix('edit-media')->group(function () {
        Route::get('/custom-links', [App\Http\Controllers\Admin\EditMediaController::class, 'customLinks'])->name('admin.edit-media.custom-links');
        Route::post('/custom-links/list', [App\Http\Controllers\Admin\EditMediaController::class, 'list'])->name('admin.edit-media.custom-links.list');
        Route::post('/custom-links', [App\Http\Controllers\Admin\EditMediaController::class, 'store'])->name('admin.edit-media.custom-links.store');
        Route::put('/custom-links/{id}', [App\Http\Controllers\Admin\EditMediaController::class, 'update'])->name('admin.edit-media.custom-links.update');
        Route::delete('/custom-links/{id}', [App\Http\Controllers\Admin\EditMediaController::class, 'destroy'])->name('admin.edit-media.custom-links.destroy');
        Route::post('/custom-links/{id}/toggle', [App\Http\Controllers\Admin\EditMediaController::class, 'toggleStatus'])->name('admin.edit-media.custom-links.toggle');
    });
    
    Route::get('/setting/payment-settings', function () {
        return view('admin.payment-settings');

    })->name('admin.payment-settings');

    Route::get('/services', function () {
        return view('admin.services');

    })->name('admin.services');

    Route::get('/addservice', [ServiceController::class, 'index'])->name('admin.addservice');

    Route::get('/addproduct', function () {
        return view('admin.addproduct');
    })->name('admin.addproduct');

    Route::get('/editservice/{id}', [ServiceController::class, 'editservice'])->name('editservice');
    Route::get('/service/view/{id}', [ServiceController::class, 'viewService'])->name('admin.service.view');
    Route::get('/setting/listwords/{id}', [LanguageController::class, 'listkeywords'])->name('listkeywords');

    Route::post('/savelangword', [LanguageController::class, 'savelangword'])->name('savelangword');
    Route::post('/savedbbackup', [DbbackupController::class, 'savelanguage'])->name('savedbbackup');
    Route::get('/setting/dbdownload/{id}', [DbbackupController::class, 'listkeywords'])->name('dbdownload');

    Route::get('/setting/language-settings', [LanguageController::class, 'languageSettings'])->name('admin.language-settings');

    Route::get('/setting/dbbackuplist', function () {
        return view('admin.db-settings');
    })->name('admin.db-settings');


    Route::get('/content/how-it-work', function () {
        return view('admin.how-it-work');
    })->name('admin.how-it-work');

    Route::get('/categories', function () {
        return view('admin.categories-settings');
    })->name('admin.categories');

    Route::get('/service/categories', [CategoriesController::class, 'servicecategories'])->name('admin.servicecategories');
    Route::get('/service/subcategories', [CategoriesController::class, 'serviceSubcategories'])->name('admin.servicesubcategories');
    Route::get('/form-categories', [AdminDashboardController::class, 'showFormCategories'])->name('admin.form-categories');

    Route::get('/setting/credential-settings', function () {
        return view('admin.credential-settings');
    })->name('admin.credential-settings');

    Route::get('/setting/subscription-package', function () {
        return view('admin.subscription-package');
    })->name('admin.subscription-package');

    Route::get('/content/faq', function () {
        return view('admin.faq-setting');
    })->name('admin.faq');

    Route::get('/transaction', function () {
        return view('admin.transaction');
    })->name('admin.transaction');

    Route::get('/providertransaction', function () {
        return view('admin.providertransaction');
    })->name('admin.providertransaction');

    Route::get('/providerrequest', function () {
        return view('admin.providerrequest');
    })->name('admin.providerrequest');

    Route::get('/request-dispute', function () {
        return view('admin.request_dispute');
    })->name('admin.request.dispute');

    Route::get('/calendar',  [BookingController::class, 'calenderview'])->name('admin.calendar');

    Route::get('/reviews', function () {
        return view('admin.review_list');
    })->name('admin.reviews');

    Route::get('/staffs',  [StaffController::class, 'adminStaff'])->name('admin.staffs');

    Route::get('/setting/file-storage', function () {
        return view('admin.file-storage');
    })->name('admin.file-storage');


    //social links
    Route::get('social-links', [SocialLinkController::class, 'socialLinks'])->name('admin.social-links');
    Route::post('store-social-link', [SocialLinkController::class, 'storeSocialLinks'])->name('admin.store-social-link');
    Route::post('get_social_links', [SocialLinkController::class, 'getSocialLinks'])->name('admin.get_social_links');
    Route::get('get_social_link/{id}', [SocialLinkController::class, 'getSocialLink'])->name('admin.get_social_link');
    Route::post('delete-social-link', [SocialLinkController::class, 'deleteSocialLink'])->name('admin.delete-social-link');

    // SocialMedia Share
    Route::get('social-media-shares', [SocialMediaShareController::class, 'index'])->name('admin.social-media-shares');
    Route::post('store-social-media-share', [SocialMediaShareController::class, 'store'])->name('admin.store-social-media-share');
    Route::post('get-social-media-shares', [SocialMediaShareController::class, 'getList'])->name('admin.get-social-media-shares');
    Route::get('get-social-media-share/{id}', [SocialMediaShareController::class, 'show'])->name('admin.get-social-media-share');
    Route::post('delete-social-media-share', [SocialMediaShareController::class, 'destroy'])->name('admin.delete-social-media-share');

    // PARADIGM PROFILES™ Form Templates
    Route::prefix('paradigm')->name('admin.paradigm.')->group(function () {
        Route::get('templates/json', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'getTemplatesJson'])->name('templates.json');
        Route::resource('templates', \App\Http\Controllers\Admin\ParadigmFormTemplateController::class)->parameters([
            'templates' => 'paradigmFormTemplate'
        ]);
        Route::get('templates/{paradigmFormTemplate}/preview', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'preview'])->name('templates.preview');
        Route::post('templates/{paradigmFormTemplate}/toggle-status', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'toggleStatus'])->name('templates.toggle-status');
        Route::post('templates/{paradigmFormTemplate}/duplicate', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'duplicate'])->name('templates.duplicate');
        Route::get('templates/{paradigmFormTemplate}/stats', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'getStats'])->name('templates.stats');
        Route::get('templates/{pageId}/elements', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'getPageElements'])->name('templates.page-elements');
        Route::post('templates/{pageId}/elements', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'createElement'])->name('templates.create-element');
        Route::put('templates/elements/{element}', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'updateElement'])->name('templates.update-element');
        Route::delete('templates/elements/{element}', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'deleteElement'])->name('templates.delete-element');
        
        // Route to handle question updates from the edit modal
        Route::put('/questions/{question}', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'updateQuestion'])->name('questions.update');

        // Additional template management routes
        Route::post('templates/{paradigmFormTemplate}/personal-fields', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'addPersonalField'])->name('templates.add-personal-field');
        Route::post('templates/{paradigmFormTemplate}/questions', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'addQuestion'])->name('templates.add-question');
        Route::post('templates/{paradigmFormTemplate}/badge-titles', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'addBadgeTitle'])->name('templates.add-badge-title');
        
        // PDF page management
        Route::post('templates/{paradigmFormTemplate}/pages', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'createPage'])->name('templates.create-page');
        Route::put('templates/pages/{page}', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'updatePage'])->name('templates.update-page');
        Route::delete('templates/pages/{page}', [\App\Http\Controllers\Admin\ParadigmFormTemplateController::class, 'deletePage'])->name('templates.delete-page');
        
        // PARADIGM PROFILES™ Results Management
        Route::prefix('results')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'index'])->name('results.index');
            Route::get('/{result}', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'show'])->name('results.show');
            Route::get('/export/csv', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'export'])->name('results.export');
            Route::get('/stats/data', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'getStats'])->name('results.stats');
            Route::get('/download/{filename}', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'downloadPdfFile'])->name('results.download-pdf-file');
            Route::delete('/delete-pdf', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'deletePdfFile'])->name('results.delete-pdf-file');
            Route::post('/delete', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'delete'])->name('results.delete');
            Route::post('/delete-all', [\App\Http\Controllers\Admin\ParadigmResultsController::class, 'deleteAll'])->name('results.delete-all');
        });
        
        // PARADIGM PROFILES™ Admin PDF Builder Routes
        Route::get('/paradigm-pdf-builder', [\App\Http\Controllers\Admin\ParadigmPdfBuilderController::class, 'index'])->name('paradigm-pdf-builder');
        Route::get('/paradigm-pdf-builder/{templateId}', [\App\Http\Controllers\Admin\ParadigmPdfBuilderController::class, 'builder'])->name('paradigm-pdf-builder.template');
        Route::post('/paradigm-pdf-builder/save-elements', [\App\Http\Controllers\Admin\ParadigmPdfBuilderController::class, 'saveElements'])->name('paradigm-pdf-builder.save-elements');
        Route::post('/paradigm-pdf-builder/clear-background', [\App\Http\Controllers\Admin\ParadigmPdfBuilderController::class, 'clearBackground'])->name('paradigm-pdf-builder.clear-background');
        
        // Sales Page Settings
        Route::get('/sales-settings', [\App\Http\Controllers\Admin\AdminParadigmSalesController::class, 'index'])->name('sales.index');
        Route::post('/sales-settings', [\App\Http\Controllers\Admin\AdminParadigmSalesController::class, 'store'])->name('sales.store');
        
        // Paradigm Profile Pricing Management
        Route::prefix('pricing')->name('pricing.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'index'])->name('index');
            Route::post('/', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'store'])->name('store');
            Route::get('/{templateId}', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'show'])->name('show');
            Route::post('/toggle-status', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'toggleStatus'])->name('toggle-status');
            
            // Marketplace Pricing
            Route::get('/marketplace', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'marketplacePricing'])->name('marketplace.index');
            Route::post('/marketplace', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'storeMarketplacePricing'])->name('marketplace.store');
            Route::delete('/marketplace/{ruleId}', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'deleteMarketplacePricing'])->name('marketplace.delete');
        });
    });

});
Route::post('admin/set-category-id', function (Request $request) {
    $request->session()->put('category_id', $request->input('category_id'));
    return response()->json(['success' => true]);
})->name('set.category.id');

Route::get('/', function () {
    return view('welcome');
})->name('login');

Route::get('/products', [ServiceController::class, 'onlyproductlist'])->name('allproducts');
Route::get('/services/{slug}/{is_mobile?}', [ServiceController::class, 'productlistcategory'])->name('productlistcategory');
Route::get('/services', [ServiceController::class, 'productlist'])->name('productlists');
Route::get('/categories', [ServiceController::class, 'catlist'])->name('catlist');

Route::get('/languagedefault/{id}', [LanguageController::class, 'languagedefault'])->name('languagedefault');
Route::get('/adminLanguagedefault/{id}', [LanguageController::class, 'adminLanguagedefault'])->name('adminLanguagedefault');
Route::get('/lang/{file_name}', function () {
    return response()->file(resource_path('lang/' . request()->file_name));
});
Route::post('/book', [BookController::class, 'book'])->name('book');
Route::post('/booking-payment', [BookController::class, 'bookingpayment'])->name('bookingpayment');
Route::post('/booking-success', [BookController::class, 'bookingsuccess'])->name('bookingsuccess');

Route::get('/servicedetail/{slug}', [ServiceController::class, 'productdetail'])->name('productdetail');

Route::get('/cart', [ServiceController::class, 'viewcart'])->name('viewcart');

Route::post('/chatbot/save-message', [ChatbotController::class, 'saveMessage']);

Route::post('/userlogins', [UserController::class, 'login'])->name('userlogins');
Route::post('/userregister', [UserController::class, 'register'])->name('userregister.post');
Route::get('/user/auth/register-fields', function() {
    return view('user.auth.user_register_fields_only');
})->name('register.fields');
Route::post('/user-update-password', [UserController::class, 'forgotPassword'])->name('forgotPassword');
Route::post('/send-password-reset-link', [UserController::class, 'sendPasswordResetLink'])->name('password.send.link');
Route::get('reset-password/{token}', [UserController::class, 'showResetForm'])->name('password.reset');
Route::get('logout', [UserController::class, 'logout'])->name('logout');
Route::post('/user/delete-account', [UserController::class, 'deleteAccount']);
Route::get('/provider/register-account', function () {
    return view('user.provider-register-account');
})->name('provider.register.account');
Route::post('/provider/register', [UserController::class, 'providerRegister'])->name('provider.register');
Route::get('/user/profile', [UserController::class, 'getProfileDetails'])->name('user.profile')->middleware('auc');
Route::get('/user/search', [UserController::class, 'getProfileDetailssearch'])->name('user.profilesearch')->middleware('auc');
Route::get('/user/security', [UserController::class, 'userSecuritySettings'])->name('user.security')->middleware('track.device');
Route::get('/provider/security', [UserController::class, 'providerSecuritySettings'])->name('provider.security')->middleware('track.device', 'permission');
Route::post('/device/delete', [UserController::class, 'devideDelete'])->name('device.delete');
Route::get('user/bookinglist',[BookingController::class,'index'])->name('user.bookinglist')->middleware('auc');
Route::post('/dispute/details', [BookingController::class, 'getDisputeDetails']);

Route::get('/admin/profile', [AdminLoginController::class, 'getAdminDetails'])->name('admin.profile')->middleware('admin.auth');

Route::get('/api/get-session-user-id', function () {
    $userId = session('user_id');
    if ($userId) {
        return response()->json(['user_id' => $userId]);
    } else {
        return response()->json(['user_id' => null]);
    }
});
Route::get('/admin/users', [UserController::class, 'index'])->name('admin.userlist')->middleware('admin.auth', 'permission');
Route::get('/admin/providers', [UserController::class, 'index'])->name('admin.providerslist')->middleware('admin.auth', 'permission');
Route::get('/admin/bookinglist', [BookingController::class, 'listindex'])->name('admin.bookinglist')->middleware('admin.auth', 'permission');

Route::get('/provider/leads', function () {
    return redirect()->route('provider.marketplace');
})->name('provider.leads')->middleware('auc', 'permission');

Route::get('/provider/leadsinfo', function () {
    return view('provider.providerleadsinfo');
})->name('provider.leadsinfo')->middleware('auc');

Route::get('/provider/dashboard', function () {
    return view('provider.providerdashboard');
})->name('provider.dashboard')->middleware('auc', 'permission', \App\Http\Middleware\CheckProviderVerification::class);

    // Provider Edit Media Routes
    Route::prefix('provider/edit-media')->middleware(['auc', 'permission'])->group(function () {
        Route::get('/dashboard', function () {
            return redirect()->route('provider.dashboard');
        })->name('provider.edit-media.dashboard');
        
        Route::get('/profile', function () {
            return redirect()->route('provider.profile');
        })->name('provider.edit-media.profile');
        
        Route::get('/services', function () {
            return redirect()->route('admin.services');
        })->name('provider.edit-media.services');
        
        Route::get('/leads', function () {
            return redirect()->route('provider.leads');
        })->name('provider.edit-media.leads');
    });

    // Paddle Payment Routes
    Route::prefix('paddle')->group(function () {
        // Wallet routes
        Route::post('/wallet/checkout', [App\Http\Controllers\PaddleWalletController::class, 'createCheckout'])->name('paddle.wallet.checkout');
        Route::get('/wallet/success', [App\Http\Controllers\PaddleWalletController::class, 'success'])->name('paddle.wallet.success');
        Route::get('/wallet/cancel', [App\Http\Controllers\PaddleWalletController::class, 'cancel'])->name('paddle.wallet.cancel');
        
        // Subscription routes
        Route::post('/subscription/checkout', [App\Http\Controllers\PaddleSubscriptionController::class, 'createCheckout'])->name('paddle.subscription.checkout');
        Route::get('/subscription/success', [App\Http\Controllers\PaddleSubscriptionController::class, 'success'])->name('paddle.subscription.success');
        Route::get('/subscription/cancel', [App\Http\Controllers\PaddleSubscriptionController::class, 'cancel'])->name('paddle.subscription.cancel');
        Route::post('/subscription/cancel', [App\Http\Controllers\PaddleSubscriptionController::class, 'cancelSubscription'])->name('paddle.subscription.cancel.submit');
    });
Route::get('/staff/dashboard', function () {
    // Redirect company owners to provider dashboard
    $user = Auth::user();
    if ($user && $user->user_type == 4 && isset($user->is_company_owner) && $user->is_company_owner) {
        return redirect()->route('provider.dashboard');
    }
    return app(\App\Http\Controllers\StaffController::class)->getdashboard();
})->name('staff.dashboard')->middleware('auc', 'permission');
Route::get('/provider/transaction', function () {
    return view('provider.providertransaction');
})->name('provider.transaction')->middleware('auc', 'permission', \App\Http\Middleware\CheckProviderVerification::class);

Route::get('/provider/wallet', [ProviderController::class, 'wallet'])->name('provider.wallet')->middleware('auc', 'permission');
Route::get('/provider/wallet/data', [ProviderController::class, 'walletData'])->name('provider.wallet.data')->middleware('auc');
Route::get('/provider/wallet/topup', [ProviderController::class, 'walletTopup'])->name('provider.wallet.topup')->middleware('auc', 'permission');
Route::post('/provider/wallet/add-amount', [ProviderController::class, 'addWalletAmount'])->name('provider.wallet.add-amount')->middleware('auc');
Route::get('/provider/wallet/payment-success', [ProviderController::class, 'walletPaymentSuccess'])->name('provider.wallet.payment-success')->middleware('auc');

Route::get('/provider/reviews', function () {
    return view('provider.review_list');
})->name('provider.reviews')->middleware('auc', 'permission');

// Provider Paradigm Assessment Routes
Route::get('/provider/paradigm/payment-links', function () {
    try {
        $user = Auth::user();
        if ($user) {
            // Safely check category slug
            $categorySlug = null;
            if (method_exists($user, 'category') || isset($user->category)) {
                $category = $user->category ?? null;
                if ($category && isset($category->slug)) {
                    $categorySlug = $category->slug;
                }
            }
            
            if ($categorySlug && $categorySlug !== 'practitioner') {
                return redirect()->route('provider.dashboard')->with('error', 'This feature is only available for verified practitioners.');
            }
        }
        return view('provider.paradigm.payment-links');
    } catch (\Exception $e) {
        \Log::error('Error loading payment-links page', ['error' => $e->getMessage()]);
        return view('provider.paradigm.payment-links');
    }
})->name('provider.paradigm.payment-links')->middleware('auc', 'permission');

// Free Assessment Section - Available for ADMINS + practitioner AND professional categories
Route::get('/provider/paradigm/free-assessment', function () {
    $user = Auth::user();
    
    // Admins bypass category check, others need practitioner OR professional category
    if ($user->user_type != 1) {
        // Not an admin - check for category
        if (!$user->category || !in_array($user->category->slug, ['practitioner', 'professional'])) {
            return redirect()->route('provider.dashboard')
                ->with('error', 'This feature is only available for practitioners and professionals.');
        }
    }
    
    return view('provider.paradigm.free-assessment');
})->name('provider.paradigm.free-assessment')->middleware('auc', 'permission');

Route::get('/provider/paradigm/templates/json', function () {
    $templates = \App\Models\ParadigmFormTemplate::where('is_active', true)
        ->with('pricing') // Load pricing relationship
        ->select('id', 'name', 'description', 'is_active')
        ->orderBy('name', 'asc')
        ->get();
    return response()->json($templates);
})->name('provider.paradigm.templates.json')->middleware('auc');

Route::get('/provider/paradigm/generated-links', function () {
    $providerId = auth()->id();
    $user = auth()->user();
    
    // If user is staff (user_type = 4), use parent provider's ID for paradigm profiles
    if ($user && $user->user_type == 4) {
        $userDetail = $user->userDetail;
        if ($userDetail && $userDetail->parent_id) {
            $providerId = $userDetail->parent_id;
        }
    }
    
    $payments = \App\Models\ParadigmPayment::with(['template'])
        ->where('provider_id', $providerId)
        ->orderBy('created_at', 'desc')
        ->limit(50)
        ->get()
        ->map(function ($payment) use ($providerId) {
            // SECURITY FIX: Check if assessment has been completed with proper filtering
            $result = \App\Models\ParadigmAssessmentResult::where('email', $payment->client_email)
                ->where('template_id', $payment->template_id)
                ->where('provider_id', $providerId) // FIX: Ensure same provider
                ->where('created_at', '>=', $payment->created_at) // FIX: Result must be after payment
                ->first();
            
            $isCompleted = $result && $result->paradigm_type !== null; // Completed if result exists AND has paradigm_type
            
            // Generate direct access link if client details are provided
            $assessmentLink = null;
            if ($payment->client_name && $payment->client_surname && $payment->payment_link) {
                $assessmentLink = url('/paradigm/assessment-direct/' . $payment->payment_link);
            }
            
            // Determine payment status display
            $paidBy = $payment->paid_by ?? 'client';
            $paymentStatusDisplay = '';
            
            // If self-purchased, show "Paid by user"
            if ($payment->self_purchased == 1) {
                $paidBy = 'client';
                $paymentStatusDisplay = 'Paid by user';
            } else {
                // Use existing logic for other payment types
                if ($paidBy === 'free') {
                    $paymentStatusDisplay = 'Free';
                } else if ($paidBy === 'provider') {
                    $paymentStatusDisplay = 'Paid by Provider';
                } else if ($paidBy === 'client') {
                    $paymentStatusDisplay = 'Client Pays';
                }
            }
            
            return [
                'id' => $payment->id,
                'template_name' => $payment->template->name ?? 'Unknown',
                'client_email' => $payment->client_email ?? 'N/A',
                'paid_by' => $paidBy,
                'payment_status_display' => $paymentStatusDisplay,
                'self_purchased' => $payment->self_purchased ?? 0,
                'status' => $isCompleted ? 'completed' : $payment->status,
                'is_completed' => $isCompleted, // NEW: Track if Paradigm profile is completed
                'amount' => $payment->amount,
                'currency' => $payment->currency,
                'created_at' => $payment->created_at->format('Y-m-d H:i'),
                'assessment_link' => $assessmentLink,
                'payment_link' => $payment->payment_link
            ];
        });
    return response()->json($payments);
})->name('provider.paradigm.generated-links')->middleware('auc');

Route::get('/provider/paradigm/client-link', [\App\Http\Controllers\ProviderController::class, 'getClientLink'])->name('provider.paradigm.client-link')->middleware('auc');

// Provider Paradigm Revoke & Delete Routes
Route::post('/provider/paradigm/revoke-assignment', [\App\Http\Controllers\ProviderController::class, 'revokeAssignment'])->name('provider.paradigm.revoke-assignment')->middleware('auc');
Route::post('/provider/paradigm/delete-assignment', [\App\Http\Controllers\ProviderController::class, 'deleteAssignment'])->name('provider.paradigm.delete-assignment')->middleware('auc');
Route::post('/provider/paradigm/delete-client-link', [\App\Http\Controllers\ProviderController::class, 'deleteClientLink'])->name('provider.paradigm.delete-client-link')->middleware('auc');
Route::post('/provider/paradigm/unlink-client', [\App\Http\Controllers\ProviderController::class, 'unlinkClient'])->name('provider.paradigm.unlink-client')->middleware('auc');
Route::post('/provider/paradigm/delete-all-assignments', [\App\Http\Controllers\ProviderController::class, 'deleteAllAssignments'])->name('provider.paradigm.delete-all-assignments')->middleware('auc');
Route::post('/provider/paradigm/delete-all-client-links', [\App\Http\Controllers\ProviderController::class, 'deleteAllClientLinks'])->name('provider.paradigm.delete-all-client-links')->middleware('auc');

// Provider Marketplace Routes
Route::middleware(['auc'])->group(function() {
    Route::get('/provider/paradigm/marketplace', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'index'])->name('provider.paradigm.marketplace');
    Route::get('/provider/paradigm/marketplace/my-purchases', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'myPurchases'])->name('provider.paradigm.marketplace.my-purchases');
    Route::get('/provider/paradigm/marketplace/{resultId}', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'show'])->name('provider.paradigm.marketplace.show');
    Route::post('/provider/paradigm/marketplace/{resultId}/purchase', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'purchase'])->name('provider.paradigm.marketplace.purchase');
    Route::get('/provider/paradigm/marketplace/{resultId}/download', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'download'])->name('provider.paradigm.marketplace.download');
    Route::get('/provider/paradigm/marketplace/{purchaseId}/transfer', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'transferProfile'])->name('provider.paradigm.marketplace.transfer');
    Route::post('/provider/paradigm/marketplace/{purchaseId}/transfer', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'processTransfer'])->name('provider.paradigm.marketplace.transfer.process');
    
    // Provider Link Requests
    Route::get('/provider/paradigm/link-requests', [\App\Http\Controllers\Provider\ParadigmLinkRequestController::class, 'index'])->name('provider.paradigm.link-requests');
    Route::post('/provider/paradigm/link-requests/{requestId}/accept', [\App\Http\Controllers\Provider\ParadigmLinkRequestController::class, 'accept'])->name('provider.paradigm.link-requests.accept');
    Route::post('/provider/paradigm/link-requests/{requestId}/decline', [\App\Http\Controllers\Provider\ParadigmLinkRequestController::class, 'decline'])->name('provider.paradigm.link-requests.decline');
});

// Provider Identity Verification Routes
Route::get('/provider/identity-verification', [\App\Http\Controllers\ProviderIdentityVerificationController::class, 'showUploadPage'])->name('provider.identity-verification')->middleware('auc');
Route::post('/provider/identity-verification/upload-id', [\App\Http\Controllers\ProviderIdentityVerificationController::class, 'uploadIdDocument'])->name('provider.identity-verification.upload-id')->middleware('auc');
Route::post('/provider/identity-verification/upload-selfie', [\App\Http\Controllers\ProviderIdentityVerificationController::class, 'uploadSelfie'])->name('provider.identity-verification.upload-selfie')->middleware('auc');
Route::get('/provider/identity-verification/status', [\App\Http\Controllers\ProviderIdentityVerificationController::class, 'getStatus'])->name('provider.identity-verification.status')->middleware('auc');

// Provider Staff Document Upload Routes (same pattern as identity verification)
Route::post('/provider/staff/upload-id-document', [\App\Http\Controllers\StaffDocumentController::class, 'uploadIdDocument'])->name('provider.staff.upload-id')->middleware('auc');
Route::post('/provider/staff/upload-selfie', [\App\Http\Controllers\StaffDocumentController::class, 'uploadSelfie'])->name('provider.staff.upload-selfie')->middleware('auc');

// Provider Branch Document Upload Routes (same pattern as identity verification)
Route::post('/provider/branch/upload-documents', [\App\Http\Controllers\BranchDocumentController::class, 'uploadDocuments'])->name('provider.branch.upload-documents')->middleware('auc');

// Admin Identity Verification Routes
Route::post('/admin/provider/identity-verification/verify', [\App\Http\Controllers\ProviderIdentityVerificationController::class, 'adminVerify'])->name('admin.provider.identity-verification.verify')->middleware('auc');
Route::post('/admin/provider/identity-verification/reject', [\App\Http\Controllers\ProviderIdentityVerificationController::class, 'adminReject'])->name('admin.provider.identity-verification.reject')->middleware('auc');

Route::get('/user/dashboard', function () {
    return view('user-dashboard');
})->name('user.dashboard')->middleware('auc');

Route::get('/user/wallet', [\App\Http\Controllers\UserController::class, 'wallet'])->name('user.wallet')->middleware('auc');
Route::get('/user/wallet/data', [\App\Http\Controllers\UserController::class, 'walletData'])->name('user.wallet.data')->middleware('auc');

// User Wallet Top-up Page
Route::get('/user/wallet/topup', function () {
    return view('user.wallet-topup');
})->name('user.wallet.topup')->middleware('auc');

Route::get('/user/submitted-requests', function () {
    return view('user.submitted-requests.index');
})->name('user.submitted-requests')->middleware('auc');

Route::get('/user/wallet/balance', [\App\Http\Controllers\UserController::class, 'walletBalance'])->name('user.wallet.balance')->middleware('auc');

// User Paradigm Assessment Routes
Route::get('/user/paradigm/assessments', function () {
    return view('user.paradigm.assessments');
})->name('user.paradigm.assessments')->middleware('auc');

// Paradigm payment link access route
Route::get('/paradigm/payment/{link}', function ($link) {
    $payment = \App\Models\ParadigmPayment::where('payment_link', $link)
        ->with(['template', 'accessTokens'])
        ->first();
    
    if (!$payment) {
        return redirect()->route('user.paradigm.assessments')->with('error', 'Invalid payment link');
    }
    
    $accessToken = $payment->accessTokens->first();
    
    if (!$accessToken) {
        return redirect()->route('user.paradigm.assessments')->with('error', 'Access token not found');
    }
    
    // If user is logged in, go to their assessments page with token pre-filled
    if (auth()->check()) {
        return redirect()->route('user.paradigm.assessments')
            ->with('access_token', $accessToken->token)
            ->with('success', 'Your assessment is ready! Click "Start Assessment" to begin.');
    }
    
    // If user is not logged in, redirect to login with return URL
    return redirect()->route('login')
        ->with('message', 'Please log in to access your assessment')
        ->with('return_url', route('paradigm.payment.access', ['link' => $link]));
})->name('paradigm.payment.access');

Route::post('/paradigm/save-progress', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'saveProgress'])->name('templates.save-progress');

// Public route for downloading PDF results (secured by controller logic)
Route::get('/paradigm/results/{resultId}/download-pdf', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'downloadPdf'])->name('paradigm.results.download-pdf');

Route::get('/paradigm/assessment/completion/{resultId?}', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'completion'])->name('paradigm.assessment.completion');

Route::get('/user/paradigm/my-assessments', function () {
    $user = auth()->user();
    
    // Find assessments for this user based on their email
    $paymentsCollection = \App\Models\ParadigmPayment::with(['template'])
        ->where(function($query) use ($user) {
            $query->where('client_email', $user->email)
                  ->orWhere('client_id', $user->id);
        })
        ->where('status', '!=', 'expired')
        ->orderBy('created_at', 'desc')
        ->get();
    
    $payments = $paymentsCollection->map(function ($payment) use ($user, $paymentsCollection) {
            // Check if assessment result exists
            // Match by: provider + template + client email/name + completed after THIS payment but before NEXT payment
            $nextPayment = $paymentsCollection->where('template_id', $payment->template_id)
                ->where('provider_id', $payment->provider_id)
                ->where('created_at', '>', $payment->created_at)
                ->sortBy('created_at')
                ->first();
            
            $result = \App\Models\ParadigmAssessmentResult::where('template_id', $payment->template_id)
                ->where('provider_id', $payment->provider_id)
                ->where(function($query) use ($user) {
                    // Match by client email or user's first/last name
                    $query->where('email', $user->email);
                    if ($user->userDetails) {
                        $query->orWhere(function($q) use ($user) {
                            $q->where('name', $user->userDetails->first_name ?? '')
                              ->where('surname', $user->userDetails->last_name ?? '');
                        });
                    }
                })
                ->where('created_at', '>=', $payment->created_at)
                ->when($nextPayment, function($query) use ($nextPayment) {
                    // If there's a newer payment, only match results created before that payment
                    $query->where('created_at', '<', $nextPayment->created_at);
                })
                ->orderBy('created_at', 'desc')
                ->first();
            
            // Determine result status
            $resultStatus = null;
            $resultId = null;
            if ($result) {
                $resultStatus = 'completed'; // If result exists, assessment is completed
                $resultId = $result->id;
            }
            
            // For self-purchased assessments, show as paid by client
            $paidBy = $payment->paid_by ?? 'client';
            $paymentStatus = $payment->status;
            
            // If self-purchased, treat as paid by client with paid status
            if ($payment->self_purchased == 1) {
                $paidBy = 'client';
                $paymentStatus = 'paid';
            }
            
            return [
                'payment_id' => $payment->id,
                'template_id' => $payment->template_id,
                'template_name' => $payment->template->name ?? 'Unknown',
                'paid_by' => $paidBy, // Use calculated value
                'payment_status' => $paymentStatus, // Use calculated value
                'self_purchased' => $payment->self_purchased ?? 0, // Include for view check
                'result_status' => $resultStatus,
                'result_id' => $resultId,
                'amount' => $payment->amount ?? 0,
                'created_at' => $payment->created_at ? $payment->created_at->format('Y-m-d H:i') : null,
            ];
        });
    
    return response()->json($payments);
})->name('user.paradigm.my-assessments')->middleware('auc');

Route::get('/user/walletsucess', [WalletController::class, 'walletsucess'])->name('user.walletsucess')->middleware('auc');

Route::get('/user/leads', function () {
    return view('user-leads');
})->name('user.leads')->middleware('auc');

Route::get('/user/leadsinfo', function () {
    return view('user-leadsinfo');
})->name('user.leadsinfo')->middleware('auc');

// User Paradigm Assessment Routes
Route::get('/user/paradigm/assessments', function () {
    return view('user.paradigm.assessments');
})->name('user.paradigm.assessments')->middleware('auc');

// User Self-Purchase Paradigm Routes (NEW - Safe, doesn't touch existing system)
Route::get('/user/paradigm/buy', [App\Http\Controllers\UserParadigmController::class, 'buyAssessment'])->name('user.paradigm.buy')->middleware('auc');
Route::get('/user/paradigm/buy-credits', [App\Http\Controllers\UserParadigmController::class, 'buyCredits'])->name('user.paradigm.buy-credits')->middleware('auc');
Route::get('/user/paradigm/payment-success', [App\Http\Controllers\PayFastController::class, 'paradigmPaymentSuccess'])->name('user.paradigm.payment-success')->middleware('auc');
Route::post('/user/paradigm/purchase', [App\Http\Controllers\UserParadigmController::class, 'processPurchase'])->name('user.paradigm.purchase')->middleware('auc');
Route::get('/user/paradigm/my-paid', [App\Http\Controllers\UserParadigmController::class, 'myPaidAssessments'])->name('user.paradigm.my-paid')->middleware('auc');

// User Link Requests
Route::get('/user/paradigm/link-requests', [\App\Http\Controllers\User\ParadigmLinkRequestController::class, 'index'])->name('user.paradigm.link-requests')->middleware('auc');
Route::post('/user/paradigm/link-requests/{requestId}/accept', [\App\Http\Controllers\User\ParadigmLinkRequestController::class, 'accept'])->name('user.paradigm.link-requests.accept')->middleware('auc');
Route::post('/user/paradigm/link-requests/{requestId}/decline', [\App\Http\Controllers\User\ParadigmLinkRequestController::class, 'decline'])->name('user.paradigm.link-requests.decline')->middleware('auc');

// Paradigm Chatbot Registration Route
Route::post('/paradigm/chatbot-register', [App\Http\Controllers\ParadigmPaymentController::class, 'chatbotRegister'])->name('paradigm.payment.chatbot-register');

// Linked Providers page
Route::get('/user/linked', function () {
    return view('user.linked');
})->name('user.linked')->middleware('auc');

// API routes for linked providers
Route::get('/user/linked/providers', [App\Http\Controllers\UserController::class, 'getLinkedProviders'])->name('user.linked.providers')->middleware('auc');
Route::post('/user/unlink/provider', [App\Http\Controllers\UserController::class, 'unlinkProvider'])->name('user.unlink.provider')->middleware('auc');

Route::get('/user/provider', function () {
    return view('user-provider');
})->name('user.provider')->middleware('auc');

Route::get('/user/providerlist', function () {
    return view('user-providerlist');
})->name('user.providerlist');

Route::get('/user/providerdetails', function () {
    return view('user-providerdetails');
})->name('user.providerdetails');

Route::get('/user/transaction', function () {
    return view('user-transaction');
})->name('user.transaction')->middleware('auc');

Route::get('/user/providerlist', [UserController::class, 'userProviderList'])->name('user.providerlist');
Route::get('/user/provider', [UserController::class, 'userProvider'])->name('user.provider');


Route::get('/admin/user/view/{id}', [UserController::class, 'renderUserViewPage'])->name('user.viewdetails.page');
Route::get('/admin/provider/view/{id}', [UserController::class, 'renderUserViewPage'])->name('provider.viewdetails.page');
Route::get('/user/favourites', [UserController::class, 'getuserfavour'])->name('user.favourites')->middleware('auc');
Route::post('admin/verify-provider', [UserController::class, 'verifyProvider'])->name('admin.verify.provider');

Route::post('/admin/viewuserdata', [UserController::class, 'getuserviewdetails'])->name('admin.viewusers');

Route::get('/buyaprofile', [\App\Http\Controllers\Public\ParadigmSalesController::class, 'index'])->name('paradigm.sales');

Route::get('/', [PageController::class, 'pageBuilderApi'])->name('home');
Route::get('/about-us', [PageController::class, 'pageBuilderApi'])->name('test');
Route::get('/terms-conditions', [PageController::class, 'pageBuilderApi'])->name('terms.conditions');
Route::get('/privacy-policy', [PageController::class, 'pageBuilderApi'])->name('privacy.policy');
Route::get('/contact-us', [PageController::class, 'pageBuilderApi'])->name('contact-us');
Route::get('/page-not-found', [PageController::class, 'pageBuilderApi'])->name('page.not.found');

Route::get('/maintenance', function () {
    return view('user.partials.maintenance');
})->name('maintenance');

Route::post('handle-payment',[PaypalController::class,'handlePayment'])->name('make.payment');
Route::post('preparePayment',[MollieController::class,'preparePayment'])->name('make.preparePayment');
Route::get('sucesspayment',[MollieController::class,'handleWebhookNotification'])->name('make.molliesucess');
Route::post('molliepayment',[MollieController::class,'molliepayment'])->name('molliepayment');
Route::get('/mollie-payment-success',[MollieController::class,'handleMolliepayment'])->name('make.molliepayment');
Route::get('/payment-success-leads',[MollieController::class,'handleMolliepaymentLeads'])->name('make.molliepayment.leads');
Route::post('/walletPayment',[WalletController::class,'leasdwalletPayment'])->name('leasdwalletPayment.leads');
Route::get('/wallet-payment-success',[WalletController::class,'leasdwalletPaymentSuccess'])->name('leasdwalletPayment.leads.Success');
Route::post('handle-cod-payment',[PaypalController::class,'handlecodPayment'])->name('make.codpayment');
Route::post('handle-wallet-payment',[PaypalController::class,'handleWalletPayment'])->name('make.walletpayment');
Route::post('handleBankPayment',[PaypalController::class,'handleBankPayment'])->name('makebank.bankpayment');
Route::post('processpayment',[PaypalController::class,'ProcessPayment'])->name('processpayment');
Route::get('payment-success',[PaypalController::class,'paymentSuccess'])->name('payment.success');
Route::get('payment-failed',[PaypalController::class,'paymentFailed'])->name('payment.failed');
Route::get('/provider/paymentsuccess',[PaypalController::class,'Successpayment'])->name('providerpayment.success');
Route::get('/user/paymentsuccess',[PaypalController::class,'UserSuccesspayment'])->name('userpayment.success');
Route::post('stripecheckout',[StripeController::class,'test'])->name('stripecheckout');
Route::get('success',[StripeController::class,'paymentSuccess'])->name('success');
Route::get('/provider/subscriptionpaymentsuccess',[StripeController::class,'subscriptionpaymentsuccess'])->name('provider.subscriptionsuccess');
Route::get('checkout',[StripeController::class,'checkout'])->name('checkout');
Route::get('live_mobile',[StripeController::class,'live_mobile'])->name('live_mobile');
Route::post('stripepayment',[StripeController::class,'stripepayment'])->name('stripepayment');
Route::get('/user/stripepaymentsuccess',[StripeController::class,'UserstripeSuccesspayment'])->name('userstripepayment.success');

// PayFast Routes
Route::post('/payfastpayment', [\App\Http\Controllers\PayFastController::class, 'payment'])->name('payfastpayment');
Route::get('/payfast/success/provider', [\App\Http\Controllers\PayFastController::class, 'successProvider'])->name('payfast.success.provider');
Route::get('/payfast/success/user', [\App\Http\Controllers\PayFastController::class, 'successUser'])->name('payfast.success.user');
Route::get('/payfast/cancel/provider', [\App\Http\Controllers\PayFastController::class, 'cancelProvider'])->name('payfast.cancel.provider');
Route::get('/payfast/cancel/user', [\App\Http\Controllers\PayFastController::class, 'cancelUser'])->name('payfast.cancel.user');
Route::post('/payfast/notify', [\App\Http\Controllers\PayFastController::class, 'notify'])->name('payfast.notify');
// Manual ITN trigger for local testing (only works in local/sandbox environment)
Route::post('/payfast/manual-itn-trigger', [\App\Http\Controllers\PayFastController::class, 'manualITNTrigger'])->name('payfast.manual-itn-trigger');
Route::get('/provider/profile', [UserController::class, 'getProfileDetails'])->name('provider.profile')->middleware('auc', 'permission', \App\Http\Middleware\CheckProviderVerification::class);
Route::get('/provider/bookinglist', [BookingController::class, 'providerindex'])->name('provider.bookinglist')->middleware('auc', 'permission');
Route::get('/staff/bookinglist', [BookingController::class, 'staffindex'])->name('staff.bookinglist')->middleware('auc', 'permission');
Route::get('/provider/calendar', [ProviderController::class, 'providerCalendarIndex'])->name('provider.calendar')->middleware('auc');
Route::get('/staff/calendar', [StaffController::class, 'CalendarIndex'])->name('staff.calendar')->middleware('auc', 'permission');
Route::get('/provider/subscription', [SubscriptionController::class, 'index'])->name('provider.subscription')->middleware('auc', 'permission');
Route::get('/provider/subscriptionhistory', [SubscriptionController::class, 'historyindex'])->name('provider.subscriptionhistory')->middleware('auc', 'permission');
Route::post('/getsubscriptionhistorylist', [SubscriptionController::class, 'getsubscriptionhistorylist'])->middleware('auc');
Route::post('/set-session', function (Illuminate\Http\Request $request) {
    $existingData = session("{$request->type}.{$request->authid}.chat", []);
    // Add or update the specific key-value pair
    $existingData[$request->key] = $request->value;
    // Update the session with the modified data
    session()->put("{$request->type}.{$request->authid}.chat", $existingData);
    session()->put('fromurl','bookinglist');
    // session("$request->type.{$request->authUserId}.chat",[$request->key => $request->value]);
    return response()->json(['success' => true, 'message' => 'Session value set successfully!']);
})->middleware('auth');
Route::get('/provider/staff-list', function () {
    return view('provider.staff_list');
})->name('provider.staffs')->middleware('auc', 'permission');

Route::get('/provider/payouts', function() {
    return view('provider.payouts.payout_list');
})->name('provider.payouts')->middleware('auc', 'permission');

Route::get('/provider/branch', [BranchController::class, 'branch'])->name('provider.branch')->middleware('auc', 'permission');
Route::get('/provider/add-branch', [BranchController::class, 'addBranch'])->name('provider.addbranch')->middleware('auc', 'permission');
Route::get('/provider/edit-branch/{id}', [BranchController::class, 'editBranch'])->name('provider.editbranch')->middleware('auc', 'permission');
Route::post('/provider/save-branch-details', [BranchController::class, 'saveBranch'])->middleware('auc');
Route::post('/provider/delete-branch', [BranchController::class, 'deleteBranch'])->middleware('auc');
Route::post('/provider/get-branch-list', [BranchController::class, 'index'])->middleware('auc');
Route::post('/provider/branch/check-unique', [BranchController::class, 'checkUnique'])->middleware('auc');
Route::post('/provider/branch/check-limit', [BranchController::class, 'providerBranchLimit'])->middleware('auc');
Route::post('/provider/staff/check-limit', [StaffController::class, 'providerStaffLimit'])->middleware('auc');

Route::get('/get-countries', [BranchController::class, 'getCountries']);
Route::get('/get-states', [BranchController::class, 'getStates']);
Route::get('/get-cities', [BranchController::class, 'getCities']);

Route::get('/admin/refund', function() { return view('admin.finance.userrequest');})->name('admin.refund')->middleware('admin.auth', 'permission');
Route::get('/admin/subscriptionlist',function() { return view('admin.finance.subscriptionlist');})->name('admin.subscriptionlist')->middleware('admin.auth', 'permission');

Route::post('/get-dispute-info', [BookingController::class, 'getDisputeInfo']);
Route::get('/user/ticket',[TicketController::class, 'ticketindex'])->name('user.ticket')->middleware('auc');
Route::get('/provider/ticket',[TicketController::class, 'ticketindex'])->name('provider.ticket')->middleware('auc');
Route::get('/staff/ticket',[TicketController::class, 'ticketindex'])->name('staff.ticket')->middleware('auc');
Route::get('/admin/tickets',[TicketController::class, 'ticketindex'])->name('admin.ticket')->middleware('admin.auth');
Route::get('admin/ticket-details/{ticket_id}',[TicketController::class,'ticketdetails'])->name('admin.ticketdetails')->middleware('admin.auth');
Route::get('/staff/tickets',[TicketController::class, 'ticketindex'])->name('staff.tickets')->middleware('admin.auth', 'permission');
Route::get('staff/ticketdetails/{ticket_id}',[TicketController::class,'ticketdetails'])->name('staff.ticketdetails')->middleware('admin.auth', 'permission');
Route::post('/store-ticket-id', [TicketController::class, 'storeTicketId'])->name('store.ticket.id');
Route::get('user/ticket-details/{ticket_id}',[TicketController::class,'ticketdetails'])->name('user.ticketdetails')->middleware('auc');
Route::get('provider/ticket-details/{ticket_id}',[TicketController::class,'ticketdetails'])->name('provider.ticketdetails')->middleware('auc');
Route::get('staff/ticket-details/{ticket_id}',[TicketController::class,'ticketdetails'])->name('staff.ticket_details')->middleware('auc');
//my booking
Route::get('/user/booking/service-booking/{slug}', [BookController::class, 'serviceBooking'])->name('user.booking.location.service_booking')->middleware('auc');
Route::get('/user/booking/{slug}', [BookController::class, 'serviceIndexBooking'])->name('user.booking.service_booking')->middleware('auc');
Route::get('/get-branch-staff', [BookController::class, 'getStaffs']);
Route::get('/get-branch-staff-info', [BookController::class, 'getInfo']);
Route::get('/get-personal-info', [BookController::class, 'getPersonalInfo']);
Route::post('/get-slot', [BookController::class, 'getSlot']);
Route::post('/get-slots', [BookController::class, 'getSlots']);
Route::post('/get-slot-info', [BookController::class, 'getSlotInfo']);
Route::post('/get-payout', [BookController::class, 'getPayout']);
Route::post('/user/payment', [BookController::class, 'payment']);
Route::get('/paypal-payment-success', [BookController::class, 'paypalPaymentSuccess'])->name('paypal.payment.success');
Route::get('/strip-payment-success', [BookController::class, 'stripPaymentSuccess'])->name('strip.payment.success');
Route::get('/payment-success-one', [BookController::class, 'successOne'])->name('payment.one');
Route::get('/payment-success', [BookController::class, 'successTwo'])->name('payment.two');
Route::get('/molliesucess/sucesspayment',[BookController::class,'sucesspaymentMollie'])->name('make.sucesspayment.molliesucess');
Route::get('/check-product-user', [BookController::class, 'checkProductUser'])->name('new-txt');
Route::post('/get-customer', [StaffController::class, 'getCustomer']);
Route::post('/get-staff-slot', [StaffController::class, 'getStaffSlot']);
Route::post('/staff/payment', [StaffController::class, 'payment']);
Route::post('/get-branch', [ProviderController::class, 'getBranchStaff']);
Route::post('/get-customer-provider', [ProviderController::class, 'getCustomer']);
Route::post('/fetch-staff-service', [ProviderController::class, 'fetchStaffService']);
Route::post('/provider/calender/booking', [ProviderController::class, 'providerCalenderBooking']);
Route::post('/leads/transaction-list', [TransactionController::class, 'leadsTransactionList']);

Route::get('/set-password/{id}', [UserController::class, 'setPassword'])->name('set-password');
Route::post('/update-password', [UserController::class, 'updatePassword']);
Route::get('/get-staff', [ProviderController::class, 'getStaffDetails']);
Route::post('/get/booking/details',[BookingController::class, 'getBookingDetails'])->name('user.getBookingDetails');

Route::get('/clear', function () {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('config:clear');
    Artisan::call('optimize:clear');
    return redirect()->route('admin.addons');
})->middleware('admin.auth');

Route::get('/reload/{module}', function (Request $request) {
    $module = $request->module;
    Artisan::call('module:enable '. $module);
    return redirect()->route('admin.addons');
})->middleware('admin.auth');

// Social Links
Route::get('/provider/social-links', [ProviderSocialLinkController::class, 'providerSocialLinkIndex'])
    ->name('provider.sociallinks.index');
Route::get('/provider/get/social-links', [ProviderSocialLinkController::class, 'getSocialLinks'])
    ->name('provider.sociallinks.getSocialLinks');
Route::post('/provider/social-links', [ProviderSocialLinkController::class, 'store'])
    ->name('provider.sociallinks.store');
Route::put('/provider/social-links/{providerSocialLink}', [ProviderSocialLinkController::class, 'update'])
    ->name('provider.sociallinks.update');
Route::delete('/provider/social-links/{providerSocialLink}', [ProviderSocialLinkController::class, 'destroy'])
    ->name('provider.sociallinks.destroy');
Route::patch('/provider/social-links/{providerSocialLink}/toggle-status', [ProviderSocialLinkController::class, 'toggleStatus'])
    ->name('provider.sociallinks.toggle-status');
Route::post('/provider/social-links/bulk-update', [ProviderSocialLinkController::class, 'bulkUpdate'])
    ->name('provider.sociallinks.bulkUpdate');

Route::get('/update-module/{module}', [AddonController::class, 'updateModule'])->middleware('admin.auth');

Route::get('/backup', [DbbackupController::class, 'backupDatabase'])->name('backup');
Route::get('download-backup/{id}', [DbbackupController::class, 'downloadDatabaseBackup'])->name('download.backup');

// Paradigm Profile Assessment Routes
Route::prefix('paradigm')->name('paradigm.')->group(function () {
    Route::get('/assessment/{templateId}', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'show'])->name('assessment.show');
    Route::get('/assessment-direct/{paymentLink}', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'showDirect'])->name('assessment.direct');
    Route::post('/assessment/submit', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'submit'])->name('assessment.submit');
    Route::get('/results/{resultId}', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'results'])->name('results');
    Route::get('/results/{resultId}/download-pdf', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'downloadPdf'])->name('results.download-pdf');
    Route::get('/session/{sessionId}', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'getBySession'])->name('session');
    Route::get('/assessment-completion/{resultId?}', [\App\Http\Controllers\Public\ParadigmAssessmentController::class, 'completion'])->name('assessment.completion');
});

// Paradigm Profile Shortcode Handler
Route::get('/paradigm/shortcode', [\App\Http\Controllers\Public\ParadigmShortcodeController::class, 'handleShortcode'])->name('paradigm.shortcode');

// Paradigm Profile Payment Routes
Route::prefix('paradigm/payment')->name('paradigm.payment.')->group(function () {
    Route::post('/generate-link', [\App\Http\Controllers\ParadigmPaymentController::class, 'generatePaymentLink'])->name('generate-link');
    Route::post('/process-completion', [\App\Http\Controllers\ParadigmPaymentController::class, 'processPaymentCompletion'])->name('process-completion');
    Route::post('/validate-access', [\App\Http\Controllers\ParadigmPaymentController::class, 'validateAccess'])->name('validate-access');
    Route::post('/process-wallet', [\App\Http\Controllers\ParadigmPaymentController::class, 'processWalletPayment'])->name('process-wallet')->middleware('auth');
});

// User Paradigm Payment Page
Route::get('/user/paradigm/payment', function () {
    return view('user.paradigm.payment-required');
})->name('user.paradigm.payment-required')->middleware('auth');

// Paradigm Form Test Page - Updated to use latest assessment system
Route::get('/paradigm/test', function () {
    try {
        $template = \App\Models\ParadigmFormTemplate::where('is_active', true)->first();
        
        if (!$template) {
            // Create a test template if none exists
            $template = \App\Models\ParadigmFormTemplate::create([
                'name' => 'Test Paradigm Form',
                'description' => 'Test form for development',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
        
        // Use the same system as the main assessment route
        $template->load(['questions', 'personalFields']);

        // Get user profile data for auto-population (same as main assessment)
        $userProfile = null;
        if (auth()->check()) {
            $user = auth()->user();
            $userProfile = $user->userDetails;
        }

        return view('paradigm.assessment', [
            'template' => $template,
            'personal_fields' => $template->personalFields->sortBy('display_order'),
            'user_profile' => $userProfile,
        ]);
    } catch (\Exception $e) {
        \Log::error('Paradigm form error: ' . $e->getMessage());
        return view('paradigm.assessment', [
            'template' => null,
            'personal_fields' => collect(),
            'user_profile' => null,
            'error' => 'Error loading form: ' . $e->getMessage()
        ]);
    }
})->name('paradigm.test');

// OTP Routes for Registration
Route::post('/register-otp-settings', [\Modules\Communication\app\Http\Controllers\CommunicationController::class, 'getOtpSettings'])->name('register.otp.settings');
Route::post('/provider-register-otp-settings', [\Modules\Communication\app\Http\Controllers\CommunicationController::class, 'getOtpSettings'])->name('provider.register.otp.settings');

// OTP Verification Routes
Route::post('/verify-otp', [\Modules\Communication\app\Http\Controllers\CommunicationController::class, 'verifyOtp'])->name('verify.otp');
Route::post('/user-verify-otp', [\Modules\Communication\app\Http\Controllers\CommunicationController::class, 'verifyOtp'])->name('user.verify.otp');
Route::post('/provider-verify-otp', [\Modules\Communication\app\Http\Controllers\CommunicationController::class, 'verifyOtp'])->name('provider.verify.otp');

// Staff Document Upload Routes (Provider creates staff with documents)
Route::middleware(['admin.auth', 'auc'])->group(function () {
    Route::post('/provider/staff/upload-id-document', [\App\Http\Controllers\StaffDocumentController::class, 'uploadIdDocument'])->name('provider.staff.upload.id');
    Route::post('/provider/staff/upload-selfie', [\App\Http\Controllers\StaffDocumentController::class, 'uploadSelfie'])->name('provider.staff.upload.selfie');
});

// Admin Branch & Staff Verification Routes
Route::middleware(['admin.auth'])->group(function () {
    Route::get('/admin/branch-verification', [\App\Http\Controllers\Admin\BranchVerificationController::class, 'index'])->name('admin.branch.verification');
    Route::get('/admin/branch-verification/list', [\App\Http\Controllers\Admin\BranchVerificationController::class, 'list'])->name('admin.branch.verification.list');
    Route::post('/admin/branch-verification/verify', [\App\Http\Controllers\Admin\BranchVerificationController::class, 'verify'])->name('admin.branch.verification.verify');
    Route::get('/admin/branch-verification/{id}/details', [\App\Http\Controllers\Admin\BranchVerificationController::class, 'details'])->name('admin.branch.verification.details');
    
    Route::get('/admin/staff-verification', [\App\Http\Controllers\Admin\StaffVerificationController::class, 'index'])->name('admin.staff.verification');
    Route::get('/admin/staff-verification/list', [\App\Http\Controllers\Admin\StaffVerificationController::class, 'list'])->name('admin.staff.verification.list');
    Route::post('/admin/staff-verification/verify', [\App\Http\Controllers\Admin\StaffVerificationController::class, 'verify'])->name('admin.staff.verification.verify');
    Route::get('/admin/staff-verification/{id}/details', [\App\Http\Controllers\Admin\StaffVerificationController::class, 'details'])->name('admin.staff.verification.details');
});

Route::get('/{slug}', [PageController::class, 'pageBuilderApi'])->name('dynamic.page');
