@extends('front')

@section('content')

<!-- Breadcrumb -->
<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{ __('My Credits') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="ti ti-home-2"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Wallet') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="breadcrumb-bg">
            <img src="/assets/img/bg/breadcrumb-bg-01.png" class="breadcrumb-bg-1" alt="Img">
            <img src="/assets/img/bg/breadcrumb-bg-02.png" class="breadcrumb-bg-2" alt="Img">
        </div>
    </div>
</div>
<!-- /Breadcrumb -->

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    
                    <!-- Page Header -->
                    <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
                        <h4>{{ __('My Credits') }}</h4>
                        <div>
                            <a href="{{ route('user.wallet.topup') }}" class="btn btn-primary">
                                <i class="ti ti-plus me-1"></i> {{ __('Buy Credits') }}
                            </a>
                        </div>
                    </div>

                    <!-- Wallet Balance Cards -->
                    <div class="row">
                        <div class="col-lg-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <span class="avatar avatar-lg bg-primary-transparent rounded-circle">
                                                <i class="ti ti-wallet fs-24"></i>
                                            </span>
                                        </div>
                                        <div class="flex-fill">
                                            <p class="text-muted mb-1">{{ __('Current Balance') }}</p>
                                            <h3 class="mb-0" id="walletBalance">
                                                <span class="spinner-border spinner-border-sm" role="status"></span>
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <span class="avatar avatar-lg bg-success-transparent rounded-circle">
                                                <i class="ti ti-trending-up fs-24"></i>
                                            </span>
                                        </div>
                                        <div class="flex-fill">
                                            <p class="text-muted mb-1">{{ __('Total Added') }}</p>
                                            <h3 class="mb-0" id="totalCredit">
                                                <span class="spinner-border spinner-border-sm" role="status"></span>
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <span class="avatar avatar-lg bg-danger-transparent rounded-circle">
                                                <i class="ti ti-trending-down fs-24"></i>
                                            </span>
                                        </div>
                                        <div class="flex-fill">
                                            <p class="text-muted mb-1">{{ __('Total Spent') }}</p>
                                            <h3 class="mb-0" id="totalDebit">
                                                <span class="spinner-border spinner-border-sm" role="status"></span>
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction History -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">{{ __('Transaction History') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped" id="transactionTable">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('Date') }}</th>
                                                    <th>{{ __('Description') }}</th>
                                                    <th>{{ __('Type') }}</th>
                                                    <th>{{ __('Amount') }}</th>
                                                    <th>{{ __('Balance') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody id="transactionTableBody">
                                                <tr>
                                                    <td colspan="5" class="text-center">
                                                        <div class="spinner-border text-primary" role="status">
                                                            <span class="visually-hidden">{{ __('Loading...') }}</span>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- /Page Wrapper -->

<style>
.avatar-lg {
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.bg-primary-transparent {
    background-color: rgba(102, 126, 234, 0.1);
    color: #667eea;
}

.bg-success-transparent {
    background-color: rgba(40, 199, 111, 0.1);
    color: #28c76f;
}

.bg-danger-transparent {
    background-color: rgba(234, 84, 85, 0.1);
    color: #ea5455;
}

.fs-24 {
    font-size: 24px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    loadWalletData();
});

function loadWalletData() {
    fetch('{{ route("user.wallet.data") }}', {
        method: 'GET',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update balance cards
            document.getElementById('walletBalance').innerHTML = 
                `<span class="text-primary">${parseFloat(data.balance).toFixed(0)} Credits</span>`;
            
            document.getElementById('totalCredit').innerHTML = 
                `<span class="text-success">${parseFloat(data.totalCredit).toFixed(0)} Credits</span>`;
            
            document.getElementById('totalDebit').innerHTML = 
                `<span class="text-danger">${parseFloat(data.totalDebit).toFixed(0)} Credits</span>`;

            // Load transaction history
            loadTransactions(data.transactions, data.currency);
        } else {
            console.error('Failed to load wallet data:', data.message);
            showError('Failed to load wallet data');
        }
    })
    .catch(error => {
        console.error('Error loading wallet data:', error);
        showError('Error loading wallet data');
    });
}

function loadTransactions(transactions, currency) {
    const tbody = document.getElementById('transactionTableBody');
    
    if (!transactions || transactions.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="5" class="text-center text-muted">
                    <i class="ti ti-info-circle me-2"></i>{{ __('No transactions yet') }}
                </td>
            </tr>
        `;
        return;
    }

    let html = '';
    let runningBalance = 0;
    
    // Reverse transactions to calculate balance from oldest to newest
    const reversedTransactions = [...transactions].reverse();
    
    reversedTransactions.forEach(transaction => {
        const isCredit = transaction.type == 1;
        const typeIcon = isCredit ? 'ti-arrow-down-circle' : 'ti-arrow-up-circle';
        const typeColor = isCredit ? 'success' : 'danger';
        const typeText = isCredit ? '{{ __("Credit") }}' : '{{ __("Debit") }}';
        
        // Get credits (use credits field if available, fallback to amount for old records)
        const credits = transaction.credits || transaction.amount;
        
        // Update running balance
        if (isCredit) {
            runningBalance += parseFloat(credits);
        } else {
            runningBalance -= parseFloat(transaction.amount);
        }
        
        // For display: credits show price paid, debits show credits spent
        const displayAmount = isCredit ? `R${parseFloat(transaction.amount).toFixed(2)}` : `${parseFloat(transaction.amount).toFixed(0)} Credits`;

        html = `
            <tr>
                <td>${new Date(transaction.created_at).toLocaleDateString('en-US', {
                    year: 'numeric',
                    month: 'short',
                    day: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit'
                })}</td>
                <td>${transaction.description || (transaction.payment_type ? transaction.payment_type.charAt(0).toUpperCase() + transaction.payment_type.slice(1) : '-')}</td>
                <td>
                    <span class="badge bg-${typeColor}-transparent">
                        <i class="ti ${typeIcon} me-1"></i>${typeText}
                    </span>
                </td>
                <td class="text-${typeColor}">
                    ${displayAmount}
                </td>
                <td class="fw-bold">${runningBalance.toFixed(0)} Credits</td>
            </tr>
        ` + html; // Prepend to show newest first
    });

    tbody.innerHTML = html;
}

function showError(message) {
    document.getElementById('walletBalance').innerHTML = 
        `<span class="text-danger">${message}</span>`;
    document.getElementById('totalCredit').innerHTML = 
        `<span class="text-muted">-</span>`;
    document.getElementById('totalDebit').innerHTML = 
        `<span class="text-muted">-</span>`;
    document.getElementById('transactionTableBody').innerHTML = `
        <tr>
            <td colspan="5" class="text-center text-danger">
                <i class="ti ti-alert-circle me-2"></i>${message}
            </td>
        </tr>
    `;
}
</script>
@endsection

