@extends('front')

@section('content')

<!-- Breadcrumb -->
<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{ __('My Requests') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="ti ti-home-2"></i></a></li>
                        <li class="breadcrumb-item">{{ __('Customer') }}</li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('My Requests') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="breadcrumb-bg">
            <img src="/assets/img/bg/breadcrumb-bg-01.png" class="breadcrumb-bg-1" alt="Img">
            <img src="/assets/img/bg/breadcrumb-bg-02.png" class="breadcrumb-bg-2" alt="Img">
        </div>
    </div>
</div>
<!-- /Breadcrumb -->

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
                        <h4>{{ __('All Requests') }}</h4>
                        <div>
                            <button class="btn btn-outline-primary" id="refreshBtn">
                                <i class="ti ti-refresh me-1"></i>{{ __('Refresh') }}
                            </button>
                        </div>
                    </div>

                    <!-- Filter Tabs -->
                    <ul class="nav nav-tabs mb-4" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-status="" data-bs-toggle="tab">{{ __('All') }}</button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-status="pending" data-bs-toggle="tab">{{ __('Pending') }}</button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-status="unlocked" data-bs-toggle="tab">{{ __('Unlocked') }}</button>
                        </li>
                    </ul>

                    <!-- Requests Grid -->
                    <div class="row" id="requestsGrid">
                        <div class="col-12">
                            <div class="text-center py-5">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">{{ __('Loading...') }}</span>
                                </div>
                                <p class="mt-3 text-muted">{{ __('Loading your requests...') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Pagination -->
                    <nav id="paginationNav" class="mt-4"></nav>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Request Details Modal -->
<div class="modal fade" id="requestDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Request Details') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="requestDetailsContent">
                <!-- Content loaded via AJAX -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                <button type="button" class="btn btn-danger d-none" id="cancelRequestBtn" data-bs-toggle="modal" data-bs-target="#cancelConfirmModal">
                    <i class="ti ti-x me-1"></i>{{ __('Cancel Request') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Interested Providers Modal -->
<div class="modal fade" id="providersModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Interested Providers') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="providersContent">
                <!-- Content loaded via AJAX -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Connection Response Modal -->
<div class="modal fade" id="connectionResponseModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Respond to Connection Request') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="connectionProviderInfo"></div>
                <div class="mb-3">
                    <label class="form-label">{{ __('Message to Provider (Optional)') }}</label>
                    <textarea class="form-control" id="connectionMessage" rows="3" placeholder="{{ __('Add a message...') }}"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-danger" id="declineConnectionBtn">
                    <i class="ti ti-x me-1"></i>{{ __('Decline') }}
                </button>
                <button type="button" class="btn btn-success" id="acceptConnectionBtn">
                    <i class="ti ti-check me-1"></i>{{ __('Accept Connection') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Request Confirmation Modal -->
<div class="modal fade" id="cancelConfirmModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Cancel Request') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>{{ __('Are you sure you want to cancel this request? This action cannot be undone.') }}</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('No, Keep It') }}</button>
                <button type="button" class="btn btn-danger" id="confirmCancelBtn">
                    <i class="ti ti-x me-1"></i>{{ __('Yes, Cancel Request') }}
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="{{ asset('assets/js/client-submitted-requests.js') }}"></script>
@endpush
