@extends('front')
@section('title', __('Join as Provider') . ' - ' . $companyName)
@section('description', __('Register as a service provider'))
@section('keywords', __('provider, register, join'))
@section('content')
<div class="provider-register-account-page" style="min-height: 80vh; padding: 4rem 0;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-10 col-lg-9 col-xl-8">
                <div class="provider-register-card" style="background: #ffffff; border-radius: 12px; padding: 3rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);">
                    <!-- Use the original provider modal form content directly (without modal wrapper) -->
                    <div class="wizard-fieldset">
                        <fieldset class="first-field" id="first-field">
                            <form id="providerRegister" class="provider-registration-form" autocomplete="off">
                                {{ csrf_field() }}

                                <div class="mb-4">
                                    <div class="text-center mb-4">
                                        <h3 class="mb-2" style="color: #044f54; font-weight: 700;">{{ __('Registration') }}</h3>
                                        <p style="color: #6b7280;">{{ __('Enter your credentials to access your account') }}</p>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('first_name') }}<span class="text-danger"> *</span></label>
                                                <input type="text" name="provider_first_name" id="provider_first_name"
                                                    class="form-control" placeholder="{{ __('Enter First Name') }}" required>
                                                <div class="invalid-feedback" id="provider_first_name_error"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('last_name') }}<span class="text-danger"> *</span></label>
                                                <input type="text" name="provider_last_name" id="provider_last_name"
                                                    class="form-control" placeholder="{{ __('Enter Last Name') }}" required>
                                                <div class="invalid-feedback" id="provider_last_name_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('user_name') }}<span class="text-danger"> *</span></label>
                                                <input type="text" name="provider_name" id="provider_name"
                                                    class="form-control" placeholder="{{ __('Enter Name') }}" required>
                                                <div class="invalid-feedback" id="provider_name_error"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('email') }}<span class="text-danger"> *</span></label>
                                                <input type="email" name="provider_email" id="provider_email"
                                                    class="form-control" placeholder="{{ __('Enter Email') }}" required>
                                                <div class="invalid-feedback" id="provider_email_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('phone_number') }}<span class="text-danger"> *</span></label>
                                                <input class="form-control" id="provider_phone_number"
                                                    name="provider_phone_number" maxlength="12" type="text"
                                                    placeholder="{{ __('Enter Phone Number') }}" autocomplete="tel" required>
                                                <small class="text-muted">Please enter full number without country code</small>
                                                <div class="invalid-feedback" id="provider_phone_number_error"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <div class="d-flex align-items-center justify-content-between flex-wrap">
                                                    <label class="form-label">{{ __('Password') }}<span class="text-danger"> *</span></label>
                                                </div>
                                                <div class="input-group">
                                                    <input type="password" name="provider_password" id="provider_password"
                                                        class="form-control" placeholder="{{ __('Enter Password') }}"
                                                        autocomplete="current-password" required>
                                                    <button class="btn btn-outline-dark" type="button"
                                                        id="providerTogglePassword" tabindex="-1">
                                                        <i class="fas fa-eye" id="toggleIcon"></i>
                                                    </button>
                                                </div>
                                                <div class="invalid-feedback" id="provider_password_error"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Profile Picture -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Profile Picture') }} <span class="text-danger">*</span></label>
                                                <div class="profile-picture-upload" id="profile-picture-upload" style="border: 2px dashed #ddd; border-radius: 8px; padding: 2rem; text-align: center; cursor: pointer; transition: all 0.3s ease; background-color: #f9f9f9;">
                                                    <div id="profile-picture-preview" style="display: none;">
                                                        <img id="profile-preview-img" class="profile-picture-preview" alt="Profile Preview" style="max-width: 200px; max-height: 200px; border-radius: 8px; object-fit: cover;">
                                                    </div>
                                                    <div id="profile-picture-placeholder">
                                                        <i class="ti ti-camera fs-48 text-muted mb-3"></i>
                                                        <p class="mb-2">{{ __('Upload Profile Picture') }}</p>
                                                        <p class="small text-muted">{{ __('Drag & drop or click to browse') }}</p>
                                                        <p class="small text-muted">{{ __('Recommended: 400x400px, Max 2MB') }}</p>
                                                    </div>
                                                    <input type="file" name="provider_profile_image" id="provider_profile_image" 
                                                           accept="image/*" style="display: none;">
                                                </div>
                                                <style>
                                                .profile-picture-upload:hover {
                                                    border-color: #044f54 !important;
                                                    background-color: #f0f8f9 !important;
                                                }
                                                .profile-picture-upload.dragover {
                                                    border-color: #044f54 !important;
                                                    background-color: #e8f4f5 !important;
                                                }
                                                </style>
                                                <div class="invalid-feedback" id="provider_profile_image_error"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Personal Information -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('date_of_birth') }}<span class="text-danger"> *</span></label>
                                                <input type="date" name="provider_dob" id="provider_dob"
                                                    class="form-control" placeholder="{{ __('Select Date of Birth') }}"
                                                    max="{{ date('Y-m-d', strtotime('-1 day')) }}">
                                                <div class="invalid-feedback" id="provider_dob_error"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('gender') }}<span class="text-danger"> *</span></label>
                                                <select name="provider_gender" id="provider_gender" class="form-control">
                                                    <option value="">{{ __('Select Gender') }}</option>
                                                    <option value="male">{{ __('Male') }}</option>
                                                    <option value="female">{{ __('Female') }}</option>
                                                </select>
                                                <div class="invalid-feedback" id="provider_gender_error"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Bio -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('your_bio') }}</label>
                                                <textarea name="provider_bio" id="provider_bio" class="form-control" rows="5"
                                                    placeholder="{{ __('Tell us about yourself...') }}"></textarea>
                                                <div class="d-flex justify-content-between align-items-center mt-1">
                                                    <small class="text-muted">Optional - Maximum 3000 characters</small>
                                                    <small id="bio_char_count" class="text-muted">0 / 3000</small>
                                                </div>
                                                <div class="invalid-feedback" id="provider_bio_error"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Address Information -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('address') }}<span class="text-danger"> *</span></label>
                                                <input type="text" name="provider_address" id="provider_address"
                                                    class="form-control" placeholder="{{ __('Enter Address') }}" maxlength="150" autocomplete="off" required>
                                                <div class="invalid-feedback" id="provider_address_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('country') }}<span class="text-danger"> *</span></label>
                                                <select class="select form-control" id="provider_country" name="provider_country"
                                                    data-placeholder="{{ __('select_country') }}" required>
                                                </select>
                                                <div class="invalid-feedback" id="provider_country_error"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('state') }}<span class="text-danger"> *</span></label>
                                                <select class="select form-control" id="provider_state" name="provider_state"
                                                    data-placeholder="{{ __('select_state') }}" required>
                                                </select>
                                                <div class="invalid-feedback" id="provider_state_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('city') }}<span class="text-danger"> *</span></label>
                                                <select class="select form-control" id="provider_city" name="provider_city"
                                                    data-placeholder="{{ __('select_city') }}" required>
                                                </select>
                                                <div class="invalid-feedback" id="provider_city_error"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('postal_code') }}<span class="text-danger"> *</span></label>
                                                <input type="text" name="provider_postal_code" id="provider_postal_code"
                                                    class="form-control" placeholder="{{ __('Enter Postal Code') }}" maxlength="10" required>
                                                <div class="invalid-feedback" id="provider_postal_code_error"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Language -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('language') }}<span class="text-danger"> *</span></label>
                                                <select class="form-control select2" id="provider_language" name="provider_language[]" multiple="multiple" data-placeholder="{{ __('Select languages you speak') }}" style="width: 100%;">
                                                    <!-- Options will be loaded dynamically -->
                                                </select>
                                                <small class="text-muted">{{ __('Select all languages you can communicate in') }}</small>
                                                <div class="invalid-feedback" id="provider_language_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-end mb-4">
                                    <button class="btn btn-linear-primary" id="get_started_btn">{{ __('Get Started') }}</button>
                                </div>
                            </form>
                        </fieldset>
                        <fieldset class="second-field" id="second-field" style="display: none;">
                            <form id="companyInfo">
                                <div class="mb-4">
                                    <div class="bg-light-300 p-3 br-10 text-center mb-4">
                                        <h4>{{ __('service_heading') }}</h4>
                                        <p>{{ __('service_description') }}</p>
                                    </div>
                                    <div class="mb-4">
                                        <label class="form-label">{{ __('service_label') }} <span class="text-danger">*</span></label>
                                        <select name="category_id" id="categorySelect" class="form-control select">
                                            <option value="">{{ __('select_category') }}</option>
                                            @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback" id="category_id_error"></div>
                                    </div>
                                    <div class="mb-2">
                                        <label class="form-label">{{ __('sub_service_label') }} <span class="text-danger">*</span></label>
                                        <div class="form-check ps-0" id="subcategories">
                                            <!-- Dynamically populated subcategories go here -->
                                        </div>
                                        <span class="invalid-feedback d-block" id="subcategory_ids_error" style="display: none !important;"></span>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <div class="mb-3">
                                        <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-2">
                                            <div class="form-check">
                                                <input class="form-check-input border-primary border-1" type="checkbox" name="provider_terms_policy"
                                                    id="provider_terms_policy">
                                                <label class="form-check-label" for="provider_terms_policy">
                                                    {{ __('terms_policy_label') }} <a href="{{ route('terms.conditions') }}" target="_blank"
                                                        class="text-primary text-decoration-underline">{{ __('terms_of_use') }}</a>
                                                    & <a href="{{ route('privacy.policy') }}" target="_blank"
                                                        class="text-primary text-decoration-underline">{{ __('privacy_policy') }}</a>
                                                </label>
                                                <div class="invalid-feedback" id="provider_terms_policy_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center justify-content-between">
                                    <a href="#!" class="btn btn-light prev_btn"><i
                                            class="ti ti-arrow-left me-2"></i>{{ __('back_button') }}</a>
                                    <button id="provider_register_btn"
                                        class="provider_register_btn btn btn-linear-primary">{{ __('sign_up_button') }}</button>
                                </div>
                            </form>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- OTP Modals (from original provider_register.blade.php) -->
<div class="modal fade" id="otp-email-prov-reg-modal" tabindex="-1" data-bs-backdrop="static" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-end pb-0 border-0">
                <a href="#!" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ti ti-circle-x-filled fs-20"></i>
                </a>
            </div>
            <div class="modal-body p-4">
                <form action="#" class="digit-group">
                    <div class="text-center mb-3">
                        <h3 class="mb-2">{{ __('Email OTP Verification') }}</h3>
                        <p class="fs-14">{{ __('OTP sent to your Email Address') }}</p>
                    </div>
                    <div class="text-center otp-input">
                        <div class="inputProvideContainerreg"></div>
                        <span id="error_prov_email_reg_message" class="text-danger"></span>
                        <div>
                            <div class="badge bg-danger-transparent mb-3">
                                <p class="d-flex align-items-center "><i class="ti ti-clock me-1"></i><span
                                        id="otp-pro-timer">00:00</span></p>
                            </div>
                            <div class="mb-3 d-flex justify-content-center">
                                <p class="text-muted">{{ __('Please check your email for the OTP code') }}</p>
                            </div>
                            <div>
                                <button type="button" id="verify-email-prov-reg-otp-btn"
                                    class="verify-email-prov-reg-otp-btn btn btn-lg btn-linear-primary w-100">{{ __('Verify & Proceed') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="otp-pro-reg-phone-modal" tabindex="-1" data-bs-backdrop="static" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-end pb-0 border-0">
                <a href="#!" data-bs-dismiss="modal" aria-label="Close"><i
                        class="ti ti-circle-x-filled fs-20"></i></a>
            </div>
            <div class="modal-body p-4">
                <form action="#" class="digit-group">
                    <div class="text-center mb-3">
                        <h3 class="mb-2">{{ __('Phone OTP Verification') }}</h3>
                        <p id="otp-prov-reg-sms-message" class="fs-14">{{ __('OTP sent to your mobile number') }}</p>
                    </div>
                    <div class="text-center otp-input">
                        <div class="inputProRegSMSContainer"></div>
                        <span id="error_pro_reg_sms_message" class="text-danger"></span>
                        <div>
                            <div class="badge bg-danger-transparent mb-3">
                                <p class="d-flex align-items-center "><i class="ti ti-clock me-1"></i><span
                                        id="otp-pro-reg-sms-timer">00:00</span></p>
                            </div>
                            <div class="mb-3 d-flex justify-content-center">
                                <p>{{ __('Didn t get the OTP?') }} <a href="#!"
                                        class="resendProRegSMSOtp text-primary">{{ __('Resend OTP') }}</a></p>
                            </div>
                            <div>
                                <button type="button" id="verify-pro-reg-sms-otp-btn"
                                    class="verify-pro-reg-sms-otp-btn btn btn-lg btn-linear-primary w-100">{{ __('Verify & Proceed') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="reg_success_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="success-icon mx-auto mb-4">
                        <i class="ti ti-check"></i>
                    </span>
                    <h4 class="mb-1">{{ __('Registration Successful') }}</h4>
                    <p>{{ __('registration_success_info')}}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="provider_approval_success_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="success-icon mx-auto mb-4">
                        <i class="ti ti-check"></i>
                    </span>
                    <h4 class="mb-1">{{ __('Registration Successful') }}</h4>
                    <p>{{ __('provider_register_approval_success_info')}}</p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Load location data
    async function loadProviderLocationData() {
        try {
            const [countriesResponse, statesResponse, citiesResponse] = await Promise.all([
                $.getJSON("/countries.json"),
                $.getJSON("/states.json"),
                $.getJSON("/cities.json"),
            ]);

            window.cachedProviderCountries = countriesResponse.countries;
            window.cachedProviderStates = statesResponse.states;
            window.cachedProviderCities = citiesResponse.cities;
            
            window.cachedCountries = countriesResponse.countries;
            window.cachedStates = statesResponse.states;
            window.cachedCities = citiesResponse.cities;
            window.locationDataLoaded = true;

            const countrySelect = $("#provider_country");
            countrySelect.empty().append('<option value="" disabled selected>{{ __('Select Country') }}</option>');
            
            $.each(countriesResponse.countries, function (index, country) {
                countrySelect.append($("<option>", {
                    value: country.name,
                    text: country.name,
                    'data-id': country.id,
                }));
            });
            
            // Auto-select South Africa (same as homepage modal logic)
            setTimeout(function() {
                const countrySelectElement = document.querySelector("#provider_country");
                if (countrySelectElement) {
                    let attempts = 0;
                    const trySelectCountry = () => {
                        attempts++;
                        const options = countrySelectElement.options;
                        
                        if (options.length > 1) {
                            // Look for South Africa option
                            for (let i = 0; i < options.length; i++) {
                                if (options[i].text === 'South Africa') {
                                    countrySelectElement.value = options[i].value;
                                    countrySelectElement.dispatchEvent(new Event('change'));
                                    console.log('✅ Auto-selected South Africa in provider registration country dropdown');
                                    break;
                                }
                            }
                        } else if (attempts < 10) {
                            setTimeout(trySelectCountry, 500);
                        }
                    };
                    trySelectCountry();
                }
            }, 1000);
        } catch (error) {
            console.error("Failed to load location data:", error);
        }
    }
    
    // Load location data immediately
    loadProviderLocationData();
    
    // Handle country/state/city changes (same as provider-register.js)
    $("#provider_country").on("change", function () {
        const selectedCountryName = $(this).val();
        const selectedCountryId = $(this).find('option:selected').data('id');
        const stateSelect = $("#provider_state");
        const citySelect = $("#provider_city");
        
        stateSelect.empty().append('<option value="" disabled selected>{{ __('Select State') }}</option>');
        citySelect.empty().append('<option value="" disabled selected>{{ __('Select City') }}</option>');
        
        if (selectedCountryId) {
            const statesData = window.cachedProviderStates || window.cachedStates;
            if (statesData) {
                const states = statesData.filter(state => state.country_id == selectedCountryId);
                states.sort((a, b) => a.name.localeCompare(b.name));
                
                if (states.length === 1) {
                    stateSelect.append($("<option>", {
                        value: states[0].name,
                        text: states[0].name,
                        'data-id': states[0].id,
                        selected: true,
                    }));
                    // Auto-load cities for single state
                    const citiesData = window.cachedProviderCities || window.cachedCities;
                    if (citiesData) {
                        const cities = citiesData.filter(city => city.state_id == states[0].id);
                        cities.sort((a, b) => a.name.localeCompare(b.name));
                        $.each(cities, function (index, city) {
                            citySelect.append($("<option>", {
                                value: city.name,
                                text: city.name,
                                'data-id': city.id,
                            }));
                        });
                    }
                } else {
                    $.each(states, function (index, state) {
                        stateSelect.append($("<option>", {
                            value: state.name,
                            text: state.name,
                            'data-id': state.id,
                        }));
                    });
                }
            }
        }
    });

    $("#provider_state").on("change", function () {
        const selectedStateId = $(this).find('option:selected').data('id');
        const citySelect = $("#provider_city");
        
        citySelect.empty().append('<option value="" disabled selected>{{ __('Select City') }}</option>');
        
        if (selectedStateId) {
            const citiesData = window.cachedProviderCities || window.cachedCities;
            if (citiesData) {
                const cities = citiesData.filter(city => city.state_id == selectedStateId);
                cities.sort((a, b) => a.name.localeCompare(b.name));
                $.each(cities, function (index, city) {
                    citySelect.append($("<option>", {
                        value: city.name,
                        text: city.name,
                        'data-id': city.id,
                    }));
                });
            }
        }
    });
});
</script>
@endpush
@endsection
