<header class="header header-new">
    <div class="container-fluid">
        <nav class="navbar navbar-expand-lg header-nav">
            <div class="navbar-header" style="display: flex; align-items: center; height: 100%;">
                <a href="{{ route('home') }}" class="navbar-brand logo" style="display: flex; align-items: center; height: 100%;">
                    <img src="{{ $dynamicLogo }}" class="img-fluid" alt="Logo" style="max-height: 50px; height: 50px; object-fit: contain; width: auto;">
                </a>
            </div>

            <div style="flex: 1;"></div>

            <div class="header-btn d-flex align-items-center">
                <div class="provider-head-links">
                    <ul class="main-nav align-items-lg-center list-menus">
                        <li>
                            <div class="dropdown">
                                <button class="btn dropdown-toggle d-flex align-items-center language-selects"
                                    type="button"  data-bs-toggle="dropdown" aria-expanded="false"
                                    @if (request()->routeIs('user.booking.location.service_booking') ||
                                    request()->routeIs('user.booking.service_booking'))
                                    style="display:none !important"
                                    @endif>

                                    @php
                                    $selectedLanguage = $languages->firstWhere('id', $selectedLanguageId);
                                    @endphp

                                    <span class="fw-bold">{{ strtoupper($selectedLanguage->code ?? 'EN') }}</span>
                                </button>

                                <ul class="dropdown-menu" aria-labelledby="languageDropdown">
                                    @forelse ($languages as $language)
                                    <li>
                                        <a class="dropdown-item d-flex align-items-center language-select languageImg"
                                            data-id="{{ $language->id }}" href="#!">
                                            <span class="fw-bold me-2" style="min-width: 30px;">{{ strtoupper($language->code) }}</span>
                                            {{ $language->name }}
                                        </a>
                                    </li>
                                    @empty
                                    <li>
                                        <span class="dropdown-item disabled">{{ __('Languages unavailable') }}</span>
                                    </li>
                                    @endforelse
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>


                @if (!empty(Auth::id()))

                <div class="provider-head-links">
                </div>
                <div class="dropdown" style="position: relative;">
                    <a href="#!" data-bs-toggle="dropdown" aria-expanded="false" class="">
                        <div class="booking-user d-flex align-items-center">
                            <span class="user-img">
                                @if (!empty(Auth::user()->userDetails->profile_image) &&
                                file_exists(public_path('storage/profile/' . Auth::user()->userDetails->profile_image)))
                                <img src="{{ optional(Auth::user()->userDetails)->profile_image ? asset('storage/profile/' . Auth::user()->userDetails->profile_image) : asset('assets/img/profile-default.png') }}"
                                    class="headerProfileImg" alt="user" style="border-radius: 8px !important; border: 2px solid #e5e7eb !important; width: 38px !important; height: 38px !important; object-fit: cover !important;">
                                @else
                                <img src="{{ asset('assets/img/profile-default.png') }}" alt="Default Profile Image"
                                    class="img-fluid headerProfileImg" style="border-radius: 8px !important; border: 2px solid #e5e7eb !important; width: 38px !important; height: 38px !important; object-fit: cover !important;">
                                @endif
                            </span>
                        </div>
                    </a>
                    @php
                    $dashboardRoute = route('provider.dashboard');
                    $profileRoute = route('provider.profile');

                    if (Auth::user()->user_type == 3) {
                    $dashboardRoute = route('user.dashboard');
                    } elseif (Auth::user()->user_type == 4) {
                    $dashboardRoute = route('staff.dashboard');
                    }
                    @endphp
                    <ul class="dropdown-menu p-2 " style="position: absolute; left: -7rem;">
                        @if(isset($permission) && Auth::user()->user_type == 4)
                        <li><a class="dropdown-item d-flex align-items-center" href="{{ $dashboardRoute }}">
                                <i class="ti ti-layout-grid me-1"></i>{{ __('Dashboard') }}</a>
                        </li>
                        <li><a class="dropdown-item d-flex align-items-center" href="{{ route('provider.profile') }}"><i
                                    class="ti ti-user me-1"></i>{{ __('My Profile') }}</a></li>
                        @else
                        <li><a class="dropdown-item d-flex align-items-center" href="{{ $dashboardRoute }}">
                                <i class="ti ti-layout-grid me-1"></i>{{ __('Dashboard') }}</a>
                        </li>
                        <li><a class="dropdown-item d-flex align-items-center"
                                href="{{ (Auth::user()->user_type == 3) ? route('user.profile') : route('provider.profile') }}"><i
                                    class="ti ti-user me-1"></i>{{ __('My Profile') }}</a></li>
                        @endif
                        <li><a class="dropdown-item d-flex align-items-center logoutUser"
                                href="{{ route('logout') }}"><i class="ti ti-logout me-1"></i>{{ __('Logout') }}</a>
                        </li>
                    </ul>
                </div>
                @endif
            </div>
        </nav>
        
        <!-- Search Form in Header - Simple version that works on all pages -->
        @if(false)
        @if (request()->routeIs('home'))
        <!-- Search Toggle Button -->
        <div class="search-toggle-container text-center py-2" style="background-color: #044f54; width: 100vw; margin-left: calc(-50vw + 50%); margin-right: calc(-50vw + 50%); border-radius: 0 0 1rem 1rem;">
            <button id="searchToggleBtn" class="btn btn-sm" style="background-color: white; color: black; padding: 0.5rem 1.5rem;">
                <i class="feather-search me-2"></i>Open To Search
            </button>
        </div>
        
        <div class="header-search-form border-top py-1" id="searchFormContainer" style="background-color: #044f54; width: 100vw; margin-left: calc(-50vw + 50%); margin-right: calc(-50vw + 50%); border-radius: 0 0 1rem 1rem; display: none; position: relative;">
            <button id="searchCloseBtn" class="btn">
                <i class="feather-x"></i> Close
            </button>
            <div class="container">
                <div class="header-search-container d-flex justify-content-center">
                    <style>
                    .header-search-form .input-group {
                        display: flex !important;
                        align-items: stretch !important;
                        width: 100% !important;
                    }
                    .header-search-form .input-group-text {
                        display: flex !important;
                        align-items: center !important;
                        padding: 0.375rem 0.75rem !important;
                        background-color: #f8f9fa !important;
                        border: 1px solid #ced4da !important;
                        border-right: none !important;
                        border-radius: 0.375rem 0 0 0.375rem !important;
                        position: relative !important;
                        z-index: 1 !important;
                    }
                    .header-search-form .form-control {
                        border-left: none !important;
                        border-radius: 0 0.375rem 0.375rem 0 !important;
                        position: relative !important;
                        z-index: 1 !important;
                    }
                    .header-search-form .search-button .btn:hover {
                        background-color: #f0f0f0 !important;
                        border-color: #f0f0f0 !important;
                        color: black !important;
                    }
                    .header .nav-link.btn[data-bs-target="#register-modal"]:hover {
                        background-color: #033a3e !important;
                        border-color: #033a3e !important;
                        color: white !important;
                    }
                    .header .nav-link.btn[data-bs-target="#login-modal"] {
                        background-color: #044f54 !important;
                        border-color: #044f54 !important;
                        color: white !important;
                    }
                    .header .nav-link.btn[data-bs-target="#login-modal"]:hover {
                        background-color: #033a3e !important;
                        border-color: #033a3e !important;
                        color: white !important;
                    }
                    #login-modal .btn-linear-primary {
                        background-color: #044f54 !important;
                        border-color: #044f54 !important;
                        color: white !important;
                    }
                    #login-modal .btn-linear-primary:hover {
                        background-color: #033a3e !important;
                        border-color: #033a3e !important;
                        color: white !important;
                    }
                    .header-search-form .form-label-small {
                        display: none !important;
                    }
                    #searchCloseBtn {
                        display: none;
                    }
                    @media only screen and (max-width: 575.98px) {
                        .search-toggle-container {
                            padding: 0.5rem !important;
                        }
                        #searchToggleBtn {
                            padding: 0.5rem 1rem !important;
                            font-size: 0.9rem !important;
                        }
                        #searchFormContainer {
                            padding: 5rem 1rem 2rem 1rem !important;
                            min-height: 100vh !important;
                            position: fixed !important;
                            top: 0 !important;
                            left: 0 !important;
                            right: 0 !important;
                            bottom: 0 !important;
                            z-index: 9999 !important;
                            overflow-y: auto !important;
                            border-radius: 0 !important;
                        }
                        #searchCloseBtn {
                            display: block !important;
                            position: fixed !important;
                            top: 1rem !important;
                            right: 1rem !important;
                            background-color: white !important;
                            color: black !important;
                            border: none !important;
                            padding: 0.4rem 0.8rem !important;
                            border-radius: 0.5rem !important;
                            font-size: 0.9rem !important;
                            z-index: 10000 !important;
                        }
                    }
                    </style>
                    
                    <!-- Simple Search Form with Labels -->
                    <form id="headerSearchForm" action="{{ route('user.providerlist') }}" method="GET">
                        <div class="d-flex align-items-center flex-wrap gap-2">
                            <!-- Categories -->
                            <div class="form-field-with-label" style="min-width: 180px; max-width: 180px;">
                                <label class="form-label-small">{{ __('Categories') }}</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-search"></i></span>
                                    <select class="form-control" name="category_id" id="headerCategoryDropdown" required>
                                        <option value="" selected disabled>{{ __('Select Category') }}</option>
                                        @php
                                            // Get current language ID
                                            $currentLanguageId = 1; // Default
                                            if (auth()->check() && auth()->user()->user_language_id) {
                                                $currentLanguageId = auth()->user()->user_language_id;
                                            } elseif (Cookie::get('languageId')) {
                                                $currentLanguageId = Cookie::get('languageId');
                                            } else {
                                                $defaultLang = \DB::table('languages')->where('is_default', 1)->first();
                                                if ($defaultLang) $currentLanguageId = $defaultLang->id;
                                            }
                                            
                                            // Get categories for current language
                                            $categories = \DB::table('categories')
                                                ->select('id', 'name', 'slug')
                                                ->where('parent_id', 0)
                                                ->whereNull('deleted_at')
                                                ->where('language_id', $currentLanguageId)
                                                ->where('source_type', 'service')
                                                ->where('status', 1)
                                                ->orderBy('name')
                                                ->limit(20)
                                                ->get();
                                        @endphp
                                        @if($categories->isNotEmpty())
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" data-slug="{{ $category->slug }}">
                                                    {{ $category->name }}
                                                </option>
                                            @endforeach
                                        @else
                                            <option value="" disabled>{{ __('No categories available') }}</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Country -->
                            <div class="form-field-with-label" style="min-width: 180px; max-width: 180px;">
                                <label class="form-label-small">{{ __('Country') }}</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-flag"></i></span>
                                    <select class="form-control" name="country" id="headerCountryDropdown" required>
                                        <option value="" selected disabled>{{ __('Select Country') }}</option>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- State -->
                            <div class="form-field-with-label" style="min-width: 180px; max-width: 180px;">
                                <label class="form-label-small">{{ __('State') }}</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-map-2"></i></span>
                                    <select class="form-control" name="state" id="headerStateDropdown">
                                        <option value="" selected disabled>{{ __('Select State') }}</option>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- City -->
                            <div class="form-field-with-label" style="min-width: 180px; max-width: 180px;">
                                <label class="form-label-small">{{ __('City') }}</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-map-pin"></i></span>
                                    <select class="form-control" name="city" id="headerCityDropdown">
                                        <option value="" selected disabled>{{ __('Select City') }}</option>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Search Button -->
                            <div class="search-button">
                                <button type="submit" class="btn d-inline-flex align-items-center" style="background-color: white; border-color: white; color: black;">
                                    <i class="feather-search me-2"></i>
                                    {{ __('Search') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @endif
        
        <!-- JavaScript for Header Search Form -->
        @if (request()->routeIs('home'))
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle search form visibility
            const searchToggleBtn = document.getElementById('searchToggleBtn');
            const searchFormContainer = document.getElementById('searchFormContainer');
            const searchToggleContainer = document.querySelector('.search-toggle-container');
            const searchCloseBtn = document.getElementById('searchCloseBtn');
            
            searchToggleBtn.addEventListener('click', function() {
                searchFormContainer.style.display = 'block';
                searchToggleContainer.style.display = 'none';
            });
            
            searchCloseBtn.addEventListener('click', function() {
                searchFormContainer.style.display = 'none';
                searchToggleContainer.style.display = 'block';
            });
            
            const headerSearchForm = document.getElementById('headerSearchForm');
            const categoryDropdown = document.getElementById('headerCategoryDropdown');
            const countryDropdown = document.getElementById('headerCountryDropdown');
            const stateDropdown = document.getElementById('headerStateDropdown');
            const cityDropdown = document.getElementById('headerCityDropdown');
            
            let cachedCountriesHeader = [];
            let cachedStatesHeader = [];
            let cachedCitiesHeader = [];
            let locationDataLoadedHeader = false;
            
            // Load location data from JSON files (same as hero section)
            async function loadHeaderLocationData() {
                try {
                    const [countriesResponse, statesResponse, citiesResponse] = await Promise.all([
                        fetch('/countries.json').then(r => r.json()),
                        fetch('/states.json').then(r => r.json()),
                        fetch('/cities.json').then(r => r.json())
                    ]);

                    cachedCountriesHeader = countriesResponse.countries || [];
                    cachedStatesHeader = statesResponse.states || [];
                    cachedCitiesHeader = citiesResponse.cities || [];

                    locationDataLoadedHeader = true;
                    populateHeaderCountries();
                } catch (error) {
                    console.error('Error loading header location data:', error);
                    // If JSON files fail, populate with basic countries
                    populateHeaderCountriesFallback();
                }
            }
            
            // Fallback function to populate countries if JSON fails
            function populateHeaderCountriesFallback() {
                if (!countryDropdown) return;
                
                const basicCountries = [
                    {id: 1, name: 'South Africa'},
                    {id: 2, name: 'United States'},
                    {id: 3, name: 'United Kingdom'},
                    {id: 4, name: 'Canada'},
                    {id: 5, name: 'Australia'},
                    {id: 6, name: 'Germany'},
                    {id: 7, name: 'France'},
                    {id: 8, name: 'Italy'},
                    {id: 9, name: 'Spain'},
                    {id: 10, name: 'Netherlands'}
                ];
                
                countryDropdown.innerHTML = '<option value="" selected disabled>{{ __('Select Country') }}</option>';
                
                basicCountries.forEach(country => {
                    const option = document.createElement('option');
                    option.value = country.name;
                    option.textContent = country.name;
                    option.dataset.id = country.id;
                    countryDropdown.appendChild(option);
                });
                
                // Auto-select South Africa
                const saOption = Array.from(countryDropdown.options).find(opt => opt.value === 'South Africa');
                if (saOption) {
                    saOption.selected = true;
                }
            }
            
            function populateHeaderCountries(selectedCountry = null) {
                if (!countryDropdown) return;
                
                countryDropdown.innerHTML = '<option value="" selected disabled>{{ __('Select Country') }}</option>';
                
                cachedCountriesHeader.forEach(country => {
                    const option = document.createElement('option');
                    option.value = country.name;
                    option.textContent = country.name;
                    option.dataset.id = country.id;
                    if (country.name === selectedCountry) {
                        option.selected = true;
                    }
                    countryDropdown.appendChild(option);
                });
                
                // Auto-select South Africa
                if (!selectedCountry) {
                    const saOption = Array.from(countryDropdown.options).find(opt => opt.value === 'South Africa');
                    if (saOption) {
                        saOption.selected = true;
                        const saId = saOption.dataset.id;
                        if (saId) {
                            populateHeaderStates(saId);
                        }
                    }
                }
            }
            
            function populateHeaderStates(selectedCountryId, selectedState = null) {
                if (!stateDropdown) return;
                
                stateDropdown.innerHTML = '<option value="" selected disabled>{{ __('Select State') }}</option>';
                cityDropdown.innerHTML = '<option value="" selected disabled>{{ __('Select City') }}</option>';
                
                const states = cachedStatesHeader.filter(state => state.country_id == selectedCountryId);
                
                states.forEach(state => {
                    const option = document.createElement('option');
                    option.value = state.name;
                    option.textContent = state.name;
                    option.dataset.id = state.id;
                    if (state.name === selectedState) {
                        option.selected = true;
                    }
                    stateDropdown.appendChild(option);
                });
            }
            
            function populateHeaderCities(selectedStateId, selectedCity = null) {
                if (!cityDropdown) return;
                
                cityDropdown.innerHTML = '<option value="" selected disabled>{{ __('Select City') }}</option>';
                
                const cities = cachedCitiesHeader.filter(city => city.state_id == selectedStateId);
                
                cities.forEach(city => {
                    const option = document.createElement('option');
                    option.value = city.name;
                    option.textContent = city.name;
                    option.dataset.id = city.id;
                    if (city.name === selectedCity) {
                        option.selected = true;
                    }
                    cityDropdown.appendChild(option);
                });
            }
            
            // Load location data on page load
            loadHeaderLocationData();
            
            // Fallback: If countries don't load within 3 seconds, use fallback
            setTimeout(() => {
                if (!locationDataLoadedHeader && countryDropdown && countryDropdown.options.length <= 1) {
                    populateHeaderCountriesFallback();
                }
            }, 3000);
            
            // Handle form submission
            if (headerSearchForm) {
                headerSearchForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    
                    const categoryId = categoryDropdown.value;
                    const country = countryDropdown.value;
                    const state = stateDropdown.value;
                    const city = cityDropdown.value;
                    
                    if (!categoryId) {
                        alert('Please select a category');
                        return;
                    }
                    
                    // Build URL with parameters
                    let url = '{{ route("user.providerlist") }}?category_id=' + categoryId;
                    
                    if (country) url += '&country=' + encodeURIComponent(country);
                    if (state) url += '&state=' + encodeURIComponent(state);
                    if (city) url += '&city=' + encodeURIComponent(city);
                    
                    // Redirect to provider list
                    window.location.href = url;
                });
            }
            
            // Country change event
            if (countryDropdown) {
                countryDropdown.addEventListener('change', function() {
                    const selectedCountryId = this.options[this.selectedIndex].dataset.id;
                    if (selectedCountryId) {
                        populateHeaderStates(selectedCountryId);
                    }
                });
            }
            
            // State change event
            if (stateDropdown) {
                stateDropdown.addEventListener('change', function() {
                    const selectedStateId = this.options[this.selectedIndex].dataset.id;
                    if (selectedStateId) {
                        populateHeaderCities(selectedStateId);
                    }
                });
            }
        });
        </script>
        @endif
        @endif
    </div>
</header>
<!-- /Header -->