@extends('front')

@section('content')

<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{__('Payment Required')}}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{__('Dashboard')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.paradigm.assessments') }}">{{__('Assessments')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Payment')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    
                    <!-- Assessment Info Card -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="avatar avatar-lg bg-primary-transparent rounded-circle me-3">
                                    <i class="ti ti-brain fs-24 text-primary"></i>
                                </div>
                                <div>
                                    <h5 class="mb-1" id="assessment_name">{{ __('Loading...') }}</h5>
                                    <p class="text-muted mb-0" id="assessment_description"></p>
                                </div>
                            </div>
                            
                            <div class="alert alert-info mb-0">
                                <i class="ti ti-info-circle me-2"></i>
                                {{ __('Payment is required to access this assessment. Choose your preferred payment method below.') }}
                            </div>
                        </div>
                    </div>

                    <!-- Wallet Balance Card -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1">{{ __('Your Wallet Balance') }}</p>
                                    <h3 class="mb-0" id="wallet_balance">
                                        <span class="spinner-border spinner-border-sm" role="status"></span>
                                    </h3>
                                </div>
                                <div>
                                    <a href="{{ route('user.wallet') }}" class="btn btn-outline-primary btn-sm">
                                        <i class="ti ti-wallet me-1"></i>{{ __('Manage Wallet') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Card -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">{{ __('Payment') }}</h5>
                        </div>
                        <div class="card-body">
                            
                            <!-- Payment Amount -->
                            <div class="border-bottom pb-3 mb-3">
                                <div class="d-flex justify-content-between">
                                    <h6>{{ __('Assessment Fee') }}:</h6>
                                    <h5 class="text-primary mb-0" id="payment_amount">
                                        <span class="spinner-border spinner-border-sm" role="status"></span>
                                    </h5>
                                </div>
                            </div>

                            <!-- Wallet Payment - ONLY OPTION -->
                            <div class="payment-info p-4 bg-light rounded mb-3">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="ti ti-wallet fs-32 text-primary me-3"></i>
                                    <div>
                                        <h5 class="mb-1">{{ __('Pay with Your Wallet') }}</h5>
                                        <p class="text-muted mb-0 small">{{ __('Payment will be deducted from your wallet balance') }}</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-muted">{{ __('Your Balance:') }}</span>
                                    <strong id="wallet_balance_display">
                                        <span class="spinner-border spinner-border-sm" role="status"></span>
                                    </strong>
                                </div>
                            </div>
                            
                            <!-- Insufficient Balance Warning -->
                            <div id="insufficient_wallet_warning" class="alert alert-warning" style="display: none;">
                                <i class="ti ti-alert-triangle me-2"></i>
                                <strong>{{ __('Insufficient Balance') }}</strong>
                                <p class="mb-2 small">{{ __('Your wallet balance is insufficient to pay for this assessment.') }}</p>
                                <p class="mb-0 small">{{ __('Please top up your wallet using the existing wallet system (Stripe/PayPal available for top-up).') }}</p>
                                <a href="{{ route('user.wallet') }}" class="btn btn-sm btn-warning mt-3">
                                    <i class="ti ti-plus me-1"></i>{{ __('Go to Wallet & Top Up') }}
                                </a>
                            </div>

                            <!-- Proceed Button -->
                            <button type="button" class="btn btn-primary btn-lg w-100 mt-3" id="proceedPaymentBtn">
                                <i class="ti ti-wallet me-2"></i>{{ __('Pay with Wallet') }}
                            </button>

                            <!-- Cancel Link -->
                            <div class="text-center mt-3">
                                <a href="{{ route('user.paradigm.assessments') }}" class="text-muted">
                                    {{ __('Cancel and return to assessments') }}
                                </a>
                            </div>
                            
                            <!-- Info Box -->
                            <div class="alert alert-info mt-3 mb-0">
                                <i class="ti ti-info-circle me-2"></i>
                                <small>{{ __('Note: Assessment payments are only processed through wallet. You can top up your wallet anytime using Stripe or PayPal.') }}</small>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<style>
.form-check-input:checked + label .border {
    border-color: #667eea !important;
    border-width: 2px !important;
    background-color: rgba(102, 126, 234, 0.05);
}

.avatar-lg {
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.bg-primary-transparent {
    background-color: rgba(102, 126, 234, 0.1);
    color: #667eea;
}

.fs-24 {
    font-size: 24px;
}

.fs-32 {
    font-size: 32px;
}
</style>

@endsection

@push('scripts')
<script>
let paymentData = {};
let walletBalance = 0;

$(document).ready(function() {
    // Get access token from URL or session
    const urlParams = new URLSearchParams(window.location.search);
    const accessToken = urlParams.get('token') || '{{ session("access_token") }}';
    
    if (!accessToken) {
        window.location.href = '{{ route("user.paradigm.assessments") }}';
        return;
    }
    
    // Load payment details
    loadPaymentDetails(accessToken);
    
    // Proceed to wallet payment (ONLY option)
    $('#proceedPaymentBtn').on('click', function() {
        processWalletPayment(accessToken);
    });
});

function loadPaymentDetails(accessToken) {
    $.ajax({
        url: '{{ route("paradigm.payment.validate-access") }}',
        method: 'POST',
        data: {
            access_token: accessToken,
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                paymentData = response.data;
                
                // Update UI
                $('#assessment_name').text(paymentData.template.name);
                $('#assessment_description').text(paymentData.template.description || '');
                
                // If payment already completed, redirect to assessment
                if (paymentData.payment_status === 'completed') {
                    window.location.href = `/paradigm/assessment/${paymentData.template.id}?token=${accessToken}`;
                    return;
                }
                
                // Load wallet balance
                loadWalletBalance();
                
                // Show payment amount
                const currency = paymentData.currency || '$';
                const amount = parseFloat(paymentData.amount || 0);
                $('#payment_amount').html(`<span class="text-primary">${currency}${amount.toFixed(2)}</span>`);
                
            } else {
                toastr.error(response.message || '{{ __("Failed to load payment details") }}');
                setTimeout(() => {
                    window.location.href = '{{ route("user.paradigm.assessments") }}';
                }, 2000);
            }
        },
        error: function(xhr) {
            toastr.error('{{ __("Error loading payment details") }}');
            setTimeout(() => {
                window.location.href = '{{ route("user.paradigm.assessments") }}';
            }, 2000);
        }
    });
}

function loadWalletBalance() {
    $.ajax({
        url: '{{ route("user.wallet.balance") }}',
        method: 'GET',
        success: function(response) {
            if (response.success) {
                walletBalance = parseFloat(response.balance);
                const currency = response.currency || '$';
                
                // Update both balance displays
                $('#wallet_balance').html(`<span class="text-success">${currency}${walletBalance.toFixed(2)}</span>`);
                $('#wallet_balance_display').html(`<span class="text-success">${currency}${walletBalance.toFixed(2)}</span>`);
                
                // Check if sufficient balance
                const amount = parseFloat(paymentData.amount || 0);
                if (walletBalance < amount) {
                    // Insufficient balance
                    $('#insufficient_wallet_warning').slideDown();
                    $('#proceedPaymentBtn').prop('disabled', true);
                } else {
                    // Sufficient balance
                    $('#insufficient_wallet_warning').slideUp();
                    $('#proceedPaymentBtn').prop('disabled', false);
                }
            }
        },
        error: function(xhr) {
            console.error('Failed to load wallet balance:', xhr);
            $('#wallet_balance').html('<span class="text-danger">Error</span>');
            $('#wallet_balance_display').html('<span class="text-danger">Error</span>');
            $('#proceedPaymentBtn').prop('disabled', true);
        }
    });
}

function processWalletPayment(accessToken) {
    $('#proceedPaymentBtn').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>{{ __("Processing...") }}');
    
    $.ajax({
        url: '{{ route("paradigm.payment.process-wallet") }}', // We'll create this route
        method: 'POST',
        data: {
            access_token: accessToken,
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                toastr.success('{{ __("Payment successful! Redirecting to assessment...") }}');
                setTimeout(() => {
                    window.location.href = `/paradigm/assessment/${paymentData.template.id}?token=${accessToken}`;
                }, 1500);
            } else {
                toastr.error(response.message || '{{ __("Payment failed") }}');
                $('#proceedPaymentBtn').prop('disabled', false).html('<i class="ti ti-lock me-2"></i>{{ __("Proceed to Payment") }}');
            }
        },
        error: function(xhr) {
            const response = xhr.responseJSON;
            toastr.error(response?.message || '{{ __("Payment processing failed") }}');
            $('#proceedPaymentBtn').prop('disabled', false).html('<i class="ti ti-lock me-2"></i>{{ __("Proceed to Payment") }}');
        }
    });
}
</script>
@endpush
