@extends('front')

@section('content')

<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{__('My Paid Assessments')}}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{__('Dashboard')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.paradigm.assessments') }}">{{__('Paradigm Profiles™')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('My Paid Assessments')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="ti ti-check-circle me-2"></i>{{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if($payments->isEmpty())
                        <!-- No Assessments Yet -->
                        <div class="card">
                            <div class="card-body text-center py-5">
                                <i class="ti ti-brain text-muted" style="font-size: 64px;"></i>
                                <h5 class="mt-3 mb-2">{{__('No Paid Assessments Yet')}}</h5>
                                <p class="text-muted mb-4">{{__('Purchase your first Paradigm Profile™ assessment to get started')}}</p>
                                <a href="{{ route('user.paradigm.buy') }}" class="btn btn-primary">
                                    <i class="ti ti-shopping-cart me-2"></i>{{__('Buy Assessment')}}
                                </a>
                            </div>
                        </div>
                    @else
                        <!-- Assessments List -->
                        @foreach($payments as $payment)
                            <div class="card mb-4">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <h5 class="mb-2">
                                                <i class="ti ti-brain text-primary me-2"></i>
                                                {{ $payment->template->name ?? 'Paradigm Profile™ Assessment' }}
                                            </h5>
                                            <p class="text-muted mb-2">
                                                <i class="ti ti-calendar me-1"></i>
                                                {{__('Purchased on')}} {{ $payment->created_at->format('M d, Y') }}
                                            </p>
                                            @if($payment->accessTokens->first())
                                                @php
                                                    $accessToken = $payment->accessTokens->first();
                                                    $isExpired = $accessToken->expires_at < now();
                                                    $isUsed = $accessToken->is_used;
                                                @endphp
                                                @if($isExpired)
                                                    <span class="badge bg-danger">
                                                        <i class="ti ti-clock-x me-1"></i>{{__('Expired')}}
                                                    </span>
                                                @elseif($isUsed)
                                                    <span class="badge bg-success">
                                                        <i class="ti ti-check me-1"></i>{{__('Completed')}}
                                                    </span>
                                                @else
                                                    <span class="badge bg-info">
                                                        <i class="ti ti-clock me-1"></i>{{__('Valid until')}} {{ $accessToken->expires_at->format('M d, Y') }}
                                                    </span>
                                                @endif
                                            @endif
                                        </div>
                                        <div class="col-md-4 text-md-end text-start mt-3 mt-md-0">
                                            @if($payment->accessTokens->first() && !$payment->accessTokens->first()->is_used && $payment->accessTokens->first()->expires_at >= now())
                                                <a href="{{ route('user.paradigm.assessments') }}?token={{ $payment->accessTokens->first()->token }}" 
                                                   class="btn btn-primary">
                                                    <i class="ti ti-play me-2"></i>{{__('Start Assessment')}}
                                                </a>
                                            @elseif($payment->accessTokens->first() && $payment->accessTokens->first()->is_used)
                                                <a href="{{ route('user.paradigm.assessments') }}?token={{ $payment->accessTokens->first()->token }}" 
                                                   class="btn btn-outline-primary">
                                                    <i class="ti ti-file-text me-2"></i>{{__('View Results')}}
                                                </a>
                                            @else
                                                <button class="btn btn-secondary" disabled>
                                                    <i class="ti ti-lock me-2"></i>{{__('Expired')}}
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        <!-- Purchase Another -->
                        <div class="text-center mt-4">
                            <a href="{{ route('user.paradigm.buy') }}" class="btn btn-outline-primary">
                                <i class="ti ti-plus me-2"></i>{{__('Purchase Another Assessment')}}
                            </a>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
</div>

@endsection

