@extends('front')

@section('content')

<!-- Breadcrumb -->
<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{ __('Link Requests') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}"><i class="ti ti-home-2"></i></a></li>
                        <li class="breadcrumb-item">{{ __('Customer') }}</li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Link Requests') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="breadcrumb-bg">
            <img src="/assets/img/bg/breadcrumb-bg-01.png" class="breadcrumb-bg-1" alt="Img">
            <img src="/assets/img/bg/breadcrumb-bg-02.png" class="breadcrumb-bg-2" alt="Img">
        </div>
    </div>
</div>
<!-- /Breadcrumb -->

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    <div class="card">
                        <div class="card-body">
                        <!-- Filters -->
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <select class="form-control" id="statusFilter">
                                    <option value="">{{ __('All Status') }}</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ __('Pending') }}</option>
                                    <option value="accepted" {{ request('status') == 'accepted' ? 'selected' : '' }}>{{ __('Accepted') }}</option>
                                    <option value="declined" {{ request('status') == 'declined' ? 'selected' : '' }}>{{ __('Declined') }}</option>
                                </select>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-hover table-center mb-0">
                                <thead>
                                    <tr>
                                        <th>{{ __('Practitioner Name') }}</th>
                                        <th>{{ __('Paradigm Type') }}</th>
                                        <th>{{ __('Request Date') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($requests as $request)
                                        @php
                                            $practitioner = $request->practitioner ?? null;
                                            $practitionerName = 'N/A';
                                            if ($practitioner && isset($practitioner->userDetail) && $practitioner->userDetail) {
                                                $firstName = $practitioner->userDetail->first_name ?? '';
                                                $lastName = $practitioner->userDetail->last_name ?? '';
                                                $practitionerName = trim($firstName . ' ' . $lastName) ?: 'N/A';
                                            }
                                            $result = $request->result ?? null;
                                            $requestedAt = $request->requested_at ?? null;
                                        @endphp
                                        <tr>
                                            <td>{{ $practitionerName }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ ($result && isset($result->paradigm_type) && $result->paradigm_type) ? $result->paradigm_type : 'N/A' }}</span>
                                            </td>
                                            <td>{{ ($requestedAt && method_exists($requestedAt, 'format')) ? $requestedAt->format('Y-m-d H:i') : 'N/A' }}</td>
                                            <td>
                                                @if($request->status == 'pending')
                                                    <span class="badge bg-warning">{{ __('Pending') }}</span>
                                                @elseif($request->status == 'accepted')
                                                    <span class="badge bg-success">{{ __('Accepted') }}</span>
                                                @else
                                                    <span class="badge bg-danger">{{ __('Declined') }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($request->status == 'pending')
                                                    <form method="POST" action="{{ route('user.paradigm.link-requests.accept', $request->id) }}" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-success me-1">
                                                            <i class="ti ti-check me-1"></i>{{ __('Accept') }}
                                                        </button>
                                                    </form>
                                                    <form method="POST" action="{{ route('user.paradigm.link-requests.decline', $request->id) }}" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="ti ti-x me-1"></i>{{ __('Decline') }}
                                                        </button>
                                                    </form>
                                                @else
                                                    <span class="text-muted">{{ __('Responded') }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">{{ __('No link requests found') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $requests->links() }}
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /Page Wrapper -->
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#statusFilter').on('change', function() {
        const status = $(this).val();
        const url = new URL(window.location.href);
        if (status) url.searchParams.set('status', status);
        else url.searchParams.delete('status');
        window.location.href = url.toString();
    });
});
</script>
@endpush

