@extends('front')
@section('content')
<!-- Page Wrapper -->
<div class="page-wrapper content-widget">
	<div class="content">
		<div class="container">

			<!-- Booking -->
			<div class="row">
				<div class="col-xxl-10 col-xl-11 mx-auto">
					<div class="card border-0 mb-0">
						<div class="card-body p-3 fieldset-wizard">
							<div class="row">

								<!-- Booking Sidebar -->
								<div class="col-lg-3 theiaStickySidebar">
									<div class="card bg-dark booking-sidebar mb-4 mb-lg-0">
										<div class="card-body">
											<div class="skeleton label-skeleton label-loader"></div>
											<h6 class="text-white fs-14 mb-2 d-none real-label">
												{{ __('Service Details') }}
											</h6>
											<div class="service-info d-flex align-items-center">
												<span class="avatar avatar-md me-2 flex-shrink-0">
													<img src="{{ $firstImage }}" alt="img" class="d-none real-label">
												</span>
												<div>
													<div class="skeleton label-skeleton label-loader"></div>
													<p class="fs-12 text-white fw-medium mb-1 d-none real-label">{{ $service->source_name }}</p>
													<div class="skeleton label-skeleton label-loader"></div>
													<span class="fs-10 d-none real-label"><i class="ti ti-star-filled text-warning me-1"></i>{{ $averageRating }} ({{ $ratingCount }} {{ __("reviews")}})</span>
												</div>
											</div>
											<div class="booking-wizard">
												<div class="skeleton label-skeleton label-loader"></div>
												<h6 class="text-white fs-14 mb-3 d-none real-label">{{ __('Bookings') }}</h6>
												@php
												$step = 1; // Start step number
												@endphp
												<ul class="wizard-progress" id="bokingwizard">
													@if($additionalServicesCount !== "00")
													<li class="addservice active pb-3">
														<div class="skeleton label-skeleton label-loader"></div>
														<span class="d-none real-label">{{ $step++ }}. {{ __('Additional Services') }}</span>
													</li>
													@endif
													<li class="datetime {{ $additionalServicesCount === '00' ? 'active' : '' }} pb-3">
														<div class="skeleton label-skeleton label-loader"></div>
														<span class="d-none real-label">{{ $step++ }}. {{ __('Date & Time') }}</span>
													</li>
													<li class="prinfo pb-3">
														<div class="skeleton label-skeleton label-loader"></div>
														<span class="d-none real-label">{{ $step++ }}. {{ __('Personal Information') }}</span>
													</li>
													<li class="cart pb-3">
														<div class="skeleton label-skeleton label-loader"></div>
														<span class="d-none real-label">{{ $step++ }}. {{ __('Cart') }}</span>
													</li>
													<li class="pay pb-3">
														<div class="skeleton label-skeleton label-loader"></div>
														<span class="d-none real-label">{{ $step++ }}. {{ __('Payment') }}</span>
													</li>
													<li class="confime">
														<div class="skeleton label-skeleton label-loader"></div>
														<span class="d-none real-label">{{ $step }}. {{ __('Confirmation') }}</span>
													</li>
												</ul>
											</div>
											<div class="status-report d-none">
												<h6 class="text-white fs-14 mb-2 pb-2">{{ __('Bookings') }}</h6>
												<p class="fs-10"> <span id="bookcompletes">0</span>% complete</p>
											</div>
											<div class="text-center d-flex align-items-center gap-2 d-none">
												@if (!empty(Auth::user()->userDetails->profile_image) && file_exists(public_path('storage/profile/' . Auth::user()->userDetails->profile_image)))
												<img style="height: 30px; width: 30px" src="{{ optional(Auth::user()->userDetails)->profile_image ? asset('storage/profile/' . Auth::user()->userDetails->profile_image) : asset('assets/img/profile-default.png') }}" class="headerProfileImg" alt="user">
												@else
												<img style="height: 30px; width: 30px" src="{{ asset('assets/img/profile-default.png') }}" alt="Default Profile Image" class="img-fluid rounded-circle profileImagePreview">
												@endif
												<p class="fs-10 text-white">{{ Auth::user()->userDetails->first_name }} {{ Auth::user()->userDetails->last_name }}</p>
											</div>
										</div>
									</div>
								</div>
								<!-- /Booking Sidebar -->

								<div class="col-lg-9">

									<!-- Additional Service -->
									@if($additionalServicesCount !== "00")
									<fieldset class="booking-content" id="first-field">
										<div class="book-card">
											<div class="d-flex align-items-center justify-content-between flex-wrap booking-title">
												<div class="d-flex align-items-center mb-2">
													<div class="skeleton label-skeleton label-loader"></div>
													<h6 class="fs-16 me-2 mb-2 d-none real-label">{{ __('Select Additional Service') }}</h6>
													<div class="skeleton label-skeleton label-loader"></div>
													<span class="badge badge-info-transparent mb-2 d-none real-label">{{ __('Total') }} : {{ $additionalServicesCount }}</span>
												</div>
											</div>
											<form id="addService-form">
												<div class="row g-3">
													@if($additionalServices->isEmpty())
													<div class="col-12">
														<p class="text-center fs-12 mt-5 fw-bold text-dark">No additional services found at the moment. You can Continue further.</p>
													</div>
													@else
													@foreach ($additionalServices as $additionalService)
													<div class="skeleton label-skeleton label-loader w-50" style="height: 2rem;"></div>
													<div class="skeleton label-skeleton label-loader w-50 mt-3" style="height: 2rem;"></div>
													<div class="col-md-6 d-none real-label">
														<div class="select-item d-flex align-items-center justify-content-between flex-wrap border p-2 pb-0 mb-0" onclick="selectRadioAddService('{{ $additionalService->id }}')">
															<input type="checkbox" name="additionalService_id[]" id="additionalService_{{ $additionalService->id }}" value="{{ $additionalService->id }}" class="additionalService-radio" hidden>
															<div class="d-flex align-items-center pb-2">
																<span class="avatar avatar-lg">
																	<img src="{{ $additionalService->image }}" alt="img" class="br-5">
																</span>
																<div class="ms-2">
																	<h6 class="mb-1 fs-12 fw-medium">{{ $additionalService->name }}</h6>
																	<p class="fs-10"><span class="fs-12 text-gray-9 fw-medium">{{ $currecy_details->symbol }}{{ $additionalService->price }}</span> / {{ $additionalService->duration }}</p>
																</div>
															</div>
															<div class="d-flex align-items-center pb-2">
																<p class="mb-0 d-flex align-items-center fs-12 me-2"><i class="ti ti-star-filled text-warning me-1"></i>4.9</p>
																<a href="#!" class="btn btn-light btn-sm btn-addon d-inline-flex align-items-center"><i class="feather-plus-circle me-1"></i>{{ __('Add') }}</a>
															</div>
														</div>
													</div>
													@endforeach
													@endif
												</div>
											</form>
										</div>
										<div class="booking-footer d-flex align-items-center justify-content-end">
											<div class="skeleton label-skeleton label-loader"></div>
											<div class="d-flex align-items-center d-none real-label">
												<a href="#!" id="addService-btns" class="btn btn-sm btn-dark d-inline-flex align-items-center">{{ __('Next') }}<i class="ti ti-arrow-right ms-1"></i></a>
											</div>
										</div>
									</fieldset>
									@endif
									<!-- /Additional Service -->

									<!-- Date & Time -->
									<fieldset class="booking-content" id="{{ $additionalServicesCount === '00' ? 'first-field' : 'fourth-field' }}">
										<div class="book-card">
											<div class="d-flex align-items-center justify-content-between flex-wrap booking-title">
												<div class="d-flex align-items-center mb-2">
													<div class="skeleton label-skeleton label-loader"></div>
													<h6 class="fs-16 me-2 mb-2 d-none real-label">{{ __('Select Date & Time') }}</h6>
												</div>
											</div>
											<form id="slot-form">
												<div class="row g-3">
													<div class="col-md-5">
														<div class="skeleton label-skeleton label-loader"></div>
														<h6 class="fs-13 fw-medium mb-2 d-none real-label">{{ __('Select date') }}</h6>
														<div class="card border mb-0">
															<div class="skeleton label-skeleton label-loader w-100" style="height: 15rem;"></div>
															<div class="card-body p-3 d-none real-label">
																<input type="hidden" name="service_id" id="service_id" value="{{ $service->id }}">
																<input type="hidden" name="subcategory_id" id="subcategory_id" value="{{ $service->source_subcategory }}">
																<input type="hidden" name="category_id" id="category_id" value="{{ $service->source_category }}">
																<input type="hidden" name="booking_date" id="selected_date" value="">
																<div class="bookingDatepics"></div>
															</div>
														</div>
													</div>
													<input type="hidden" name="time_staus" id="time_staus">
													<div class="col-md-7 time-section">
														<div class="skeleton label-skeleton label-loader"></div>
														<h6 class="fs-13 fw-medium mb-2 d-none real-label">{{ __('Select time') }}</h6>
														<div class="slotLoader-skaliaton">
														</div>
														<div class="row g-2 text-center pt-4 fw-bold text-primary slots" id="slot-input">
															<div class="skeleton label-skeleton label-loader"></div>
															<p class="d-none real-label">{{ __('No slots available at this moment') }}</p>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="booking-footer d-flex align-items-center justify-content-end">
											<div class="skeleton label-skeleton label-loader"></div>
											<div class="d-flex align-items-center d-none real-label">
												@if($additionalServicesCount !== "00")
												<a href="#!" id="slot-prevs" class="btn btn-sm btn-light d-inline-flex align-items-center me-2"><i class="ti ti-arrow-left me-1"></i>{{ __('Prev') }}</a>
												@endif
												<a href="#!" id="{{ $additionalServicesCount === '00' ? 'slot-btns-new' : 'slot-btns' }}" class="btn btn-sm btn-dark d-inline-flex align-items-center">{{ __('Next') }}<i class="ti ti-arrow-right ms-1"></i></a>
											</div>
										</div>
									</fieldset>
									<!-- /Date & Time -->

									<!-- Personal Information -->
									<fieldset class="booking-content" id="fifth-field">
										<div class="book-card">
											<div class="d-flex align-items-center justify-content-between flex-wrap booking-title">
												<div class="d-flex align-items-center mb-2">
													<h6 class="fs-16 me-2 mb-2">{{ __('Add Personal Information') }}</h6>
												</div>
											</div>
											<form id="prinfo-form" data-is_required_text="{{ __('is_required') }}">
												<div class="row g-3">
													<div class="col-md-5">
														<div class="cart-info-wrap">
															<div class="mb-2 d-flex align-items-center justify-content-between">
																<div>
																	<h6 class="fw-medium fw-bold fs-16">{{ $service->source_name }}</h6>
																	<p class="fs-10">
																		<span class="fw-bold text-dark fs-12">{{ __('Price Type')}}:</span> {{ \Illuminate\Support\Str::ucfirst($service->price_type) }}
																	</p>
																	<p class="fs-10"> <span class="fw-bold text-dark fs-12">{{ __("Duration")}}:</span> {{ $service->duration }}/{{ $serviceDuration }}</p>
																</div>
																<h6 class="fs-12 fw-medium">{{ $currecy_details->symbol }}{{ $service->source_price }}</h6>
															</div>

															<div class="border-top pt-3 mt-3">
																<h6 class="mb-2">{{ __("Date")}}</h6>
																<p class="mb-2 text-gray-9 fw-medium d-flex align-items-center"><i class="feather-calendar me-2"></i><span class="slot_day"></span></p>
																<div class="slot-section">
																	<h6 class="time mb-2">{{ __("Time")}}</h6>
																	<p class="text-gray-9 fw-medium d-flex align-items-center"><i class="feather-clock me-2"></i> <span class="slot_time"></span></p>
																</div>
															</div>
														</div>
													</div>
													<div class="col-md-7">
														<div class="row g-2">
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("First Name")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="first_name" id="booking_first_name" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("Last Name")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="last_name" id="booking_last_name" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("Email")}}<span class="text-danger"> *</span></label>
																	<input type="email" name="email" id="booking_email" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("Phone Number")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="phone_number" id="phone_number" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("Street Address")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="address" id="address" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("City")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="city" id="city" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("State")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="state" id="state" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-6">
																<div>
																	<label class="form-label fs-12">{{ __("Postal Code")}}<span class="text-danger"> *</span></label>
																	<input type="text" name="postal" id="postal" class="form-control print-info">
																</div>
															</div>
															<div class="col-md-12">
																<div>
																	<label class="form-label fs-12">{{ __("Add booking notes") }}</label>
																	<textarea class="form-control" name="note" id="note" rows="4"></textarea>
																</div>
															</div>
														</div>
														<div class="border-top pt-3 mt-3">
															<h6 class="fs-13 fw-medium mb-1">{{ __("Cancellation policy")}}</h6>
															<p>{{ __("Cancel for free anytime in advance, otherwise you will be charged 100% of the service price for not showing up.")}}</p>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="booking-footer d-flex align-items-center justify-content-end">
											<div class="d-flex align-items-center">
												<a href="#!" id="{{ $additionalServicesCount === '00' ? 'prinfo-prevs-new' : 'prinfo-prevs' }}" class="btn btn-sm btn-light d-inline-flex align-items-center me-2"><i class="ti ti-arrow-left me-1"></i>{{ __('Prev') }}</a>
												<a href="#!" id="prinfo-btns" class="btn btn-sm btn-dark d-inline-flex align-items-center">{{ __('Next') }}<i class="ti ti-arrow-right ms-1"></i></a>
											</div>
										</div>
									</fieldset>
									<!-- /Personal Information -->

									<!-- Cart -->
									<fieldset class="booking-content" id="sixth-field">
										<div class="book-card">
											<div class="d-flex align-items-center justify-content-between flex-wrap booking-title">
												<div class="d-flex align-items-center mb-2">
													<h6 class="fs-16 me-2 mb-2">{{ __("Cart")}}</h6>
												</div>
												<div class="d-flex align-items-center flex-wrap mb-2">
													<div class="dropdown mb-2">
														<a href="#!" class="bg-light-500 d-inline-flex align-items-center" data-bs-toggle="dropdown">
															<i class="ti ti-shopping-cart me-1"></i>{{ __("Cart")}}<span class="bg-primary num-count ms-1">1</span>
														</a>
														<div class="dropdown-menu dropdown-sm p-3">
															<h6 class="fs-13 mb-3">{{ __("Added In Cart")}} (01)</h6>
															<div class="d-flex align-items-center p-2 bg-light rounded mb-3">
																<span class="avatar avatar-lg">
																	<img src="{{ $firstImage }}" alt="img">
																</span>
																<div class="ms-2">
																	<h6 class="mb-1">{{ $service->source_name }}</h6>
																	<p class="fs-12"><i class="ti ti-star-filled text-warning me-1"></i><span class="text-gray-9">{{ $averageRating }}</span> ({{ $ratingCount }} {{ __("reviews")}})</p>
																</div>
															</div>
															<div class="d-flex align-items-center justify-content-between border-top pt-3 mt-3">
																<div>
																	<h6 class="fw-medium">{{ __("Total")}}</h6>
																</div>
																<h6 class="fw-medium">{{ $currecy_details->symbol }}{{ $service->source_price }}</h6>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="row g-3">
												<div class="col-md-6 d-flex">
													<div class="card flex-fill">
														<div class="card-body p-3 d-flex justify-content-between flex-column">
															<div>
																<div class="d-flex align-items-center p-3 bg-light-400 rounded mb-2">
																	<span class="avatar avatar-lg">
																		<img src="{{ $firstImage }}" alt="img">
																	</span>
																	<div class="ms-2">
																		<h6 class="fs-14 fw-medium mb-1">{{ $service->source_name }}</h6>
																		<p><span class="fw-bold text-dark fs-12">{{ __('Price Type')}}:</span> {{ \Illuminate\Support\Str::ucfirst($service->price_type) }}</p>
																		<p><span class="fw-bold text-dark fs-12">{{ __("Duration")}}:</span> {{ $service->duration }}/{{ $serviceDuration }}</p>
																	</div>
																</div>
																<div class="mb-2">
																	<h6 class="add fw-medium mb-1">{{ __('Additional Service') }}</h6>
																	<p class="additional-service-output"></p>
																</div>
																<div class="mb-2">
																	<h6 class="fw-medium">{{ __("Date")}}</h6>
																	<p class="slot_day"></p>
																	<div class="slot-section">
																		<h6 class="time fw-medium mb-1">{{ __("Time")}}</h6>
																		<p class="slot_time"></p>
																	</div>
																</div>
																<div class="mb-0">
																	<h6 class="fw-medium mb-1">{{ __("Amount")}}</h6>
																	<span class="badge badge-dark">{{ $currecy_details->symbol }}{{ $service->source_price }}</span>
																</div>
															</div>
															<div class="text-center border-top pt-3 mt-3">
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="booking-footer d-flex align-items-center justify-content-end">
											<div class="d-flex align-items-center">
												<a href="#!" id="{{ $additionalServicesCount === '00' ? 'cart-prevs-new' : 'cart-prevs' }}" class="btn btn-sm btn-light d-inline-flex align-items-center prev_btn me-2"><i class="ti ti-arrow-left me-1"></i>{{ __('Prev') }}</a>
												<a href="#!" id="{{ $additionalServicesCount === '00' ? 'cart-btns-new' : 'cart-btns' }}" class="btn btn-sm btn-dark d-inline-flex align-items-center next_btn">{{ __('Next') }}<i class="ti ti-arrow-right ms-1"></i></a>
											</div>
										</div>
									</fieldset>
									<!-- /Cart -->

									<!-- Payment Method -->
									<fieldset class="booking-content" id="saventh-field">
										<div class="book-card">
											<div class="d-flex align-items-center justify-content-between flex-wrap booking-title">
												<div class="d-flex align-items-center mb-2">
													<h6 class="fs-16 me-2 mb-2">{{ __("Payment Method")}}</h6>
												</div>
												<div class="d-flex align-items-center mb-2">
													<a href="#!" id="{{ $additionalServicesCount === '00' ? 'back-prevs-new' : 'back-prevs' }}" class="btn btn-sm btn-secondary d-inline-flex align-items-center prev_btn mb-2"><i class="ti ti-caret-left-filled me-1"></i>{{ __("back_to_cart")}}</a>
												</div>
											</div>
											<form id="payment-form">
												<div class="row g-3">
													<div class="col-md-6 payment-radios">
														<h6 class="fs-13 mb-3">{{ __("Payment Types")}}</h6>
														@if(isset($paymentInfo['stripe_status']) && $paymentInfo['stripe_status'] == 1)
														<div class="payment-item d-flex align-items-center justify-content-between mb-2" id="stripePayment">
															<div class="form-check d-flex align-items-center ps-0">
																<input class="form-check-input ms-0 mt-0 payment-radio" name="payment_type" type="radio" id="stripe_status" value="stripe">
																<label class="form-check-label ms-2" for="stripe_status">{{ __("Stripe")}}</label>
															</div>
															<div>
																<img src="{{ asset('front/img/icons/payment1.svg') }}" alt="payment">
															</div>
														</div>
														@endif
														@if(isset($paymentInfo['paypal_status']) && $paymentInfo['paypal_status'] == 1)
														<div class="payment-item d-flex align-items-center justify-content-between mb-2" id="paypalPayment">
															<div class="form-check d-flex align-items-center ps-0">
																<input class="form-check-input ms-0 mt-0 payment-radio" name="payment_type" type="radio" id="paypal_status" value="paypal">
																<label class="form-check-label ms-2" for="paypal_status">{{ __("Paypal")}}</label>
															</div>
															<div>
																<img src="{{ asset('front/img/icons/payment2.svg') }}" alt="payment">
															</div>
														</div>
														@endif
														@if(isset($paymentInfo['mollie_status']) && $paymentInfo['mollie_status'] == 1)
														<div class="payment-item d-flex align-items-center justify-content-between mb-2" id="molliePayment">
															<div class="form-check d-flex align-items-center ps-0">
																<input class="form-check-input ms-0 mt-0 payment-radio" name="payment_type" type="radio" id="mollie_status" value="mollie">
																<label class="form-check-label ms-2" for="paypal_status">{{ __("Mollie")}}</label>
															</div>
															<div>
																<img src="{{ asset('front/img/icons/mollie.png') }}" style="height: 40px; width: 50px" alt="payment">
															</div>
														</div>
														@endif
														@if(isset($paymentInfo['cod_status']) && $paymentInfo['cod_status'] == 1)
														<div class="payment-item d-flex align-items-center justify-content-between mb-2" id="codPayment">
															<div class="form-check d-flex align-items-center ps-0">
																<input class="form-check-input ms-0 mt-0 payment-radio" name="payment_type" type="radio" id="cod_status" value="cod">
																<label class="form-check-label ms-2" for="cod_status">{{ __("Cash on Delivery (COD)")}}</label>
															</div>
															<div>
																<img src="{{ asset('front/img/icons/cod.png') }}" style="height: 40px; width: 30px" alt="payment">
															</div>
														</div>
														@endif
														@if(isset($paymentInfo['wallet_status']) && $paymentInfo['wallet_status'] == 1)
														<div class="payment-item d-flex align-items-center justify-content-between mb-2" id="walletPayment">
															<div class="form-check d-flex align-items-center ps-0">
																<input class="form-check-input ms-0 mt-0 payment-radio" name="payment_type" type="radio" id="wallet_status" value="wallet">
																<label class="form-check-label ms-2" for="wallet_status">{{ __("Wallet Amount")}}</label>
															</div>
															<div>
																<img src="{{ asset('front/img/icons/digital-wallet.jpg') }}" style="height: 40px; width: 50px" alt="payment">
															</div>
														</div>
														<div id="wallet-meg" data-wallet_balance="{{ __('wallet_balance')}}" data-your_wallet_balance_is_sufficient="{{ __('your_wallet_balance_is_sufficient')}}" data-insufficient_wallet_balance="{{ __('insufficient_wallet_balance')}}" data-available_balance="{{ __('available_balance')}}" class="fw-bold">
														</div>
														@endif
													</div>

													<div class="col-md-6">
														<div class="card total-card">
															<div class="card-body p-3 d-flex justify-content-between flex-column">
																<div>
																	<div class="mb-2 d-flex align-items-center justify-content-between">
																		<div>
																			<h6 class="fw-bold fs-16">{{ $service->source_name }}</h6>
																			<p class="fs-12"><span class="fw-bold text-dark fs-12">{{ __('Price Type')}}:</span> {{ \Illuminate\Support\Str::ucfirst($service->price_type) }}</p>
																			<p class="fs-12"><span class="fw-bold text-dark fs-12">{{ __("Duration")}}:</span> {{ $service->duration }}/{{ $serviceDuration }}</p>
																		</div>
																		<h6 class="fs-16 fw-medium">{{ $currecy_details->symbol }}{{ $service->source_price }}</h6>
																	</div>
																</div>
																@if($couponModuleStatus === 1 && View::exists('coupon::booking.coupon'))
																	@include('coupon::booking.coupon')
																@endif
																<div>
																	<div id="payout" data-sub_total="{{ __('sub_total')}}" data-additional_services_total="{{ __('additional_services_total')}}" data-tax="{{ __('tax')}}" data-total="{{ __('total')}}">
																	</div>
																	<input type="hidden" class="sub_amount" name="sub_amount" id="sub_amount">
																	<input type="hidden" class="addService_amount" name="addService_amount" id="addService_amount">
																	<input type="hidden" class="tax_amount" name="tax_amount" id="tax_amount">
																	<input type="hidden" class="total_amount" name="total_amount" id="total_amount">
																	<button id="pay-btn" class="btn btn-light w-100 pay-btn">{{ __("Pay")}}</button>
																</div>
															</div>
														</div>
													</div>
												</div>
											</form>
										</div>
									</fieldset>
									<!-- /Payment Method -->

									<!-- Confirmation -->
									<fieldset class="booking-content" id="eight-field">
										<div class="book-card">
											<h6 class="fs-16 me-2 mb-3">{{ __("Payment Method")}}</h6>
											<div class="card">
												<div class="card-body">
													<h6 class="fs-14 fw-medium mb-3">{{ __("your_booking_is_successful_on")}} <span class="final-time"></span></h6>
													<div class="card shadow-none mb-0">
														<div class="card-body p-3">
															<div class="d-flex align-items-center justify-content-between flex-wrap p-2 bg-light-300 rounded mb-3">
																<div class="d-flex align-items-center pb-2">
																	<span class="avatar avatar-xl flex-shrink-0">
																		<img src="{{ $firstImage }}" alt="img">
																	</span>
																	<div class="ms-2">
																		<h6 class="mb-1">{{ $service->source_name }}</h6>
																	</div>
																</div>
																<span class="badge badge-success"><i class="ti ti-circle-check-filled me-1"></i>{{ __("confirmed")}}</span>
															</div>
															<div class="mb-2 d-flex align-items-center justify-content-between">
																<div>
																	<h6 class="fw-medium">{{ $service->source_name }}</h6>
																	<p class="fs-10"><span class="fw-bold text-dark fs-12">{{ __('Price Type')}}:</span> {{ \Illuminate\Support\Str::ucfirst($service->price_type) }}</p>
																	<p class="fs-10"><span class="fw-bold text-dark fs-12">{{ __("Duration")}}:</span> {{ $service->duration }}/{{ $serviceDuration }}</p>
																</div>
																<h6 class="fs-12 fw-medium">{{ $currecy_details->symbol }}{{ $service->source_price }}</h6>
															</div>
															<div class="border-top pt-2">
																<div class="mb-2 d-flex align-items-center justify-content-between">
																	<h6 class="fw-medium">{{ __("sub_total")}}</h6>
																	<p>{{ $currecy_details->symbol }}<span class="final-sub"></span> </p>
																</div>
																<div class="mb-2 d-flex align-items-center justify-content-between">
																	<h6 class="fw-medium">{{ __("tax")}}</h6>
																	<p>{{ $currecy_details->symbol }}<span class="final-tax"></span></p>
																</div>
															</div>
															<div class="border-top pt-2 d-flex align-items-center justify-content-between">
																<h6 class="fs-14">{{ __("total")}}</h6>
																<h6 class="fs-14">{{ $currecy_details->symbol }}<span class="final-total"></span></h6>
															</div>
														</div>
													</div>
													<div class="d-flex align-items-center justify-content-center flex-wrap">
														<a href="{{ route('user.dashboard') }}" class="btn btn-sm btn-primary d-inline-flex align-items-center mt-3"><i class="ti ti-circle-plus me-1"></i>{{ __("go_to_dashboard")}}</a>
													</div>
												</div>
											</div>
										</div>
									</fieldset>
									<!-- /Confirmation -->

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Booking -->

		</div>
	</div>
</div>
<!-- /Page Wrapper -->

<!-- Cursor -->
<div class="xb-cursor tx-js-cursor">
	<div class="xb-cursor-wrapper">
		<div class="xb-cursor--follower xb-js-follower"></div>
	</div>
</div>
<!-- /Cursor -->
@endsection