{{-- Registration Fields Only - Extracted from Join Us Form --}}
{{-- This partial contains only the form fields without modal wrapper --}}
{{-- Used by both Join Us modal and Help Form Step 4 --}}

<div class="mb-3">
    <label class="form-label">{{ __('first_name') }}</label>
    <input type="text" name="first_name" id="rh_first_name" class="form-control" maxlength="100"
        placeholder="{{ __('Enter First Name') }}">
    <div class="invalid-feedback" id="first_name_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('last_name') }}</label>
    <input type="text" name="last_name" id="rh_last_name" class="form-control" maxlength="100"
        placeholder="{{ __('Enter Last Name') }}">
    <div class="invalid-feedback" id="last_name_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('user_name') }}</label>
    <input type="text" name="name" id="rh_name" class="form-control" maxlength="100"
        placeholder="{{ __('Enter Name') }}">
    <div class="invalid-feedback" id="name_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('email') }}</label>
    <input type="email" name="email" id="rh_email" class="form-control" maxlength="100"
        placeholder="{{ __('Enter Email') }}">
    <div class="invalid-feedback" id="email_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('phone_number') }}</label>
    <input class="form-control" id="rh_phone" name="phone_number" maxlength="15" type="tel"
        placeholder="{{ __('Enter Phone Number') }}" autocomplete="tel">
    <small class="text-muted">Please enter full number without country code</small>
    <div class="invalid-feedback" id="phone_number_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('Gender') }}</label>
    <select class="form-control" id="rh_gender" name="gender">
        <option value="">{{ __('Select Gender') }}</option>
        <option value="male">{{ __('Male') }}</option>
        <option value="female">{{ __('Female') }}</option>
    </select>
    <div class="invalid-feedback" id="gender_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('date_of_birth') }}<span class="text-danger"> *</span></label>
    <div class="input-icon position-relative">
        <input type="date" class="form-control" id="rh_dob" name="dob"
            max="{{ date('Y-m-d', strtotime('-1 day')) }}">
    </div>
    <div class="invalid-feedback" id="dob_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('Address') }}</label>
    <input type="text" class="form-control" id="rh_address" name="address" maxlength="150"
        placeholder="{{ __('Enter Address') }}">
    <div class="invalid-feedback" id="address_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('Country') }}</label>
    <select class="form-control select2" id="rh_country" name="country">
        <option value="">{{ __('Select Country') }}</option>
    </select>
    <div class="invalid-feedback" id="country_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('State / Province') }}</label>
    <select class="form-control select2" id="rh_state" name="state">
        <option value="">{{ __('Select State') }}</option>
    </select>
    <div class="invalid-feedback" id="state_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('City') }}</label>
    <select class="form-control select2" id="rh_city" name="city">
        <option value="">{{ __('Select City') }}</option>
    </select>
    <div class="invalid-feedback" id="city_error"></div>
</div>
<div class="mb-3">
    <label class="form-label">{{ __('Postal Code') }}</label>
    <input type="text" class="form-control" id="rh_postal_code" name="postal_code" maxlength="10"
        placeholder="{{ __('Enter Postal Code') }}">
    <div class="invalid-feedback" id="postal_code_error"></div>
</div>
<div class="mb-3">
    <div class="d-flex align-items-center justify-content-between flex-wrap">
        <label class="form-label">{{ __('Password') }}</label>
    </div>
    <div class="input-group">
        <input type="password" name="password" id="rh_password" class="form-control" maxlength="100"
            placeholder="{{ __('Enter Password') }}" autocomplete="current-password">
        <button class="btn btn-outline-dark" type="button" id="rh_togglePassword" tabindex="-1">
            <i class="fas fa-eye" id="rh_toggleIcon"></i>
        </button>
    </div>
    <div class="invalid-feedback"></div>
</div>
<div class="mb-3">
    <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-2">
        <div class="form-check">
            <input class="form-check-input border-primary border-1" name="terms_policy" type="checkbox" value="1"
                id="rh_terms_policy">
            <label class="form-check-label" for="rh_terms_policy">
                {{ __('I agree to') }} <a href="{{ route('terms.conditions') }}"
                    class="text-decoration-underline" style="color: #044f54 !important;">{{ __('Terms and Conditions') }}</a>
                & <a href="{{ route('privacy.policy') }}"
                    class="text-decoration-underline" style="color: #044f54 !important;">{{ __('Privacy Policy') }}</a>
            </label>
            <div class="invalid-feedback" id="terms_policy_error"></div>
        </div>
    </div>
</div>
