@extends('provider.provider')

@section('content')
<style>
/* Brand Color Buttons */
.btn-primary {
    background-color: #044f54 !important;
    border-color: #044f54 !important;
    color: white !important;
}

.btn-primary:hover, .btn-primary:focus, .btn-primary:active {
    background-color: #033d41 !important;
    border-color: #033d41 !important;
    color: white !important;
}

.btn-outline-primary {
    border-color: #044f54 !important;
    color: #044f54 !important;
}

.btn-outline-primary:hover, .btn-outline-primary:focus, .btn-outline-primary:active {
    background-color: #044f54 !important;
    border-color: #044f54 !important;
    color: white !important;
}

.btn-success:hover, .btn-success:focus, .btn-success:active {
    opacity: 0.85;
}

.btn-danger:hover, .btn-danger:focus, .btn-danger:active {
    opacity: 0.85;
}

.btn-warning:hover, .btn-warning:focus, .btn-warning:active {
    opacity: 0.85;
}
</style>
<div class="page-wrapper">
    <div class="content container-fluid pb-0">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Assign Assessments to Clients') }}</h4>
                        <p class="card-subtitle">{{ __('Assign Paradigm Profile assessments to clients - they will be notified to log in and start') }}</p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ __('Assign New Assessment') }}</h5>
                                        
                                        <!-- Wallet Balance Display -->
                                        <div class="alert alert-info d-flex align-items-center mb-3">
                                            <i class="ti ti-wallet fs-20 me-2"></i>
                                            <div>
                                                <small class="d-block">{{ __('Your Wallet Balance') }}</small>
                                                <strong id="provider_wallet_balance">
                                                    <span class="spinner-border spinner-border-sm" role="status"></span>
                                                </strong>
                                            </div>
                                            <a href="{{ route('provider.wallet') }}" class="btn btn-sm btn-outline-primary ms-auto">
                                                {{ __('Manage Credits') }}
                                            </a>
                                        </div>
                                        
                                        <form id="generateLinkForm">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Assessment Template') }} <span class="text-danger">*</span></label>
                                                <select class="form-select" id="template_id" name="template_id" required>
                                                    <option value="">{{ __('Choose a template...') }}</option>
                                                </select>
                                                <div id="template_price_info" class="mt-2 text-muted small" style="display: none;">
                                                    <i class="ti ti-info-circle me-1"></i>
                                                    <span id="template_price_text"></span>
                                                </div>
                                            </div>
                                            
                                            <div class="row mt-3">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">{{ __('Client Name') }} <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="client_name" name="client_name" 
                                                               placeholder="{{ __('Enter client first name') }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">{{ __('Client Surname') }} <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="client_surname" name="client_surname" 
                                                               placeholder="{{ __('Enter client surname') }}" required>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="row mt-3">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="client_gender">{{ __('Gender') }} <span class="text-danger">*</span></label>
                                                        <select class="form-control" id="client_gender" name="client_gender" required>
                                                            <option value="">{{ __('Select gender') }}</option>
                                                            <option value="male">{{ __('Male') }}</option>
                                                            <option value="female">{{ __('Female') }}</option>
                                                            <option value="other">{{ __('Other') }}</option>
                                                            <option value="prefer_not_to_say">{{ __('Prefer not to say') }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="client_dob">{{ __('Date of Birth') }} <span class="text-danger">*</span></label>
                                                        <input type="date" class="form-control" id="client_dob" name="client_dob" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="client_whatsapp">{{ __('Client WhatsApp Number') }} <span class="text-danger">*</span></label>
                                                        <input type="tel" class="form-control" id="client_whatsapp" name="client_whatsapp" required>
                                                        <input type="hidden" id="client_whatsapp_full" name="client_whatsapp_full">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="client_email">{{ __('Client Email') }} <span class="text-danger">*</span></label>
                                                        <input type="email" class="form-control" id="client_email" name="client_email" required>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group mt-3">
                                                <label for="payment_type">{{ __('Payment Type') }}</label>
                                                <div id="payment_type_options">
                                                    <!-- Options will be loaded here by JS -->
                                                </div>
                                            </div>

                                            <div id="wallet_info" class="alert alert-info mt-3" style="display: none;">
                                                {{ __('The amount will be deducted from your wallet.') }}
                                            </div>
                                            
                                            <!-- Payment Options (only shown if price > 0) -->
                                            <div class="mb-3" id="payment_options_container" style="display: none;">
                                                <label class="form-label">{{ __('Payment Method') }} <span class="text-danger">*</span></label>
                                                
                                                <!-- Client Pays Option - HIDDEN -->
                                                <div class="form-check mb-2 p-3 border rounded" style="display: none;">
                                                    <input class="form-check-input" type="radio" name="payment_type" 
                                                           id="payment_client" value="client">
                                                    <label class="form-check-label w-100" for="payment_client">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong>{{ __('Client Pays') }}</strong>
                                                                <small class="d-block text-muted">{{ __('Client pays via their wallet') }}</small>
                                                            </div>
                                                            <i class="ti ti-credit-card fs-20 text-primary"></i>
                                                        </div>
                                                    </label>
                                                </div>
                                                
                                                <!-- Provider Pays Option - DEFAULT AND ONLY VISIBLE -->
                                                <div class="form-check mb-2 p-3 border rounded" style="background-color: #f8f9fa;">
                                                    <input class="form-check-input" type="radio" name="payment_type" 
                                                           id="payment_provider" value="provider" checked>
                                                    <label class="form-check-label w-100" for="payment_provider">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong>{{ __('I Pay (Deduct from My Credits)') }}</strong>
                                                                <small class="d-block text-muted">{{ __('Assessment cost will be deducted from your credits') }}</small>
                                                            </div>
                                                            <i class="ti ti-wallet fs-20 text-success"></i>
                                                        </div>
                                                    </label>
                                                </div>
                                                
                                                <!-- Insufficient Balance Warning -->
                                                <div id="insufficient_balance_warning" class="alert alert-warning mt-2" style="display: none;">
                                                    <i class="ti ti-alert-triangle me-2"></i>
                                                    <strong>{{ __('Insufficient Balance') }}</strong>
                                                    <p class="mb-0 small">{{ __('Your credit balance is insufficient. Please buy more credits to continue.') }}</p>
                                                    <a href="{{ route('provider.wallet.topup') }}" class="btn btn-sm btn-warning mt-2">
                                                        <i class="ti ti-plus me-1"></i>{{ __('Buy Credits Now') }}
                                                    </a>
                                                </div>
                                            </div>
                                            
                                            <!-- Free Assessment Notice -->
                                            <div class="alert alert-success" id="free_assessment_notice" style="display: none;">
                                                <i class="ti ti-circle-check me-2"></i>
                                                <strong>{{ __('Free Assessment') }}</strong>
                                                <p class="mb-0 small">{{ __('This assessment is free (admin set price to 0 Credits). No payment required.') }}</p>
                                            </div>
                                            
                                            <button type="submit" class="btn w-100" id="generateLinkBtn" style="background-color: #044f54; border-color: #044f54; color: white;" onmouseover="this.style.backgroundColor='#033d41'; this.style.borderColor='#033d41';" onmouseout="this.style.backgroundColor='#044f54'; this.style.borderColor='#044f54';">
                                                <i class="ti ti-user-check me-1"></i> {{ __('Buy Paradigm Profile') }}
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Assigned Assessments moved below -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <h5 class="card-title mb-0">{{ __('Assigned Assessments') }}</h5>
                                        </div>
                                <div class="table-responsive">
                                    <table class="table table-striped" id="linksTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('Template') }}</th>
                                                <th>{{ __('Client Email') }}</th>
                                                <th>{{ __('Payment Status') }}</th>
                                                <th>{{ __('Assessment Status') }}</th>
                                                <th>{{ __('Assessment Link') }}</th>
                                                <th>{{ __('Assigned Date') }}</th>
                                                <th>{{ __('Actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Links will be loaded here -->
                                        </tbody>
                                    </table>
                                </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Client Link Section -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="card-title mb-0">{{ __('Client Link') }}</h4>
                            <p class="card-subtitle mb-0">{{ __('View all clients who have completed their assessments and download their reports') }}</p>
                        </div>
                        <button type="button" class="btn btn-danger btn-sm" id="deleteAllClientLinksBtn">
                            <i class="ti ti-trash me-1"></i>{{ __('Delete All') }}
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="clientLinkTable">
                                <thead>
                                    <tr>
                                        <th>{{ __('Client Name') }}</th>
                                        <th>{{ __('Email') }}</th>
                                        <th>{{ __('Assessment') }}</th>
                                        <th>{{ __('Paradigm Type') }}</th>
                                        <th>{{ __('Completion Date') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="6" class="text-center">
                                            <span class="spinner-border spinner-border-sm" role="status"></span>
                                            <span class="ms-2">{{ __('Loading client assessments...') }}</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Generated Link Modal -->
<div class="modal fade" id="generatedLinkModal" tabindex="-1" aria-labelledby="generatedLinkModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="generatedLinkModalLabel">{{ __('Assessment Assigned Successfully') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-success">
                    <i class="ti ti-check-circle me-2"></i>
                    {{ __('Assessment has been assigned successfully!') }}
                </div>
                
                <div class="mb-4">
                    <h6 class="text-center mb-3">{{ __('Client Notified') }}</h6>
                    
                    <!-- Notification Cards -->
                    <div class="row g-3 mb-3">
                        <!-- Email Notification -->
                        <div class="col-md-6">
                            <div class="border rounded p-3 h-100 bg-light">
                                <div class="d-flex align-items-center mb-2">
                                    <div class="avatar avatar-sm bg-success-transparent rounded-circle me-2">
                                        <i class="ti ti-mail fs-20 text-success"></i>
                                    </div>
                                    <strong class="text-success">{{ __('Email Sent') }}</strong>
                                </div>
                                <small class="text-muted d-block mb-1">{{ __('Email Address') }}</small>
                                <p class="mb-0 fw-semibold text-break" id="assigned_client_email_display"></p>
                            </div>
                        </div>
                        
                        <!-- WhatsApp Notification -->
                        <div class="col-md-6">
                            <div class="border rounded p-3 h-100 bg-light">
                                <div class="d-flex align-items-center mb-2">
                                    <div class="avatar avatar-sm bg-success-transparent rounded-circle me-2">
                                        <i class="ti ti-brand-whatsapp fs-20 text-success"></i>
                                    </div>
                                    <strong class="text-success">{{ __('WhatsApp Sent') }}</strong>
                                </div>
                                <small class="text-muted d-block mb-1">{{ __('Phone Number') }}</small>
                                <p class="mb-0 fw-semibold" id="assigned_client_whatsapp_display"></p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- What Happens Next -->
                    <div class="alert alert-info text-start mb-0">
                        <i class="ti ti-info-circle me-2"></i>
                        <strong>{{ __('What happens next?') }}</strong>
                        <ul class="mb-0 mt-2 small">
                            <li>{{ __('Client receives email and WhatsApp notification with access instructions') }}</li>
                            <li>{{ __('Client logs in to their account') }}</li>
                            <li>{{ __('Assessment appears in their dashboard') }}</li>
                            <li>{{ __('Client can start the assessment anytime') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary w-100" data-bs-dismiss="modal">
                    <i class="ti ti-check me-1"></i> {{ __('Done') }}
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<!-- intl-tel-input CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/css/intlTelInput.css">
<!-- intl-tel-input JS -->
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/intlTelInput.min.js"></script>

<script>
let providerWalletBalance = null; // null = not loaded yet, 0 = loaded with zero balance
let selectedTemplatePrice = 0;
let templatesData = [];
const isAdmin = {{ (Auth::check() && Auth::user()->user_type == 1) ? 'true' : 'false' }};
let phoneInput = null;

$(document).ready(function() {
    // Initialize international phone input for WhatsApp field
    const phoneInputField = document.querySelector("#client_whatsapp");
    if (phoneInputField) {
        phoneInput = window.intlTelInput(phoneInputField, {
            initialCountry: "za",
            preferredCountries: ["za", "us", "gb"],
            separateDialCode: true,
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/utils.js",
        });
        
        // Update hidden field with full international number on change
        phoneInputField.addEventListener('blur', function() {
            const fullNumber = phoneInput.getNumber();
            document.querySelector("#client_whatsapp_full").value = fullNumber;
        });
    }

    // Load wallet balance
    loadWalletBalance();
    
    // Load templates
    loadTemplates();
    
    // Load existing links
    loadGeneratedLinks();
    
    // Load client link (completed assessments)
    loadClientLink();
    
    // Template change handler
    $('#template_id').on('change', function() {
        const selectedTemplate = templatesData.find(t => t.id == $(this).val());
        if (selectedTemplate && selectedTemplate.pricing) {
            selectedTemplatePrice = parseFloat(selectedTemplate.pricing.price || 0);
            
            // Admin bypass: Always show as FREE for admins
            if (isAdmin) {
                $('#template_price_info').show();
                $('#template_price_text').html('<span class="badge bg-success">FREE (Admin)</span> <span class="text-muted small">(Regular price: ' + selectedTemplatePrice.toFixed(2) + ' Credits)</span>');
                $('#payment_options_container').hide();
                $('#free_assessment_notice').show();
            } else {
                $('#template_price_info').show();
                $('#template_price_text').text('Price: ' + selectedTemplatePrice.toFixed(2) + ' Credits');
                
                // If price is 0, it's automatically free (admin set it to 0)
                if (selectedTemplatePrice === 0) {
                    $('#payment_options_container').hide();
                    $('#free_assessment_notice').show();
                } else {
                    $('#payment_options_container').show();
                    $('#free_assessment_notice').hide();
                }
            }
        } else {
            selectedTemplatePrice = 0;
            $('#template_price_info').hide();
            $('#payment_options_container').hide();
            $('#free_assessment_notice').show();
        }
        validatePaymentOption();
    });
    
    // Payment type change handler
    $('input[name="payment_type"]').on('change', function() {
        validatePaymentOption();
    });
    
    // Form submission
    $('#generateLinkForm').on('submit', function(e) {
        e.preventDefault();
        
        // Update WhatsApp full number before submission
        if (phoneInput) {
            // Get the full international number (e.g., +27787308875)
            const fullNumber = phoneInput.getNumber();
            
            // Remove any spaces and ensure it starts with +
            const cleanNumber = fullNumber.replace(/\s+/g, '');
            
            console.log('Phone Input Debug:', {
                raw: $('#client_whatsapp').val(),
                full: fullNumber,
                clean: cleanNumber,
                isValid: phoneInput.isValidNumber()
            });
            
            document.querySelector("#client_whatsapp_full").value = cleanNumber;
            
            // Validate phone number
            if (!phoneInput.isValidNumber()) {
                toastr.error('{{ __("Please enter a valid phone number") }}', '{{ __("Validation Error") }}');
                $('#client_whatsapp').focus();
                return;
            }
            
            // Additional check: ensure number starts with +
            if (!cleanNumber.startsWith('+')) {
                toastr.error('{{ __("Phone number must be in international format") }}', '{{ __("Validation Error") }}');
                $('#client_whatsapp').focus();
                return;
            }
        }
        
        // Determine payment type based on admin or pricing
        let paymentType;
        if (isAdmin) {
            // Admins always send for free
            paymentType = 'free';
        } else if (selectedTemplatePrice === 0) {
            // If admin set price to 0 Credits, it's automatically free
            paymentType = 'free';
        } else {
            // If price > 0, use the selected payment option
            paymentType = $('input[name="payment_type"]:checked').val();
        }
        
        // Check if wallet balance is still loading
        if (paymentType === 'provider' && providerWalletBalance === null) {
            toastr.warning('{{ __("Loading wallet balance, please wait...") }}');
            // Retry after 1 second
            setTimeout(function() {
                $('#generateLinkBtn').click();
            }, 1000);
            return;
        }
        
        // Final validation for provider pays
        if (paymentType === 'provider' && selectedTemplatePrice > 0 && providerWalletBalance < selectedTemplatePrice) {
            toastr.error('{{ __("Insufficient wallet balance. Please top up your wallet.") }}');
            return;
        }
        
        const formData = {
            template_id: $('#template_id').val(),
            payment_type: paymentType,
            client_name: $('#client_name').val(),
            client_surname: $('#client_surname').val(),
            client_gender: $('#client_gender').val(),
            client_dob: $('#client_dob').val(),
            client_whatsapp: $('#client_whatsapp_full').val() || (phoneInput ? phoneInput.getNumber().replace(/\s+/g, '') : ''),
            client_email: $('#client_email').val(),
            send_email: $('#send_email').is(':checked'),
            send_whatsapp: $('#send_whatsapp').is(':checked'),
        };
        
        // Disable button
        $('#generateLinkBtn').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>{{ __("Assigning...") }}');
        
        $.ajax({
            url: '{{ route("paradigm.payment.generate-link") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    $('#assigned_client_email_display').text(formData.client_email);
                    $('#assigned_client_whatsapp_display').text(formData.client_whatsapp || '{{ __("Not provided") }}');
                    
                    let paymentStatusHTML = '';
                    if (response.data.is_free || paymentType === 'free') {
                        paymentStatusHTML = '<span class="badge bg-success fs-6">Free</span>';
                    } else if (paymentType === 'provider') {
                        paymentStatusHTML = '<span class="badge bg-info fs-6">Paid by Provider</span>';
                    } else {
                        paymentStatusHTML = '<span class="badge bg-warning text-dark fs-6">Client Pays</span>';
                    }
                    
                    $('#payment_status').html(paymentStatusHTML);
                    
                    $('#generatedLinkModal').modal('show');
                    loadGeneratedLinks(); // Refresh the table
                    loadWalletBalance(); // Refresh wallet balance if provider paid
                    
                    // Reset form
                    $('#generateLinkForm')[0].reset();
                    $('#payment_client').prop('checked', true);
                    $('#template_price_info').hide();
                    $('#payment_options_container').hide();
                    $('#free_assessment_notice').hide();
                    $('#insufficient_balance_warning').hide();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    toastr.error(response.message);
                } else {
                    toastr.error('{{ __("An error occurred while generating the link") }}');
                }
            },
            complete: function() {
                // Re-enable button
                $('#generateLinkBtn').prop('disabled', false).html('<i class="ti ti-user-check me-1"></i>{{ __("Buy Paradigm Profile") }}');
            }
        });
    });
    
    function loadWalletBalance() {
        $.ajax({
            url: '{{ route("provider.wallet.data") }}',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    providerWalletBalance = parseFloat(response.balance);
                    $('#provider_wallet_balance').html(
                        `<span class="text-primary">${providerWalletBalance.toFixed(2)} Credits</span>`
                    );
                } else {
                    $('#provider_wallet_balance').html('<span class="text-danger">Error loading balance</span>');
                }
            },
            error: function(xhr) {
                console.error('Failed to load wallet balance:', xhr);
                $('#provider_wallet_balance').html('<span class="text-danger">Error</span>');
            }
        });
    }
    
    function validatePaymentOption() {
        const paymentType = $('input[name="payment_type"]:checked').val();
        
        console.log('Validating payment:', {
            paymentType: paymentType,
            providerBalance: providerWalletBalance,
            templatePrice: selectedTemplatePrice
        });
        
        // Only validate if "provider pays" is selected and template has a price
        if (paymentType === 'provider' && selectedTemplatePrice > 0) {
            // Check if balance is still loading
            if (providerWalletBalance === null) {
                console.log('BALANCE LOADING: Please wait...');
                $('#insufficient_balance_warning').slideUp();
                $('#payment_provider').closest('.form-check').removeClass('border-warning');
                return; // Don't validate yet
            }
            
            if (providerWalletBalance < selectedTemplatePrice) {
                // Insufficient balance
                console.log('INSUFFICIENT BALANCE: Need ' + selectedTemplatePrice + ', have ' + providerWalletBalance);
                $('#insufficient_balance_warning').slideDown();
                $('#payment_provider').closest('.form-check').addClass('border-warning');
            } else {
                // Sufficient balance
                console.log('SUFFICIENT BALANCE: Have ' + providerWalletBalance + ', need ' + selectedTemplatePrice);
                $('#insufficient_balance_warning').slideUp();
                $('#payment_provider').closest('.form-check').removeClass('border-warning');
            }
        } else {
            $('#insufficient_balance_warning').slideUp();
            $('#payment_provider').closest('.form-check').removeClass('border-warning');
        }
    }
    
    function loadTemplates() {
        $.ajax({
            url: '{{ route("provider.paradigm.templates.json") }}',
            method: 'GET',
            success: function(response) {
                console.log('Templates loaded:', response);
                if (response && response.length > 0) {
                    templatesData = response; // Store for later use
                    response.forEach(function(template) {
                        $('#template_id').append(
                            `<option value="${template.id}">${template.name}</option>`
                        );
                    });
                    
                    // Auto-select if there's only one template
                    if (response.length === 1) {
                        $('#template_id').val(response[0].id);
                        // Trigger the change event to load pricing info
                        $('#template_id').trigger('change');
                    }
                } else {
                    $('#template_id').append('<option value="" disabled>{{ __("No templates available") }}</option>');
                }
            },
            error: function(xhr) {
                console.error('Failed to load templates:', xhr);
                console.error('Response:', xhr.responseText);
                toastr.error('{{ __("Failed to load templates") }}');
            }
        });
    }
    
    function loadGeneratedLinks() {
        $.ajax({
            url: '{{ route("provider.paradigm.generated-links") }}',
            method: 'GET',
            success: function(response) {
                console.log('Assigned assessments loaded:', response);
                if (response && response.length > 0) {
                    let html = '';
                    response.forEach(function(link) {
                        // Payment Status Badge
                        let paymentBadge = '';
                        // Check if self-purchased first
                        if (link.self_purchased == 1) {
                            paymentBadge = '<span class="badge bg-success">Paid by user</span>';
                        } else if (link.paid_by === 'free') {
                            paymentBadge = '<span class="badge bg-success">Free</span>';
                        } else if (link.paid_by === 'provider') {
                            paymentBadge = '<span class="badge bg-info">Paid by Provider</span>';
                        } else if (link.paid_by === 'client') {
                            paymentBadge = '<span class="badge bg-warning text-dark">Client Pays</span>';
                        } else {
                            paymentBadge = '<span class="badge bg-secondary">Unknown</span>';
                        }
                        
                        // Assessment Status Badge
                        let assessmentBadge = '';
                        switch(link.status) {
                            case 'free':
                            case 'paid':
                                assessmentBadge = '<span class="badge bg-success">Ready</span>';
                                break;
                            case 'pending':
                                assessmentBadge = '<span class="badge bg-warning">Pending Payment</span>';
                                break;
                            case 'completed':
                                assessmentBadge = '<span class="badge bg-success">Completed</span>';
                                break;
                            case 'expired':
                                assessmentBadge = '<span class="badge bg-danger">Expired</span>';
                                break;
                            default:
                                assessmentBadge = '<span class="badge bg-secondary">' + link.status + '</span>';
                        }
                        
                        // Format assigned date
                        let assignedDate = link.created_at ? new Date(link.created_at).toLocaleDateString() : 'N/A';
                        
                        // Assessment Link with copy button
                        let assessmentLinkCell = '';
                        if (link.assessment_link) {
                            assessmentLinkCell = `
                                <div class="d-flex align-items-center gap-2">
                                    <input type="text" class="form-control form-control-sm assessment-link-input" 
                                           value="${link.assessment_link}" 
                                           readonly 
                                           style="font-size: 0.75rem; max-width: 250px;"
                                           id="assessment-link-${link.id}">
                                    <button class="btn btn-sm btn-outline-primary copy-link-btn" 
                                            data-link="${link.assessment_link}"
                                            data-link-id="assessment-link-${link.id}"
                                            title="Copy Link">
                                        <i class="ti ti-copy"></i>
                                    </button>
                                </div>
                            `;
                        } else {
                            assessmentLinkCell = '<span class="text-muted small">{{ __("Link not available") }}</span>';
                        }
                        
                        // Action button: Revoke (if not completed & paid by provider) OR Admin revoke OR Non-refundable text
                        let actionButton = '';
                        if (isAdmin) {
                            // Admin can revoke any assignment (except completed ones)
                            if (link.is_completed) {
                                // Profile completed - show non-refundable text
                                actionButton = '<span class="badge bg-secondary">Non-refundable</span>';
                            } else {
                                // Admin can revoke any assignment
                                actionButton = `<button class="btn btn-sm btn-danger revoke-assigned-btn" 
                                            data-payment-id="${link.id}"
                                            data-client-email="${link.client_email}"
                                            data-amount="${link.amount}"
                                            data-paid-by="${link.paid_by}"
                                            data-is-admin="true"
                                            title="Revoke Assignment">
                                        <i class="ti ti-x"></i> Revoke
                                    </button>`;
                            }
                        } else if (link.paid_by === 'provider') {
                            // Provider can only revoke their own provider-paid assignments
                            if (link.is_completed) {
                                // Profile completed - show non-refundable text
                                actionButton = '<span class="badge bg-secondary">Non-refundable</span>';
                            } else {
                                // Profile NOT completed - show revoke button
                                actionButton = `<button class="btn btn-sm btn-warning revoke-assigned-btn" 
                                            data-payment-id="${link.id}"
                                            data-client-email="${link.client_email}"
                                            data-amount="${link.amount}"
                                            data-paid-by="${link.paid_by}"
                                            data-is-admin="false"
                                            title="Revoke & Refund">
                                        <i class="ti ti-arrow-back-up"></i> Revoke
                                    </button>`;
                            }
                        } else {
                            // Not paid by provider and not admin - no action needed
                            actionButton = '<span class="text-muted">-</span>';
                        }
                        
                        html += `
                            <tr>
                                <td>${link.template_name}</td>
                                <td>${link.client_email}</td>
                                <td>${paymentBadge}</td>
                                <td>${assessmentBadge}</td>
                                <td>${assessmentLinkCell}</td>
                                <td>${assignedDate}</td>
                                <td>${actionButton}</td>
                            </tr>
                        `;
                    });
                    $('#linksTable tbody').html(html);
                    
                    // Attach copy link button handlers
                    $('.copy-link-btn').on('click', function() {
                        const link = $(this).data('link');
                        const linkInput = document.getElementById($(this).data('link-id'));
                        
                        if (linkInput) {
                            linkInput.select();
                            linkInput.setSelectionRange(0, 99999); // For mobile devices
                            
                            try {
                                document.execCommand('copy');
                                toastr.success('{{ __("Assessment link copied to clipboard!") }}', '{{ __("Success") }}');
                                
                                // Visual feedback
                                const $btn = $(this);
                                $btn.html('<i class="ti ti-check"></i>');
                                setTimeout(() => {
                                    $btn.html('<i class="ti ti-copy"></i>');
                                }, 2000);
                            } catch (err) {
                                // Fallback: use Clipboard API
                                if (navigator.clipboard) {
                                    const $btn = $(this);
                                    navigator.clipboard.writeText(link).then(function() {
                                        toastr.success('{{ __("Assessment link copied to clipboard!") }}', '{{ __("Success") }}');
                                        $btn.html('<i class="ti ti-check"></i>');
                                        setTimeout(() => {
                                            $btn.html('<i class="ti ti-copy"></i>');
                                        }, 2000);
                                    }).catch(function() {
                                        toastr.error('{{ __("Failed to copy link") }}');
                                    });
                                } else {
                                    toastr.error('{{ __("Failed to copy link") }}');
                                }
                            }
                        }
                    });
                } else {
                    $('#linksTable tbody').html('<tr><td colspan="7" class="text-center text-muted">{{ __("No assessments assigned yet") }}</td></tr>');
                }
            },
            error: function(xhr) {
                console.error('Failed to load assigned assessments:', xhr);
                $('#linksTable tbody').html('<tr><td colspan="7" class="text-center text-danger">{{ __("Failed to load assessments") }}</td></tr>');
            }
        });
    }
    
    function loadClientLink() {
        $.ajax({
            url: '{{ route("provider.paradigm.client-link") }}',
            method: 'GET',
            success: function(response) {
                if (response && response.length > 0) {
                    let html = '';
                    response.forEach(function(client) {
                        // Format completion date
                        let completionDate = client.completed_at ? new Date(client.completed_at).toLocaleDateString() : 'N/A';
                        
                        html += `
                            <tr>
                                <td>${client.client_name || 'N/A'}</td>
                                <td>${client.client_email}</td>
                                <td>${client.template_name}</td>
                                <td><span class="badge bg-primary">${client.paradigm_type || 'N/A'}</span></td>
                                <td>${completionDate}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <button class="btn btn-sm btn-success download-client-report-btn" 
                                                data-result-id="${client.result_id}"
                                                title="Download Client Report">
                                            <i class="ti ti-download"></i> Download
                                        </button>
                                        <button class="btn btn-sm btn-danger delete-client-link-btn" 
                                                data-result-id="${client.result_id}"
                                                data-client-name="${client.client_name || 'N/A'}"
                                                title="Delete Client Result">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        `;
                    });
                    $('#clientLinkTable tbody').html(html);
                    
                    // Attach click handler for download buttons
                    $('.download-client-report-btn').on('click', function() {
                        const resultId = $(this).data('result-id');
                        window.location.href = '{{ route("paradigm.results", ":resultId") }}'.replace(':resultId', resultId);
                    });
                } else {
                    $('#clientLinkTable tbody').html('<tr><td colspan="6" class="text-center text-muted">{{ __("No completed assessments yet") }}</td></tr>');
                }
            },
            error: function(xhr) {
                console.error('Failed to load client assessments:', xhr);
                $('#clientLinkTable tbody').html('<tr><td colspan="6" class="text-center text-danger">{{ __("Failed to load client assessments") }}</td></tr>');
            }
        });
    }
    
    function copyToClipboard(text) {
        const textarea = document.createElement('textarea');
        textarea.value = text;
        document.body.appendChild(textarea);
        textarea.select();
        document.execCommand('copy');
        document.body.removeChild(textarea);
    }
    
    // Delete functionality handlers
    let deleteType = null;
    let deleteId = null;
    let deleteData = null;
    
    // Revoke assigned assessment button handler (REPLACED DELETE)
    $(document).on('click', '.revoke-assigned-btn', function() {
        const paymentId = $(this).data('payment-id');
        const clientEmail = $(this).data('client-email');
        const amount = $(this).data('amount');
        const paidBy = $(this).data('paid-by');
        const isAdminRevoke = $(this).data('is-admin') === true;
        
        deleteType = 'revoke';
        deleteId = paymentId;
        deleteData = { clientEmail, amount, paidBy, isAdminRevoke };
        
        let message = `{{ __('Revoke assessment for') }} "${clientEmail}"?`;
        if (isAdminRevoke) {
            message += ` {{ __('This will remove the assignment.') }}`;
            if (paidBy === 'provider' && amount > 0) {
                message += ` {{ __('Credits will be refunded to the provider.') }}`;
            }
        } else {
            message += ` {{ __('Credits will be refunded.') }}`;
        }
        
        showDeleteModal(message);
    });
    
    // Delete client link button handler
    $(document).on('click', '.delete-client-link-btn', function() {
        const resultId = $(this).data('result-id');
        const clientName = $(this).data('client-name');
        
        deleteType = 'client_link';
        deleteId = resultId;
        deleteData = { clientName };
        
        showDeleteModal(`{{ __('Delete client result for') }} "${clientName}"?`);
    });
    
    // Delete all assigned assessments button handler
    $('#deleteAllAssignedBtn').on('click', function() {
        deleteType = 'all_assigned';
        deleteId = null;
        deleteData = null;
        
        showDeleteModal('{{ __("Delete ALL assigned assessments?") }}');
    });
    
    // Delete all client links button handler
    $('#deleteAllClientLinksBtn').on('click', function() {
        deleteType = 'all_client_links';
        deleteId = null;
        deleteData = null;
        
        showDeleteModal('{{ __("Delete ALL client results?") }}');
    });
    
    function showDeleteModal(message) {
        const isRevoke = deleteType === 'revoke';
        const headerClass = isRevoke ? 'bg-warning' : 'bg-danger';
        const headerTitle = isRevoke ? '{{ __("Confirm Revocation") }}' : '{{ __("Confirm Deletion") }}';
        const buttonClass = isRevoke ? 'btn-warning' : 'btn-danger';
        const buttonIcon = isRevoke ? 'ti-arrow-back-up' : 'ti-trash';
        const buttonText = isRevoke ? '{{ __("Revoke & Refund") }}' : '{{ __("Delete") }}';
        
        let modalHtml = `
            <div class="modal fade" id="providerDeleteModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header ${headerClass} text-white">
                            <h5 class="modal-title"><i class="ti ti-alert-triangle me-2"></i>${headerTitle}</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert ${isRevoke ? 'alert-warning' : 'alert-danger'}">
                                <i class="ti ti-alert-circle me-2"></i>
                                <strong>{{ __('Warning: This action cannot be undone!') }}</strong>
                            </div>
                            <p>${message}</p>
                            ${isRevoke ? `
                            <div class="mt-3">
                                <strong>{{ __('This will:') }}</strong>
                                <ul class="mt-2">
                                    <li>{{ __('Remove client access to assessment') }}</li>
                                    ${deleteData && deleteData.isAdminRevoke && deleteData.paidBy === 'provider' && deleteData.amount > 0 ? 
                                        '<li>{{ __("Refund credits to provider wallet") }}</li>' : 
                                        (deleteData && !deleteData.isAdminRevoke ? '<li>{{ __("Refund credits to your wallet") }}</li>' : '')}
                                    <li>{{ __('Delete assignment record') }}</li>
                                </ul>
                            </div>
                            ` : `
                            <div class="mt-3">
                                <strong>{{ __('This will permanently delete:') }}</strong>
                                <ul class="mt-2">
                                    <li>{{ __('Assignment data') }}</li>
                                    <li>{{ __('Payment records') }}</li>
                                    <li>{{ __('Assessment results') }}</li>
                                </ul>
                            </div>
                            `}
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                <i class="ti ti-x me-2"></i>{{ __('Cancel') }}
                            </button>
                            <button type="button" class="btn ${buttonClass}" id="confirmProviderDeleteBtn">
                                <i class="${buttonIcon} me-2"></i>${buttonText}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Remove existing modal if any
        $('#providerDeleteModal').remove();
        
        // Add new modal to body
        $('body').append(modalHtml);
        
        // Show modal
        const modal = new bootstrap.Modal(document.getElementById('providerDeleteModal'));
        modal.show();
        
        // Handle delete confirmation
        $('#confirmProviderDeleteBtn').on('click', function() {
            processProviderDelete();
        });
    }
    
    function processProviderDelete() {
        const button = $('#confirmProviderDeleteBtn');
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>{{ __("Deleting...") }}');
        
        let url = '';
        let data = {
            _token: $('meta[name="csrf-token"]').attr('content')
        };
        
        switch(deleteType) {
            case 'revoke':
                url = '{{ route("provider.paradigm.revoke-assignment") }}';
                data.payment_id = deleteId;
                break;
            case 'assigned':
                url = '{{ route("provider.paradigm.delete-assignment") }}';
                data.payment_id = deleteId;
                break;
            case 'client_link':
                url = '{{ route("provider.paradigm.delete-client-link") }}';
                data.result_id = deleteId;
                break;
            case 'all_assigned':
                url = '{{ route("provider.paradigm.delete-all-assignments") }}';
                break;
            case 'all_client_links':
                url = '{{ route("provider.paradigm.delete-all-client-links") }}';
                break;
        }
        
        $.ajax({
            url: url,
            method: 'POST',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message || '{{ __("Deletion successful") }}');
                    setTimeout(function() {
                        loadGeneratedLinks();
                        loadClientLink();
                    }, 1500);
                } else {
                    toastr.error(response.message || '{{ __("Deletion failed") }}');
                }
            },
            error: function(xhr) {
                console.error('Delete error:', xhr);
                const errorMsg = xhr.responseJSON?.message || '{{ __("Deletion failed") }}';
                toastr.error(errorMsg);
            },
            complete: function() {
                button.prop('disabled', false).html('<i class="ti ti-trash me-2"></i>{{ __("Delete") }}');
                $('#providerDeleteModal').modal('hide');
            }
        });
    }
});
</script>
@endpush
