@extends('provider.provider')

@section('content')
<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">{{ __('Transfer Profile') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('provider.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('provider.paradigm.marketplace.my-purchases') }}">{{ __('My Purchases') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Transfer Profile') }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('Transfer Profile to Another Practitioner') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <strong>{{ __('Current Profile') }}:</strong>
                            <p>{{ $purchase->result->name }} {{ $purchase->result->surname }} - {{ $purchase->result->paradigm_type ?? 'N/A' }}</p>
                        </div>

                        <form id="transferForm">
                            <div class="mb-3">
                                <label class="form-label">{{ __('New Practitioner Email') }} <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="practitioner_email" required>
                                <small class="text-muted">{{ __('Enter the email of the practitioner to transfer this profile to') }}</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">{{ __('Transfer Price (Credits)') }} <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="transfer_price" step="0.01" min="0.01" required>
                                <small class="text-muted">{{ __('Set the price the new practitioner will pay for this profile') }}</small>
                            </div>

                            <div class="alert alert-info">
                                <i class="ti ti-info-circle me-2"></i>
                                {{ __('The new practitioner will pay the transfer price, and you will receive the credits in your wallet.') }}
                            </div>

                            <div class="d-flex justify-content-between mt-4">
                                <a href="{{ route('provider.paradigm.marketplace.my-purchases') }}" class="btn btn-secondary">
                                    <i class="ti ti-arrow-left me-1"></i>{{ __('Cancel') }}
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="ti ti-transfer me-1"></i>{{ __('Transfer Profile') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#transferForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = {
            practitioner_email: $('input[name="practitioner_email"]').val(),
            transfer_price: $('input[name="transfer_price"]').val()
        };

        if (!confirm('{{ __("Are you sure you want to transfer this profile? The new practitioner will be charged :price credits.") }}'.replace(':price', formData.transfer_price))) {
            return;
        }

        $.ajax({
            url: '{{ route("provider.paradigm.marketplace.transfer.process", $purchase->id) }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    toastr.error(response.message);
                } else {
                    toastr.error('{{ __("Transfer failed") }}');
                }
            }
        });
    });
});
</script>
@endpush

