@extends('provider.provider')

@section('content')
<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">{{ __('Marketplace') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('provider.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Marketplace') }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Filters -->
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <input type="text" class="form-control" id="searchInput" placeholder="{{ __('Search by name...') }}">
                            </div>
                            <div class="col-md-4">
                                <select class="form-control" id="typeFilter">
                                    <option value="">{{ __('All Types') }}</option>
                                    <option value="The Analyst">{{ __('The Analyst') }} (LU)</option>
                                    <option value="The Organiser">{{ __('The Organiser') }} (LL)</option>
                                    <option value="The Visionary">{{ __('The Visionary') }} (RU)</option>
                                    <option value="The Helper">{{ __('The Helper') }} (RL)</option>
                                    <option value="The Specialist">{{ __('The Specialist') }} (LL + LU)</option>
                                    <option value="The Strategist">{{ __('The Strategist') }} (LU + RU)</option>
                                    <option value="The Advisor">{{ __('The Advisor') }} (LU + RL)</option>
                                    <option value="The Architect">{{ __('The Architect') }} (LL + RU)</option>
                                    <option value="The Harmoniser">{{ __('The Harmoniser') }} (LL + RL)</option>
                                    <option value="The Creator">{{ __('The Creator') }} (RL + RU)</option>
                                    <option value="The Innovator">{{ __('The Innovator') }} (LL + LU + RU)</option>
                                    <option value="The Stabiliser">{{ __('The Stabiliser') }} (LL + LU + RL)</option>
                                    <option value="The Integrator">{{ __('The Integrator') }} (LU + RL + RU)</option>
                                    <option value="The Vision Builder">{{ __('The Vision Builder') }} (LL + RL + RU)</option>
                                    <option value="The Whole-Brain Thinker">{{ __('The Whole-Brain Thinker') }} (All Frames)</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <a href="{{ route('provider.paradigm.marketplace.my-purchases') }}" class="btn btn-outline-primary">
                                    <i class="ti ti-shopping-bag me-1"></i>{{ __('My Purchases') }}
                                </a>
                            </div>
                        </div>

                        <!-- Profiles Table -->
                        <div class="table-responsive">
                            <table class="table table-hover table-center mb-0">
                                <thead>
                                    <tr>
                                        <th>{{ __('Client Name') }}</th>
                                        <th>{{ __('Paradigm Type') }}</th>
                                        <th>{{ __('Price') }}</th>
                                        <th>{{ __('Listed Date') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($profiles as $profile)
                                        <tr>
                                            <td>{{ $profile->name }} {{ $profile->surname }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ $profile->paradigm_type ?? 'N/A' }}</span>
                                            </td>
                                            <td>
                                                <strong>{{ number_format($profile->marketplace_price ?? 0, 2) }} {{ __('Credits') }}</strong>
                                            </td>
                                            <td>{{ $profile->marketplace_listed_at ? $profile->marketplace_listed_at->format('Y-m-d') : 'N/A' }}</td>
                                            <td>
                                                <a href="{{ route('provider.paradigm.marketplace.show', $profile->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="ti ti-eye me-1"></i>{{ __('View') }}
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">{{ __('No profiles available in marketplace') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $profiles->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#searchInput, #typeFilter').on('change keyup', function() {
        const search = $('#searchInput').val();
        const type = $('#typeFilter').val();
        const url = new URL(window.location.href);
        if (search) url.searchParams.set('search', search);
        else url.searchParams.delete('search');
        if (type) url.searchParams.set('type', type);
        else url.searchParams.delete('type');
        window.location.href = url.toString();
    });
});
</script>
@endpush

