@extends('provider.provider')

@section('content')
<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">{{ __('Link Requests') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('provider.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Link Requests') }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Filters -->
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <select class="form-control" id="statusFilter">
                                    <option value="">{{ __('All Status') }}</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ __('Pending') }}</option>
                                    <option value="accepted" {{ request('status') == 'accepted' ? 'selected' : '' }}>{{ __('Accepted') }}</option>
                                    <option value="declined" {{ request('status') == 'declined' ? 'selected' : '' }}>{{ __('Declined') }}</option>
                                </select>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-hover table-center mb-0">
                                <thead>
                                    <tr>
                                        <th>{{ __('Client Name') }}</th>
                                        <th>{{ __('Paradigm Type') }}</th>
                                        <th>{{ __('Request Date') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($requests as $request)
                                        @php
                                            $client = $request->client;
                                            $clientName = 'N/A';
                                            if ($client && $client->userDetail) {
                                                $clientName = trim(($client->userDetail->first_name ?? '') . ' ' . ($client->userDetail->last_name ?? ''));
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ $clientName }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ $request->result->paradigm_type ?? 'N/A' }}</span>
                                            </td>
                                            <td>{{ $request->requested_at->format('Y-m-d H:i') }}</td>
                                            <td>
                                                @if($request->status == 'pending')
                                                    <span class="badge bg-warning">{{ __('Pending') }}</span>
                                                @elseif($request->status == 'accepted')
                                                    <span class="badge bg-success">{{ __('Accepted') }}</span>
                                                @else
                                                    <span class="badge bg-danger">{{ __('Declined') }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($request->status == 'pending')
                                                    <span class="badge bg-warning">
                                                        <i class="ti ti-clock me-1"></i>{{ __('Waiting for Approval') }}
                                                    </span>
                                                @elseif($request->status == 'accepted')
                                                    <span class="badge bg-success">
                                                        <i class="ti ti-check me-1"></i>{{ __('Accepted') }}
                                                    </span>
                                                @else
                                                    <span class="badge bg-danger">
                                                        <i class="ti ti-x me-1"></i>{{ __('Declined') }}
                                                    </span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">{{ __('No link requests found') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $requests->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#statusFilter').on('change', function() {
        const status = $(this).val();
        const url = new URL(window.location.href);
        if (status) url.searchParams.set('status', status);
        else url.searchParams.delete('status');
        window.location.href = url.toString();
    });
});
</script>
@endpush

