@extends('provider.provider')

@section('content')
<style>
/* Brand Color Buttons */
.btn-primary {
    background-color: #044f54 !important;
    border-color: #044f54 !important;
    color: white !important;
}

.btn-primary:hover, .btn-primary:focus, .btn-primary:active {
    background-color: #033d41 !important;
    border-color: #033d41 !important;
    color: white !important;
}

.btn-outline-primary {
    border-color: #044f54 !important;
    color: #044f54 !important;
}

.btn-outline-primary:hover, .btn-outline-primary:focus, .btn-outline-primary:active {
    background-color: #044f54 !important;
    border-color: #044f54 !important;
    color: white !important;
}

.btn-success:hover, .btn-success:focus, .btn-success:active {
    opacity: 0.85;
}

.btn-light:hover, .btn-light:focus, .btn-light:active {
    opacity: 0.85;
}
</style>
<div class="page-wrapper">
    <div class="content container-fluid pb-0">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('1 Free Paradigm Profiles™') }}</h4>
                        <p class="card-subtitle">{{ __('Take your own free Paradigm Profile assessment') }}</p>
                    </div>
                    <div class="card-body">
                        
                        <!-- Free Assessment Button -->
                        @php
                            try {
                                $user = Auth::user();
                                // Force refresh from database
                                $user->refresh();
                                $freeAssessmentUsed = isset($user->free_assessment_used) ? $user->free_assessment_used : false;
                                $freeAssessmentId = isset($user->free_assessment_id) ? $user->free_assessment_id : null;
                                
                                // Check if free assessment is completed
                                $freeAssessmentCompleted = false;
                                $assessmentLink = null;
                                $assessmentStarted = false;
                                $resultId = null;
                                
                                if ($freeAssessmentId) {
                                    $freePayment = \App\Models\ParadigmPayment::find($freeAssessmentId);
                                    if ($freePayment) {
                                        // Get access token
                                        $accessToken = \App\Models\ParadigmAccessToken::where('payment_id', $freeAssessmentId)->first();
                                        
                                        if ($accessToken) {
                                            $assessmentStarted = true;
                                            
                                            // Check if completed (has a result) - check by email since provider_id might be admin
                                            $result = \App\Models\ParadigmAssessmentResult::where('email', $user->email)
                                                ->whereNotNull('paradigm_type')
                                                ->where(function($query) use ($user) {
                                                    $query->where('provider_id', $user->id)
                                                          ->orWhere('provider_id', 1); // Admin ID for free assessments
                                                })
                                                ->orderBy('created_at', 'desc')
                                                ->first();
                                            
                                            if ($result) {
                                                $freeAssessmentCompleted = true;
                                                $resultId = $result->id;
                                                $assessmentLink = route('paradigm.results.download-pdf', ['resultId' => $resultId]);
                                            } else {
                                                // Not completed yet - link to start assessment
                                                $assessmentLink = route('paradigm.assessment.show', ['templateId' => $freePayment->template_id]);
                                            }
                                        }
                                    }
                                }
                            } catch (\Exception $e) {
                                // Silently handle any errors
                                $freeAssessmentUsed = false;
                                $freeAssessmentId = null;
                                $freeAssessmentCompleted = false;
                                $assessmentLink = null;
                                $assessmentStarted = false;
                            }
                        @endphp
                        
                        @if(!$freeAssessmentUsed)
                            <!-- Show Free Assessment Button -->
                            <div class="d-flex align-items-center mb-3" style="background: #044f54; padding: 12px 20px; border-radius: 8px;">
                                <i class="ti ti-gift text-white me-2" style="font-size: 20px;"></i>
                                <span class="text-white me-auto" style="font-size: 14px;">{{ __('1 Free Assessment Available - Take Your Own Profile') }}</span>
                                <button type="button" class="btn btn-light btn-sm" id="useFreeAssessmentBtn" style="font-size: 13px;">
                                    <i class="ti ti-rocket me-1"></i>{{ __('Use Free Assessment') }}
                                </button>
                            </div>
                        @elseif($freeAssessmentCompleted)
                            <!-- Show Download Button -->
                            <div class="d-flex align-items-center mb-3" style="background: #044f54; padding: 12px 20px; border-radius: 8px;">
                                <i class="ti ti-file-download text-white me-2" style="font-size: 20px;"></i>
                                <span class="text-white me-auto" style="font-size: 14px;">{{ __('Your Free Assessment Report') }}</span>
                                <a href="{{ $assessmentLink }}" 
                                   class="btn btn-light btn-sm" style="font-size: 13px;">
                                    <i class="ti ti-download me-1"></i>{{ __('Download Report') }}
                                </a>
                            </div>
                        @elseif($freeAssessmentUsed && !$freeAssessmentCompleted && $assessmentStarted)
                            <!-- Show Start Assessment Button -->
                            <div class="d-flex align-items-center mb-3" style="background: #044f54; padding: 12px 20px; border-radius: 8px;">
                                <i class="ti ti-pencil text-white me-2" style="font-size: 20px;"></i>
                                <span class="text-white me-auto" style="font-size: 14px;">{{ __('Your Free Assessment Is Ready') }}</span>
                                <a href="{{ $assessmentLink }}" 
                                   class="btn btn-light btn-sm" target="_blank" style="font-size: 13px;">
                                    <i class="ti ti-play me-1"></i>{{ __('Start Assessment') }}
                                </a>
                            </div>
                        @elseif($freeAssessmentUsed && !$freeAssessmentCompleted)
                            <!-- Show Pending Status -->
                            <div class="d-flex align-items-center mb-3" style="background: #044f54; padding: 12px 20px; border-radius: 8px;">
                                <i class="ti ti-clock text-white me-2" style="font-size: 20px;"></i>
                                <span class="text-white" style="font-size: 14px;">{{ __('Free Assessment In Progress') }}</span>
                            </div>
                        @endif
                        
                        <!-- Information Section -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <h5 class="alert-heading"><i class="ti ti-info-circle me-2"></i>{{ __('About Your Free Assessment') }}</h5>
                                    <p class="mb-2">{{ __('As a verified practitioner or professional, you receive one complimentary Paradigm Profile assessment to take for yourself.') }}</p>
                                    <hr>
                                    <ul class="mb-0">
                                        <li>{{ __('Complete the assessment at your own pace') }}</li>
                                        <li>{{ __('Download your personalized PDF report when finished') }}</li>
                                        <li>{{ __('This is a one-time offer per account') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
let templatesData = [];

$(document).ready(function() {
    // Load templates
    loadTemplates();

    // Free Assessment Button Handler
    $('#useFreeAssessmentBtn').on('click', function() {
        const $btn = $(this);
        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1"></span>Creating...');
        
        // Get user's details from profile
        const userEmail = '{{ Auth::user()->email }}';
        const userDetails = @json(Auth::user()->userDetail ?? null);
        const userPhone = '{{ Auth::user()->phone_number ?? "" }}';
        
        // Get first template (default)
        const firstTemplateId = templatesData.length > 0 ? templatesData[0].id : null;
        
        if (!firstTemplateId) {
            toastr.error('{{ __("No templates available. Please contact administrator.") }}', '{{ __("Error") }}');
            $btn.prop('disabled', false).html('<i class="ti ti-rocket me-1"></i>{{ __("Use Free Assessment") }}');
            return;
        }
        
        // Validate required fields
        if (!userDetails || !userDetails.first_name || !userDetails.last_name || !userDetails.gender || !userDetails.dob) {
            toastr.error('{{ __("Please complete your profile (name, gender, date of birth) before creating a free assessment.") }}', '{{ __("Profile Incomplete") }}');
            $btn.prop('disabled', false).html('<i class="ti ti-rocket me-1"></i>{{ __("Use Free Assessment") }}');
            return;
        }
        
        // Create free assessment for user
        $.ajax({
            url: '{{ route("paradigm.payment.generate-link") }}',
            method: 'POST',
            headers: {
                'Authorization': 'Bearer ' + localStorage.getItem('admin_token'),
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
                template_id: firstTemplateId,
                client_email: userEmail,
                client_name: userDetails.first_name,
                client_surname: userDetails.last_name,
                client_gender: userDetails.gender,
                client_dob: userDetails.dob,
                client_whatsapp: userPhone || userDetails.mobile_number || '',
                payment_type: 'free',
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    toastr.success('{{ __("Your free assessment has been created! The page will reload.") }}', '{{ __("Success") }}');
                    
                    // Reload page after 2 seconds to show the new state
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    toastr.error(response.message || '{{ __("Failed to create free assessment") }}', '{{ __("Error") }}');
                    $btn.prop('disabled', false).html('<i class="ti ti-rocket me-1"></i>{{ __("Use Free Assessment") }}');
                }
            },
            error: function(xhr) {
                const errorMsg = xhr.responseJSON?.message || '{{ __("An error occurred") }}';
                toastr.error(errorMsg, '{{ __("Error") }}');
                $btn.prop('disabled', false).html('<i class="ti ti-rocket me-1"></i>{{ __("Use Free Assessment") }}');
            }
        });
    });
    
    function loadTemplates() {
        $.ajax({
            url: '{{ route("provider.paradigm.templates.json") }}',
            method: 'GET',
            success: function(response) {
                if (response && response.length > 0) {
                    templatesData = response; // Store for later use
                }
            },
            error: function(xhr) {
                console.error('Failed to load templates:', xhr);
            }
        });
    }
});
</script>
@endpush

