<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>P16 Assessment - No Elements Configured</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 40px;
            color: #333;
            text-align: center;
        }
        .header {
            margin-bottom: 40px;
        }
        .content {
            max-width: 600px;
            margin: 0 auto;
            line-height: 1.6;
        }
        .warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .steps {
            text-align: left;
            margin: 30px 0;
        }
        .steps ol {
            padding-left: 20px;
        }
        .steps li {
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>P16 Assessment Results</h1>
        <h2>{{ $template->name ?? 'Personality-16 Assessment' }}</h2>
    </div>
    
    <div class="content">
        <div class="warning">
            <h3>⚠️ No PDF Elements Configured</h3>
            <p>This template doesn't have any PDF elements configured yet. You need to use the PDF Builder to create your custom layout.</p>
        </div>
        
        <h3>Sample Assessment Results:</h3>
        <p><strong>Personality Type:</strong> INFJ</p>
        <p><strong>Description:</strong> You are a creative and insightful individual who is driven by your values and vision.</p>
        
        <div class="steps">
            <h3>To configure PDF elements:</h3>
            <ol>
                <li>Go to the PDF Builder: <code>/pdf-builder?template={{ $template->id ?? 1 }}</code></li>
                <li>Drag and drop elements from the sidebar to the canvas</li>
                <li>Position and style the elements as needed</li>
                <li>Save the elements</li>
                <li>Test the PDF generation again</li>
            </ol>
        </div>
        
        <p><em>Generated on: {{ now()->format('Y-m-d H:i:s') }}</em></p>
    </div>
</body>
</html>
