<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assessment Results</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: #333;
            background: #fff;
        }
        
        .pdf-container {
            width: 100%;
            min-height: 100vh;
            position: relative;
        }
        
        .page {
            width: 210mm;
            height: 297mm;
            position: relative;
            page-break-after: always;
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            margin: 0;
            padding: 0;
            /* Ensure consistent positioning */
            box-sizing: border-box;
        }
        
        .page:last-child {
            page-break-after: avoid;
        }
        
        /* Element positioning system */
        .element {
            position: absolute;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .element-text {
            font-size: 14px;
            line-height: 1.4;
        }
        
        .element-number {
            font-size: 24px;
            font-weight: 700;
            color: #667eea;
        }
        
        /* Score elements specific styling */
        .element-score_e,
        .element-score_i,
        .element-score_s,
        .element-score_n,
        .element-score_t,
        .element-score_f,
        .element-score_j,
        .element-score_p {
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            line-height: 1;
        }
        
        .element-pill {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 14px;
        }
        
        .element-image {
            max-width: 100%;
            height: auto;
        }
        
        /* CSS Grid support */
        .grid-container {
            display: grid;
            width: 100%;
            height: 100%;
        }
        
        /* Flexbox support */
        .flex-container {
            display: flex;
            width: 100%;
            height: 100%;
        }
        
        /* Responsive design */
        @media print {
            .page {
                width: 210mm;
                height: 297mm;
            }
        }
        
        /* Animation support */
        .fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Utility classes */
        .text-center { text-align: center; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        
        .font-bold { font-weight: 700; }
        .font-semibold { font-weight: 600; }
        .font-medium { font-weight: 500; }
        
        .text-sm { font-size: 12px; }
        .text-base { font-size: 14px; }
        .text-lg { font-size: 18px; }
        .text-xl { font-size: 24px; }
        .text-2xl { font-size: 32px; }
    </style>
</head>
<body>
    <div class="pdf-container">
        @yield('content')
    </div>
</body>
</html>
