@php
    $a4WidthPt = 595.28;
    $a4HeightPt = 841.89;

    // Build user details content
    $fullName = trim(($data['name'] ?? '') . ' ' . ($data['surname'] ?? ''));
    $email = $data['email'] ?? 'N/A';
    $phone = $data['phone'] ?? 'N/A';
    $gender = $data['gender'] ?? 'N/A';
    $ageRange = $data['age_range'] ?? 'N/A';
    
    // Calculate base position and dimensions
    $xPos = ($element['x_pct'] / 100) * $a4WidthPt;
    $yPos = ($element['y_pct'] / 100) * $a4HeightPt;
    $baseFontSize = $element['font_px'] ?? 10;
    
    // RIGHT-TO-LEFT AUTO-SIZING: Calculate width based on content
    $charWidthEstimate = $baseFontSize * 0.5; // Arial is roughly 0.5em
    
    // Build content lines for right-to-left layout
    $lines = [];
    
    // Line 1: Name (bold) - no role header
    
    // Line 1: Name (bold)
    $lines[] = ['text' => ($fullName ?: 'N/A'), 'style' => 'font-weight: bold;'];
    
    // Line 2: Email
    if ($email !== 'N/A') {
        $lines[] = ['text' => $email, 'style' => 'font-weight: normal;'];
    }
    
    // Line 3: Profile attributes (Gender: X Age Range: Y)
    $profileLine = '';
    if ($gender !== 'N/A' && $ageRange !== 'N/A') {
        $profileLine = 'Gender: ' . $gender . ' Age Range: ' . $ageRange;
    } elseif ($gender !== 'N/A') {
        $profileLine = 'Gender: ' . $gender;
    } elseif ($ageRange !== 'N/A') {
        $profileLine = 'Age Range: ' . $ageRange;
    }
    if ($profileLine) {
        $lines[] = ['text' => $profileLine, 'style' => 'font-weight: normal;'];
    }
    
    // Line 4: Phone (under everything)
    if ($phone !== 'N/A') {
        $lines[] = ['text' => $phone, 'style' => 'font-weight: normal;'];
    }
    
    // If both email and phone are N/A
    if ($email === 'N/A' && $phone === 'N/A') {
        $lines[] = ['text' => 'Contact not provided', 'style' => 'font-weight: normal;'];
    }
    
    // Calculate width based on longest line
    $maxLineLength = 0;
    foreach ($lines as $line) {
        if (strlen($line['text']) > $maxLineLength) {
            $maxLineLength = strlen($line['text']);
        }
    }
    $contentWidth = $maxLineLength * $charWidthEstimate;
    $minWidth = ($element['w_pct'] / 100) * $a4WidthPt;
    $width = max($minWidth, $contentWidth + 10); // Add padding
    
    // FIXED HEIGHT - NO VERTICAL RESIZING
    $lineHeight = $baseFontSize * 1.2; // Tighter line spacing
    $height = (count($lines) * $lineHeight) + 4; // Reduced padding
@endphp

<div style="position: absolute; left: {{ $xPos }}pt; top: {{ $yPos }}pt; width: {{ $width }}pt; height: {{ $height }}pt; font-size: {{ $baseFontSize }}px; color: {{ $element['color'] }}; background-color: transparent; padding: 2pt; box-sizing: border-box; font-family: Arial, sans-serif; overflow: hidden;">
    @foreach($lines as $line)
        <div style="line-height: {{ $lineHeight }}px; text-align: right; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; {{ $line['style'] }}">
            {{ $line['text'] }}
        </div>
    @endforeach
</div>

