@php
    $a4WidthPt = 595.28;
    $a4HeightPt = 841.89;

    // Get the combined full name
    $fullName = trim(($data['name'] ?? '') . ' ' . ($data['surname'] ?? ''));
    if (empty($fullName)) {
        $fullName = 'N/A';
    }

    // Calculate base position and dimensions
    $yPos = ($element['y_pct'] / 100) * $a4HeightPt;
    $baseFontSize = $element['font_px'] ?? 12;
    
    // AUTO-SIZING: Calculate width based on content length
    // Approximate character width (varies by font, using average)
    $charWidthEstimate = $baseFontSize * 0.6; // Rough estimate for character width
    $contentWidth = strlen($fullName) * $charWidthEstimate;
    $minWidth = ($element['w_pct'] / 100) * $a4WidthPt; // Use specified width as minimum
    $width = max($minWidth, $contentWidth + 10); // Add padding
    
    // HARDCODED CENTER: Calculate xPos to center the element horizontally on the page
    $xPos = ($a4WidthPt - $width) / 2;
    
    // AUTO-SIZING: Height based on font size
    $height = $baseFontSize * 1.5; // Line height factor
@endphp

<span style="position: absolute; left: {{ $xPos }}pt; top: {{ $yPos }}pt; width: {{ $width }}pt; height: {{ $height }}pt; font-size: {{ $baseFontSize }}px; color: {{ $element['color'] }}; text-align: center; font-weight: {{ $element['font_weight'] ?? 'normal' }}; display: flex; align-items: center; justify-content: center; overflow: visible; white-space: nowrap;">
    {{ $fullName }}
</span>

