<section class="hero-section" id="home" style="position: relative; min-height: 100vh;">
    <!-- Overlay for better text readability -->
    <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(255, 255, 255, 0.85); z-index: 1;"></div>
    
    @foreach($section['section_content'] as $banner)
    <div class="hero-content position-relative" style="z-index: 2; min-height: 70vh; display: flex; align-items: center; padding: 2rem 0;">
        <div class="container">
            <div class="row justify-content-center">
                <!-- Centered Content Container - Made smaller and centered -->
                <div class="col-12 col-lg-10 col-xl-8">
                    <div class="row align-items-center">
                        <!-- Request Help Form (Left Column) -->
                        <div class="col-lg-6">
                            <div class="wow fadeInUp" data-wow-duration="1s" data-wow-delay=".25s">
                                @include('partials.request-help-form')
                            </div>
                        </div>
                        
                        <!-- Descriptive Text (Right Column) -->
                        <div class="col-lg-6">
                            <div class="hero-text-content wow fadeInUp" data-wow-duration="1s" data-wow-delay=".5s" style="text-align: left !important;">
                                <!-- Main Heading -->
                                <h1 class="hero-main-title" style="font-size: 1.8rem !important; font-weight: 700 !important; line-height: 1.6 !important; text-align: left !important; color: #044f54 !important; margin-bottom: 1.5rem !important;">
                                    Why People Trust<br>
                                    <span style="color: white !important; background-color: #044f54 !important; padding: 0.3rem 0.8rem !important; border-radius: 0.4rem !important; display: inline-block !important; box-shadow: 0 2px 8px rgba(4, 79, 84, 0.3) !important; border: none !important;">iSeekHelp International™</span><br>
                                    for Real Help and Lasting Change
                                </h1>
                                
                                <!-- Introduction Paragraph removed -->
                                
                                <!-- Trust & Quality Section with Bullet Points -->
                                <div class="trust-quality-section mb-4" style="text-align: left !important;">
                                    <h3 class="section-title" style="font-size: 1.3rem !important; font-weight: 600 !important; color: #044f54 !important; margin-bottom: 1rem !important; text-align: left !important;">
                                        Our Platform is Built On:
                                    </h3>
                                    <ul class="trust-list" style="list-style: none !important; padding-left: 0 !important; margin-bottom: 1.5rem !important;">
                                        <li class="trust-item mb-2" style="display: flex !important; align-items: flex-start !important; text-align: left !important;">
                                            <span class="bullet-icon" style="color: #10b981 !important; font-size: 1.2rem !important; margin-right: 0.75rem !important; margin-top: 0.1rem !important;">✓</span>
                                            <span class="trust-text" style="font-size: 1.05rem !important; line-height: 1.6 !important; color: #374151 !important;">Trust, quality, and compassion offering a seamless way to find professional support you can rely on</span>
                                        </li>
                                        <li class="trust-item mb-2" style="display: flex !important; align-items: flex-start !important; text-align: left !important;">
                                            <span class="bullet-icon" style="color: #10b981 !important; font-size: 1.2rem !important; margin-right: 0.75rem !important; margin-top: 0.1rem !important;">✓</span>
                                            <span class="trust-text" style="font-size: 1.05rem !important; line-height: 1.6 !important; color: #374151 !important;">Each practitioner is carefully vetted to ensure they meet the highest standards in their field</span>
                                        </li>
                                    </ul>
                                </div>
                                
                                <!-- Change Message -->
                                <div class="change-message mb-4" style="text-align: left !important;">
                                    <p class="change-text" style="font-size: 1.1rem !important; line-height: 1.7 !important; text-align: left !important; color: #374151 !important; font-style: italic !important; margin-bottom: 2rem !important;">
                                        Because when you're ready for change, the right support makes all the difference.
                                    </p>
                                </div>
                                
                                <!-- Final CTA Text -->
                                <div class="cta-section" style="text-align: left !important;">
                                    <p class="cta-text" style="font-size: 1.3rem !important; font-weight: 700 !important; line-height: 1.4 !important; text-align: left !important; color: #044f54 !important; margin-bottom: 0 !important; font-style: italic !important; letter-spacing: 0.5px !important;">
                                        Choose iSeekHelp International™ where healing meets action.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Floating elements removed for clean design -->
    </div>
    <div class="modal fade wallet-modal home-modal" id="add-offer" data-bs-backdrop="static" data-bs-keyboard="false"
        tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content" id="modalBody">
                <div class="modal-header d-flex align-items-center justify-content-between border-0">
                    <h5>{{ __('Find the Best Professionals') }}</h5>
                    <a href="#!" data-bs-dismiss="modal" aria-label="Close"><i
                            class="ti ti-circle-x-filled fs-24"></i></a>
                </div>
                <form action="">
                    <div class="modal-body " id="modal-body-content">
                    </div>
                </form>
                <div class="modal-footer">
                    <button type="button" id="back-btn" class="btn btn-secondary">{{ __('Back') }}</button>
                    <button type="submit" id="continue-btn" class="btn btn-dark">{{ __('Continue') }}</button>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</section>

<script>
    // Search Form Location Dropdowns - robust loader with fallbacks
    (function() {
        // Blade fallbacks (server-side read) in case AJAX fails entirely
        // These are safe no-ops if files are missing
        try {
            window.__SEARCH_FALLBACK__ = {
                countries: @json((json_decode(@file_get_contents(public_path('countries.json')), true)['countries'] ?? [])),
                states: @json((json_decode(@file_get_contents(public_path('states.json')), true)['states'] ?? [])),
                cities: @json((json_decode(@file_get_contents(public_path('cities.json')), true)['cities'] ?? []))
            };
        } catch (e) {
            window.__SEARCH_FALLBACK__ = { countries: [], states: [], cities: [] };
        }

        function fetchJson(url) {
            if (window.fetch) {
                return fetch(url, { credentials: 'same-origin' }).then(r => r.json());
            }
            if (window.$ && $.getJSON) {
                return new Promise((resolve, reject) => {
                    $.getJSON(url).done(resolve).fail(reject);
                });
            }
            return Promise.reject(new Error('No fetch mechanism available'));
        }

    document.addEventListener('DOMContentLoaded', function() {
        let cachedCountriesSearch = [];
        let cachedStatesSearch = [];
        let cachedCitiesSearch = [];
        let locationDataLoadedSearch = false;

        // Load location data when page loads
        async function loadSearchLocationData() {
            console.log('🔄 Starting to load search location data...');
            try {
                // Add loading state
                $('#search_country, #search_country_location').closest('.input-group').addClass('loading');
                console.log('🔍 Loading JSON files...');
                const [countriesResponse, statesResponse, citiesResponse] = await Promise.all([
                    fetchJson('/countries.json'),
                    fetchJson('/states.json'),
                    fetchJson('/cities.json')
                ]);

                console.log('📦 JSON files loaded:', {
                    countries: countriesResponse.countries?.length || 0,
                    states: statesResponse.states?.length || 0,
                    cities: citiesResponse.cities?.length || 0
                });

                cachedCountriesSearch = countriesResponse.countries || window.__SEARCH_FALLBACK__.countries;
                cachedStatesSearch = statesResponse.states || window.__SEARCH_FALLBACK__.states;
                cachedCitiesSearch = citiesResponse.cities || window.__SEARCH_FALLBACK__.cities;

                locationDataLoadedSearch = true;
                console.log('🔄 Calling getSearchCountries()...');
                getSearchCountries();
                
                // Remove loading state
                $('#search_country, #search_country_location').closest('.input-group').removeClass('loading');
                
                console.log('✅ Search location data loaded successfully');
            } catch (error) {
                console.error("❌ Failed to load location data for search:", error);
                // Remove loading state on error
                $('#search_country, #search_country_location').closest('.input-group').removeClass('loading');
                
                // Use fallbacks if available
                if (window.__SEARCH_FALLBACK__.countries.length) {
                    cachedCountriesSearch = window.__SEARCH_FALLBACK__.countries;
                    cachedStatesSearch = window.__SEARCH_FALLBACK__.states;
                    cachedCitiesSearch = window.__SEARCH_FALLBACK__.cities;
                    getSearchCountries();
                } else {
                    // Show error in dropdowns
                    $('#search_country, #search_country_location').html('<option value="" selected disabled>Failed to load countries</option>');
                }
            }
        }

        function clearSearchDropdown(dropdown) {
            dropdown.empty().append(
                $("<option>", {
                    value: "",
                    text: "Select",
                    disabled: true,
                    selected: true,
                })
            );
        }

        function getSearchCountries(selectedCountry = null) {
            console.log('🌍 getSearchCountries called with:', selectedCountry);
            console.log('📊 Cached countries:', cachedCountriesSearch.length);
            
            const countrySelect1 = $("#search_country");
            const countrySelect2 = $("#search_country_location");
            
            console.log('🔍 Country selects found:', {
                select1: countrySelect1.length,
                select2: countrySelect2.length
            });
            
            // Populate first search form
            if (countrySelect1.length > 0) {
                clearSearchDropdown(countrySelect1);
                $.each(cachedCountriesSearch, function (index, country) {
                    countrySelect1.append(
                        $("<option>", {
                            value: country.name,
                            text: country.name,
                            'data-id': country.id,
                            selected: country.name == selectedCountry,
                        })
                    );
                });
                console.log('✅ Populated #search_country with', countrySelect1.find('option').length - 1, 'countries');
            }
            
            // Populate second search form
            if (countrySelect2.length > 0) {
                clearSearchDropdown(countrySelect2);
                $.each(cachedCountriesSearch, function (index, country) {
                    countrySelect2.append(
                        $("<option>", {
                            value: country.name,
                            text: country.name,
                            'data-id': country.id,
                            selected: country.name == selectedCountry,
                        })
                    );
                });
                console.log('✅ Populated #search_country_location with', countrySelect2.find('option').length - 1, 'countries');
            }

            if (selectedCountry) {
                const selectedCountryId = cachedCountriesSearch.find(c => c.name == selectedCountry)?.id;
                if (selectedCountryId) {
                    getSearchStates(selectedCountryId);
                }
            }
        }

        function getSearchStates(selectedCountryId, selectedState = null) {
            const stateSelect1 = $("#search_state");
            const stateSelect2 = $("#search_state_location");
            
            clearSearchDropdown(stateSelect1);
            clearSearchDropdown(stateSelect2);

            const states = cachedStatesSearch.filter(
                (state) => state.country_id == selectedCountryId
            );

            if (states.length === 1) {
                stateSelect1.append(
                    $("<option>", {
                        value: states[0].name,
                        text: states[0].name,
                        'data-id': states[0].id,
                        selected: true,
                    })
                );
                stateSelect2.append(
                    $("<option>", {
                        value: states[0].name,
                        text: states[0].name,
                        'data-id': states[0].id,
                        selected: true,
                    })
                );
                getSearchCities(states[0].id);
            } else {
                $.each(states, function (index, state) {
                    stateSelect1.append(
                        $("<option>", {
                            value: state.name,
                            text: state.name,
                            'data-id': state.id,
                            selected: state.name == selectedState,
                        })
                    );
                    stateSelect2.append(
                        $("<option>", {
                            value: state.name,
                            text: state.name,
                            'data-id': state.id,
                            selected: state.name == selectedState,
                        })
                    );
                });

                if (selectedState) {
                    const selectedStateId = states.find(s => s.name == selectedState)?.id;
                    if (selectedStateId) {
                        getSearchCities(selectedStateId);
                    }
                }
            }
        }

        function getSearchCities(selectedStateId, selectedCity = null) {
            const citySelect1 = $("#search_city");
            const citySelect2 = $("#search_city_location");
            
            clearSearchDropdown(citySelect1);
            clearSearchDropdown(citySelect2);

            const cities = cachedCitiesSearch.filter(
                (city) => city.state_id == selectedStateId
            );

            $.each(cities, function (index, city) {
                citySelect1.append(
                    $("<option>", {
                        value: city.name,
                        text: city.name,
                        'data-id': city.id,
                        selected: city.name == selectedCity,
                    })
                );
                citySelect2.append(
                    $("<option>", {
                        value: city.name,
                        text: city.name,
                        'data-id': city.id,
                        selected: city.name == selectedCity,
                    })
                );
            });
        }

        // Event listeners for search forms
        $("#search_country").on("change", function () {
            const selectedCountryName = $(this).val();
            const selectedCountryId = $(this).find('option:selected').data('id');
            
            clearSearchDropdown($("#search_state"));
            clearSearchDropdown($("#search_city"));
            
            if (selectedCountryId) {
                getSearchStates(selectedCountryId);
            }
        });

        $("#search_state").on("change", function () {
            const selectedStateId = $(this).find('option:selected').data('id');
            
            clearSearchDropdown($("#search_city"));
            
            if (selectedStateId) {
                getSearchCities(selectedStateId);
            }
        });

        $("#search_country_location").on("change", function () {
            const selectedCountryName = $(this).val();
            const selectedCountryId = $(this).find('option:selected').data('id');
            
            clearSearchDropdown($("#search_state_location"));
            clearSearchDropdown($("#search_city_location"));
            
            if (selectedCountryId) {
                getSearchStates(selectedCountryId);
            }
        });

        $("#search_state_location").on("change", function () {
            const selectedStateId = $(this).find('option:selected').data('id');
            
            clearSearchDropdown($("#search_city_location"));
            
            if (selectedStateId) {
                getSearchCities(selectedStateId);
            }
        });

        // Handle form submissions (isolate from other global handlers)
        $("#searchForm").off('submit.search').on("submit.search", function(e) {
            e.preventDefault();
            e.stopPropagation();
            e.stopImmediatePropagation();
            handleSearchFormSubmission('searchForm');
            return false;
        });

        $("#locationSearchForm").off('submit.search').on("submit.search", function(e) {
            e.preventDefault();
            e.stopPropagation();
            e.stopImmediatePropagation();
            handleSearchFormSubmission('locationSearchForm');
            return false;
        });

        function handleSearchFormSubmission(formId) {
            let countrySelect, stateSelect, citySelect;
            if (formId === 'searchForm') {
                countrySelect = $("#search_country");
                stateSelect = $("#search_state");
                citySelect = $("#search_city");
            } else {
                countrySelect = $("#search_country_location");
                stateSelect = $("#search_state_location");
                citySelect = $("#search_city_location");
            }
            
            const categoryDropdown = $("#categoryDropdown");
            const selectedOption = categoryDropdown.find(":selected");
            const categorySlug = selectedOption.data("slug");
            const selectedCountry = countrySelect.val();
            const selectedState = stateSelect.val();
            const selectedCity = citySelect.val();

            // Validation
            if (!selectedCountry || !selectedState || !selectedCity) {
                alert('Please select Country, State, and City to search for providers in your area.');
                return;
            }

            // Add loading state to button
            const submitBtn = $(`#${formId} button[type="submit"]`);
            const originalText = submitBtn.html();
            submitBtn.html('<i class="feather-loader me-2"></i>Searching...').prop('disabled', true);

            var queryParams = [];

            if (categorySlug) {
                queryParams.push('category=' + encodeURIComponent(categorySlug));
            }

            if (selectedCountry) {
                queryParams.push('country=' + encodeURIComponent(selectedCountry));
            }

            if (selectedState) {
                queryParams.push('state=' + encodeURIComponent(selectedState));
            }

            if (selectedCity) {
                queryParams.push('city=' + encodeURIComponent(selectedCity));
            }

            var queryString = queryParams.length > 0 ? '?' + queryParams.join('&') : '';

            // Small delay to show loading state
            setTimeout(() => {
            window.location.href = '/services' + queryString;
            }, 500);
        }

        // Initialize location data (with small delay to allow DOM to render selects)
        setTimeout(loadSearchLocationData, 200);
        });
    })();
</script>