@extends('front')
@section('title', __('Assessment Already Completed') . ' - ' . $companyName)
@section('description', __('This Paradigm Profile assessment has already been completed.'))
@section('keywords', 'paradigm profile, assessment completed')
@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-lg-6">
            <div class="card shadow-sm border-0" style="border-radius: 12px;">
                <div class="card-body text-center p-5">
                    <!-- Info Icon -->
                    <div class="mb-4">
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-info bg-opacity-10" style="width: 80px; height: 80px;">
                            <i class="ti ti-info-circle" style="font-size: 40px; color: #0ea5e9;"></i>
                        </div>
                    </div>
                    
                    <!-- Title -->
                    <h2 class="mb-3" style="color: #044f54; font-weight: 700;">{{ __('Assessment Already Completed') }}</h2>
                    
                    <!-- Message -->
                    <p class="text-muted mb-4" style="font-size: 1.1rem; line-height: 1.6;">
                        {{ __('This Paradigm Profile assessment has already been completed.') }}
                    </p>
                    
                    <!-- Important Notice -->
                    <div class="alert alert-info border-0 mb-4" style="background-color: #e0f2fe; border-left: 4px solid #0ea5e9 !important; text-align: left;">
                        <div class="d-flex align-items-start">
                            <i class="ti ti-info-circle me-2 mt-1" style="font-size: 20px; color: #0ea5e9;"></i>
                            <div>
                                <strong class="d-block mb-2" style="color: #0c4a6e;">{{ __('Important Notice') }}</strong>
                                <p class="mb-0" style="color: #075985; font-size: 0.95rem;">
                                    {!! __('Paradigm Profile has downloaded on your device, Please check your downloads folder.<br><br>Your download is always accessible via link and click the Download Report Button.<br><br>To gain access to you account reset your password on used email address and login. Thank You') !!}
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="d-flex justify-content-center mt-4 gap-3 flex-wrap">
                        <a href="{{ route('home') }}" class="btn btn-primary btn-lg px-4 py-3" style="min-width: 180px; border-radius: 8px; font-weight: 600;">
                            <i class="ti ti-home me-2"></i>{{ __('Go to Home Page') }}
                        </a>
                        @if(isset($downloadUrl))
                        <a href="{{ $downloadUrl }}" download class="btn btn-danger btn-lg px-4 py-3" style="min-width: 180px; border-radius: 8px; font-weight: 600;">
                            <i class="ti ti-download me-2"></i>{{ __('Download Report') }}
                        </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media (max-width: 576px) {
        .card-body {
            padding: 2rem 1.5rem !important;
        }
        .btn-lg {
            width: 100%;
        }
    }
</style>
@endsection

