@extends('admin.admin')

@section('content')

<div class="page-wrapper">
    <div class="content">
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Staff Verification') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="javascript:void(0);">{{ __('Branch & Staff Verification') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Staff Verification') }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="card">
            <div class="card-body p-0 py-3">
                <div class="custom-datatable-filter table-responsive">
                    <table id="loader-table" class="table table-bordered">
                        <thead class="thead-light">
                            <tr>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                            </tr>
                        </thead>
                        <tbody>
                            @for($i = 0; $i < 5; $i++)
                            <tr>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                            </tr>
                            @endfor
                        </tbody>
                    </table>
                    <table class="table d-none" id="staffVerificationTable">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>{{__('Staff Name')}}</th>
                                <th>{{__('Email')}}</th>
                                <th>{{__('Category')}}</th>
                                <th>{{__('Documents')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Created On')}}</th>
                                <th>{{__('Action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- View Staff Modal -->
<div class="modal fade" id="viewStaffModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Staff Verification Details') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="staffDetails">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>{{ __('Staff Name') }}:</strong>
                            <p id="staff_name"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>{{ __('Email') }}:</strong>
                            <p id="staff_email"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>{{ __('Phone') }}:</strong>
                            <p id="staff_phone"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>{{ __('Category') }}:</strong>
                            <p id="staff_category"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <strong>{{ __('Address') }}:</strong>
                            <p id="staff_address"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <strong>{{ __('City') }}:</strong>
                            <p id="staff_city"></p>
                        </div>
                        <div class="col-md-4">
                            <strong>{{ __('State') }}:</strong>
                            <p id="staff_state"></p>
                        </div>
                        <div class="col-md-4">
                            <strong>{{ __('Country') }}:</strong>
                            <p id="staff_country"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>{{ __('Postal Code') }}:</strong>
                            <p id="staff_postal"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>{{ __('Status') }}:</strong>
                            <p id="staff_status"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <strong>{{ __('Bio') }}:</strong>
                            <p id="staff_bio"></p>
                        </div>
                    </div>
                    <hr>
                    <h6>{{ __('Uploaded Documents') }}</h6>
                    <div id="staff_documents_list" class="row"></div>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="current_staff_id">
                <button type="button" class="btn btn-danger" id="rejectStaffBtn">
                    <i class="ti ti-x me-1"></i>{{ __('Reject') }}
                </button>
                <button type="button" class="btn btn-success" id="approveStaffBtn">
                    <i class="ti ti-check me-1"></i>{{ __('Approve') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Rejection Reason Modal -->
<div class="modal fade" id="rejectionReasonModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Rejection Reason') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <textarea class="form-control" id="rejection_reason" rows="4" placeholder="{{ __('Enter reason for rejection') }}" required></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-danger" id="confirmRejectBtn">{{ __('Confirm Reject') }}</button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    const table = $('#staffVerificationTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("admin.staff.verification.list") }}',
            type: 'GET'
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'name', name: 'name' },
            { data: 'email', name: 'email' },
            { data: 'category_name', name: 'category_name' },
            { data: 'documents_count', name: 'documents_count' },
            { data: 'status_badge', name: 'staff_verification_status' },
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        drawCallback: function() {
            $('#loader-table').addClass('d-none');
            $('#staffVerificationTable').removeClass('d-none');
        }
    });

    // View staff details
    $(document).on('click', '.view-staff-btn', function() {
        const staffId = $(this).data('id');
        
        $.ajax({
            url: `/admin/staff-verification/${staffId}/details`,
            method: 'GET',
            success: function(response) {
                $('#current_staff_id').val(response.staff.id);
                $('#staff_name').text(response.staff.name);
                $('#staff_email').text(response.staff.email);
                $('#staff_phone').text(response.staff.phone);
                $('#staff_category').text(response.staff.category);
                $('#staff_address').text(response.staff.address);
                $('#staff_city').text(response.staff.city);
                $('#staff_state').text(response.staff.state);
                $('#staff_country').text(response.staff.country);
                $('#staff_postal').text(response.staff.postal_code);
                $('#staff_bio').text(response.staff.bio);
                $('#staff_status').html('<span class="badge badge-' + 
                    (response.staff.verification_status === 'approved' ? 'success' : 
                     response.staff.verification_status === 'rejected' ? 'danger' : 'warning') + '">' + 
                    (response.staff.verification_status || 'pending') + '</span>');
                
                // Display documents
                let docsHtml = '';
                if (response.documents && response.documents.length > 0) {
                    response.documents.forEach(doc => {
                        const docLabel = doc.type === 'id_document' ? 'ID Document' : 'Selfie Photo';
                        const fileExt = doc.name.split('.').pop().toLowerCase();
                        const isImage = ['jpg', 'jpeg', 'png', 'gif', 'webp'].includes(fileExt);
                        
                        docsHtml += `
                            <div class="col-md-6 mb-3">
                                <div class="card">
                                    <div class="card-body text-center">
                                        ${isImage ? 
                                            '<img src="' + doc.url + '" alt="' + docLabel + '" style="max-width: 100%; max-height: 300px; margin-bottom: 10px;">' : 
                                            '<i class="ti ti-file fs-1 mb-2"></i>'}
                                        <p class="small mb-2"><strong>${docLabel}</strong></p>
                                        <p class="small mb-2">${doc.name}</p>
                                        <a href="${doc.url}" target="_blank" class="btn btn-sm btn-primary">
                                            <i class="ti ti-eye me-1"></i>View Full Size
                                        </a>
                                    </div>
                                </div>
                            </div>
                        `;
                    });
                } else {
                    docsHtml = '<div class="col-12"><p class="text-muted">No documents uploaded</p></div>';
                }
                $('#staff_documents_list').html(docsHtml);
                
                $('#viewStaffModal').modal('show');
            }
        });
    });

    // Approve staff
    $('#approveStaffBtn').on('click', function() {
        const staffId = $('#current_staff_id').val();
        
        if (confirm('Are you sure you want to approve this staff member?')) {
            $.ajax({
                url: '{{ route("admin.staff.verification.verify") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    staff_id: staffId,
                    action: 'approve'
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        $('#viewStaffModal').modal('hide');
                        table.ajax.reload();
                    }
                }
            });
        }
    });

    // Show rejection modal
    $('#rejectStaffBtn').on('click', function() {
        $('#rejectionReasonModal').modal('show');
    });

    // Confirm rejection
    $('#confirmRejectBtn').on('click', function() {
        const staffId = $('#current_staff_id').val();
        const reason = $('#rejection_reason').val();
        
        if (!reason.trim()) {
            alert('Please enter a rejection reason');
            return;
        }
        
        $.ajax({
            url: '{{ route("admin.staff.verification.verify") }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                staff_id: staffId,
                action: 'reject',
                rejection_reason: reason
            },
            success: function(response) {
                if (response.success) {
                    alert(response.message);
                    $('#rejectionReasonModal').modal('hide');
                    $('#viewStaffModal').modal('hide');
                    $('#rejection_reason').val('');
                    table.ajax.reload();
                }
            }
        });
    });
});
</script>
@endpush

