@extends('admin.admin')

@section('title', 'Paradigm Brain Profile Assessment')

@section('content')
<div class="page-wrapper">
    <div class="content">
        <!-- Clean Header -->
        <div class="page-header mb-4">
            <h3 class="page-title">{{ __('Paradigm Brain Profile Assessment') }}</h3>
            <p class="page-subtitle">{{ __('Complete 288-question comprehensive assessment system (7 parts)') }}</p>
        </div>

        <!-- Simple Overview Card -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">{{ __('Assessment Overview') }}</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <h6 class="text-primary">{{ __('Part 1: Brain Frames') }}</h6>
                        <p class="mb-1"><small>30 questions - Ranking system (1-4)</small></p>
                        <small class="text-muted">Maps to: LU, LL, RU, RL quadrants</small>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-info">{{ __('Part 2: Brain Fields') }}</h6>
                        <p class="mb-1"><small>64 questions - A/B choice</small></p>
                        <small class="text-muted">Maps to: 8 behavioral fields</small>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-success">{{ __('Part 3: Personality') }}</h6>
                        <p class="mb-1"><small>10 questions - A/B choice</small></p>
                        <small class="text-muted">E/I trait (Extraversion/Introversion)</small>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-warning">{{ __('Part 4: Conflict Styles') }}</h6>
                        <p class="mb-1"><small>30 questions - A/B choice</small></p>
                        <small class="text-muted">5 conflict resolution styles</small>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-danger">{{ __('Part 5: Connection Styles') }}</h6>
                        <p class="mb-1"><small>30 questions - A/B choice</small></p>
                        <small class="text-muted">5 connection preferences (A-E)</small>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-secondary">{{ __('Part 6: Intelligence/Quotient') }}</h6>
                        <p class="mb-1"><small>44 questions - A/B/C choice</small></p>
                        <small class="text-muted">SI, EQ, RQ measurements</small>
                    </div>
                    <div class="col-md-12">
                        <h6 class="text-dark">{{ __('Part 7: Paradigm Balance™') }}</h6>
                        <p class="mb-1"><small>80 questions - 1-4 rating scale</small></p>
                        <small class="text-muted">8 wellness dimensions (Emotional, Spiritual, Physical, Social, Financial, Occupational, Intellectual, Environmental)</small>
                    </div>
                </div>
                
                <hr>
                
                <div class="row text-center">
                    <div class="col-md-4">
                        <h4 class="text-primary">288</h4>
                        <p class="text-muted mb-0">{{ __('Total Questions') }}</p>
                    </div>
                    <div class="col-md-4">
                        <h4 class="text-primary">840</h4>
                        <p class="text-muted mb-0">{{ __('Answer Options') }}</p>
                    </div>
                    <div class="col-md-4">
                        <h4 class="text-primary">38</h4>
                        <p class="text-muted mb-0">{{ __('Result Elements') }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Simple Actions -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title">{{ __('Actions') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <a href="{{ route('admin.paradigm.templates.edit', 1) }}" class="btn btn-primary btn-block">
                            <i class="ti ti-edit me-2"></i>{{ __('Edit Template') }}
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="{{ route('admin.paradigm.paradigm-pdf-builder.template', 1) }}" class="btn btn-success btn-block">
                            <i class="ti ti-layout-2 me-2"></i>{{ __('PDF Builder') }}
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="{{ route('admin.paradigm.pricing.index') }}" class="btn btn-warning btn-block">
                            <i class="ti ti-currency-dollar me-2"></i>{{ __('Pricing Settings') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Simple Status -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title">{{ __('System Status') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-check text-success me-2"></i>
                            <div>
                                <h6 class="mb-0">{{ __('Questions Loaded') }}</h6>
                                <small class="text-muted">All 288 questions ready (7 parts)</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-check text-success me-2"></i>
                            <div>
                                <h6 class="mb-0">{{ __('PDF Elements') }}</h6>
                                <small class="text-muted">14 result elements configured</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-check text-success me-2"></i>
                            <div>
                                <h6 class="mb-0">{{ __('Payment System') }}</h6>
                                <small class="text-muted">Pricing and payment ready</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-clock text-warning me-2"></i>
                            <div>
                                <h6 class="mb-0">{{ __('Frontend Form') }}</h6>
                                <small class="text-muted">In development</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection