@extends('admin.admin')

@section('content')
<div class="page-wrapper">
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="page-title">{{ __('Sales Page Settings') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Paradigm Sales Settings') }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- /Page Header -->

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Configure Sales Package') }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.paradigm.sales.store') }}" method="POST">
                            @csrf
                            
                            <div class="form-group mb-3">
                                <label>{{ __('Credits Amount') }} <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control" name="credits" value="{{ $package ? $package->credits : '' }}" required>
                                <small class="text-muted">{{ __('Price will be calculated automatically (Credits * R17.50).') }}</small>
                            </div>

                            <div class="form-group mb-3">
                                <label>{{ __('Status') }}</label>
                                <div class="status-toggle">
                                    <input type="checkbox" id="status_1" class="check" name="is_active" value="1" {{ $package && $package->is_active ? 'checked' : '' }}>
                                    <label for="status_1" class="checktoggle">checkbox</label>
                                </div>
                            </div>

                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Package Details') }}</h4>
                    </div>
                    <div class="card-body">
                        @if($package)
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    {{ __('Credits') }}
                                    <span class="badge bg-primary rounded-pill">{{ $package->credits }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    {{ __('Price (ZAR)') }}
                                    <span class="fw-bold">R{{ number_format($package->final_price_zar, 2) }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    {{ __('Status') }}
                                    <span class="badge bg-{{ $package->is_active ? 'success' : 'danger' }}">
                                        {{ $package->is_active ? __('Active') : __('Inactive') }}
                                    </span>
                                </li>
                            </ul>
                        @else
                            <p class="text-muted">{{ __('Package not configured yet.') }}</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Transactions Table -->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Sales & Transactions') }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-center mb-0">
                                <thead>
                                    <tr>
                                        <th>{{ __('Date') }}</th>
                                        <th>{{ __('Client') }}</th>
                                        <th>{{ __('Email') }}</th>
                                        <th>{{ __('Amount') }}</th>
                                        <th>{{ __('Credits') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Transaction ID') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($transactions as $transaction)
                                        @php
                                            $user = $transaction->user;
                                            $userName = 'N/A';
                                            if ($user) {
                                                if ($user->userDetail) {
                                                    $firstName = $user->userDetail->first_name ?? '';
                                                    $lastName = $user->userDetail->last_name ?? '';
                                                    $userName = trim($firstName . ' ' . $lastName) ?: $user->name;
                                                } else {
                                                    $userName = $user->name;
                                                }
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                            <td>{{ $userName }}</td>
                                            <td>{{ $user ? $user->email : 'N/A' }}</td>
                                            <td>R{{ number_format($transaction->amount, 2) }}</td>
                                            <td>{{ number_format($transaction->credits ?? $transaction->amount, 2) }}</td>
                                            <td>
                                                <span class="badge bg-{{ $transaction->status == 'Completed' ? 'success' : 'warning' }}">
                                                    {{ ucfirst($transaction->status) }}
                                                </span>
                                            </td>
                                            <td>{{ $transaction->transaction_id }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">{{ __('No transactions found') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $transactions->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

