@extends('admin.admin')

@section('title', 'Paradigm Profile Results')

@section('content')
<div class="page-wrapper">
    <div class="content">
        <!-- Clean Header -->
        <div class="page-header mb-4">
            <h3 class="page-title">{{ __('Paradigm Profile Results') }}</h3>
            <p class="page-subtitle">{{ __('View and manage assessment results and PDF reports') }}</p>
        </div>

        <!-- Assessment Results Table -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">{{ __('Completed Assessments') }}</h5>
                <div>
                    <button type="button" class="btn btn-danger me-2" id="deleteAllBtn" @if(count($results) == 0) disabled @endif>
                        <i class="ti ti-trash me-2"></i>{{ __('Delete All') }}
                    </button>
                </div>
            </div>
            <div class="card-body">
                @if(count($results) > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>{{ __('Client Name') }}</th>
                                <th>{{ __('Client Email') }}</th>
                                <th>{{ __('Provider') }}</th>
                                <th>{{ __('Assessment') }}</th>
                                <th>{{ __('Paradigm Type') }}</th>
                                <th>{{ __('Completed') }}</th>
                                <th>{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($results as $result)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $result->name ?? 'N/A' }}</div>
                                </td>
                                <td>
                                    <span class="text-muted">{{ $result->email }}</span>
                                </td>
                                <td>
                                    <span class="text-muted">{{ $result->provider->name ?? 'N/A' }}</span>
                                </td>
                                <td>
                                    <span class="text-muted">{{ $result->template->name ?? 'N/A' }}</span>
                                </td>
                                <td>
                                    <span class="badge bg-primary">{{ $result->paradigm_type }}</span>
                                </td>
                                <td>
                                    <span class="text-muted">{{ $result->created_at->format('Y-m-d H:i') }}</span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('paradigm.results', $result->id) }}" 
                                           class="btn btn-sm btn-success"
                                           title="{{ __('Download Report') }}">
                                            <i class="ti ti-download"></i> {{ __('Download') }}
                                        </a>
                                        <button type="button" 
                                                class="btn btn-sm btn-danger delete-single-btn" 
                                                data-result-id="{{ $result->id }}"
                                                data-client-name="{{ $result->name ?? 'N/A' }}"
                                                title="{{ __('Delete Result') }}">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="text-center py-5">
                    <div class="empty-state">
                        <i class="ti ti-file-pdf text-muted" style="font-size: 3rem;"></i>
                        <h4 class="mt-3 text-muted">{{ __('No Completed Assessments Found') }}</h4>
                        <p class="text-muted mb-0">{{ __('Completed assessment results will appear here.') }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteModalLabel">
                    <i class="ti ti-alert-triangle me-2"></i>{{ __('Confirm Deletion') }}
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-danger">
                    <i class="ti ti-alert-circle me-2"></i>
                    <strong>{{ __('Warning: This action cannot be undone!') }}</strong>
                </div>
                <p id="deleteMessage">{{ __('Are you sure you want to delete this assessment result?') }}</p>
                <div class="mt-3">
                    <strong>{{ __('This will permanently delete:') }}</strong>
                    <ul class="mt-2">
                        <li>{{ __('Assessment result data') }}</li>
                        <li>{{ __('All calculated scores') }}</li>
                        <li>{{ __('PDF report files') }}</li>
                    </ul>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="ti ti-x me-2"></i>{{ __('Cancel') }}
                </button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <i class="ti ti-trash me-2"></i>{{ __('Delete') }}
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    let deleteType = null;
    let deleteId = null;
    
    // Single delete button handler
    $('.delete-single-btn').on('click', function() {
        const resultId = $(this).data('result-id');
        const clientName = $(this).data('client-name');
        
        deleteType = 'single';
        deleteId = resultId;
        
        $('#deleteMessage').html(`<strong>{{ __('Delete assessment result for') }} "${clientName}"?</strong><br>{{ __('This action cannot be undone.') }}`);
        $('#deleteModal').modal('show');
    });
    
    // Delete all button handler
    $('#deleteAllBtn').on('click', function() {
        deleteType = 'all';
        deleteId = null;
        
        $('#deleteMessage').html(`<strong>{{ __('Delete ALL assessment results?') }}</strong><br>{{ __('This will permanently delete all assessment data. This action cannot be undone.') }}`);
        $('#deleteModal').modal('show');
    });
    
    // Confirm delete handler
    $('#confirmDeleteBtn').on('click', function() {
        const button = $(this);
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>{{ __("Deleting...") }}');
        
        let url = '';
        let data = {
            _token: $('meta[name="csrf-token"]').attr('content')
        };
        
        if (deleteType === 'single') {
            url = '{{ route("admin.paradigm.results.delete") }}';
            data.result_id = deleteId;
        } else if (deleteType === 'all') {
            url = '{{ route("admin.paradigm.results.delete-all") }}';
        }
        
        $.ajax({
            url: url,
            method: 'POST',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message || '{{ __("Deletion successful") }}');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error(response.message || '{{ __("Deletion failed") }}');
                }
            },
            error: function(xhr) {
                console.error('Delete error:', xhr);
                const errorMsg = xhr.responseJSON?.message || '{{ __("Deletion failed") }}';
                toastr.error(errorMsg);
            },
            complete: function() {
                button.prop('disabled', false).html('<i class="ti ti-trash me-2"></i>{{ __("Delete") }}');
                $('#deleteModal').modal('hide');
            }
        });
    });
});
</script>
@endpush