@extends('admin.admin')

@section('title', 'Paradigm Profile PDF Builder')

@section('content')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 12px; margin-bottom: 2rem; box-shadow: 0 8px 32px rgba(102, 126, 234, 0.3);">
            <div class="d-flex justify-content-between align-items-center">
                <div class="page-title">
                    <h3 class="mb-0 text-white" style="font-size: 2rem; font-weight: 700;">{{ __('Paradigm Profile PDF Builder') }}</h3>
                    <p class="text-white mb-0" style="opacity: 0.9; font-size: 1.1rem;">{{ __('Design and customize PDF report layouts for your assessments') }}</p>
                </div>
            </div>
        </div>

        <div class="card" style="border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); border: none;">
            <div class="card-body" style="padding: 2rem;">
                @if($templates->count() > 0)
                <div class="row">
                    @foreach($templates as $template)
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="template-card">
                                <div class="template-card-header">
                                    <div class="template-icon">
                                        <i class="ti ti-brain"></i>
                                    </div>
                                    <div class="template-info">
                                        <h5 class="template-name">{{ $template->name }}</h5>
                                        <p class="template-description">{{ Str::limit($template->description, 60) }}</p>
                                    </div>
                                </div>
                                <div class="template-card-body">
                                    <div class="template-stats">
                                        <div class="stat-item">
                                            <span class="stat-label">Questions:</span>
                                            <span class="stat-value">{{ $template->questions->count() }}</span>
                                        </div>
                                        <div class="stat-item">
                                            <span class="stat-label">PDF Pages:</span>
                                            <span class="stat-value">{{ $template->pdfPages->count() }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="template-card-footer">
                                    <a href="{{ route('admin.paradigm.paradigm-pdf-builder.template', $template->id) }}" 
                                       class="btn btn-primary btn-sm w-100">
                                        <i class="ti ti-layout-2 me-2"></i>{{ __('Open PDF Builder') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                @else
                <div class="text-center py-5">
                    <div class="empty-state">
                        <i class="ti ti-brain text-muted" style="font-size: 4rem;"></i>
                        <h4 class="mt-3 text-muted">{{ __('No Templates Found') }}</h4>
                        <p class="text-muted mb-4">{{ __('Create a Paradigm Profile template first to use the PDF builder.') }}</p>
                        <a href="{{ route('admin.paradigm.templates.index') }}" class="btn btn-primary btn-lg">
                            <i class="ti ti-plus me-2"></i>{{ __('Manage Templates') }}
                        </a>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<style>
.template-card {
    background: white;
    border: 1px solid #e9ecef;
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.template-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

.template-card-header {
    padding: 1.5rem;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    display: flex;
    align-items: center;
    gap: 1rem;
}

.template-icon {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.template-name {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.25rem;
}

.template-description {
    color: #718096;
    font-size: 0.875rem;
    margin: 0;
}

.template-card-body {
    padding: 1rem 1.5rem;
}

.template-stats {
    display: flex;
    justify-content: space-between;
}

.stat-item {
    text-align: center;
}

.stat-label {
    display: block;
    font-size: 0.75rem;
    color: #718096;
    font-weight: 500;
}

.stat-value {
    display: block;
    font-size: 1.25rem;
    font-weight: 600;
    color: #2d3748;
}

.template-card-footer {
    padding: 1rem 1.5rem;
    background: #f8f9fa;
    border-top: 1px solid #e9ecef;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 3rem 2rem;
}

.empty-state i {
    opacity: 0.3;
    color: #667eea;
}
</style>
@endsection
