@extends('admin.admin')

@section('content')
<div class="page-wrapper notes-page-wrapper">
    <div class="content pb-4">
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Custom Links Management') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#">{{ __('Edit Media') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ __('Custom Links') }}
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Custom Links Management Card -->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">{{ __('Custom Links') }}</h5>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#customLinkModal">
                                <i class="ti ti-plus me-1"></i>{{ __('Add Custom Link') }}
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="customLinksTable">
                                <thead>
                                    <tr>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('URL') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Created') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be loaded via DataTable -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Custom Link Modal -->
<div class="modal fade" id="customLinkModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">{{ __('Add Custom Link') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="customLinkForm">
                <div class="modal-body">
                    <input type="hidden" id="link_id" name="id">
                    <div class="mb-3">
                        <label for="name" class="form-label">{{ __('Link Name') }} <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="url" class="form-label">{{ __('URL') }} <span class="text-danger">*</span></label>
                        <input type="url" class="form-control" id="url" name="url" required>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="active" name="active" checked>
                            <label class="form-check-label" for="active">
                                {{ __('Active') }}
                            </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    let customLinksTable;
    let isEditMode = false;

    // Initialize DataTable
    customLinksTable = $('#customLinksTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("admin.edit-media.custom-links.list") }}',
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        },
        columns: [
            { data: 'name', name: 'name' },
            { data: 'url', name: 'url' },
            {
                data: 'active',
                name: 'active',
                render: function(data, type, row) {
                    let checked = data ? 'checked' : '';
                    return `<div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input status-toggle" id="status_${row.id}" data-id="${row.id}" ${checked}>
                        <label class="custom-control-label" for="status_${row.id}"></label>
                    </div>`;
                }
            },
            { data: 'created_at', name: 'created_at' },
            {
                data: 'id',
                name: 'actions',
                render: function(data, type, row) {
                    return `
                        <div class="d-flex">
                            <button class="btn btn-sm btn-outline-primary me-1 edit-link" data-id="${data}">
                                <i class="ti ti-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger delete-link" data-id="${data}">
                                <i class="ti ti-trash"></i>
                            </button>
                        </div>
                    `;
                }
            }
        ]
    });

    // Add New Link
    $('#customLinkModal').on('show.bs.modal', function() {
        isEditMode = false;
        $('#modalTitle').text('{{ __("Add Custom Link") }}');
        $('#customLinkForm')[0].reset();
        $('#link_id').val('');
        $('#active').prop('checked', true);
    });

    // Edit Link
    $(document).on('click', '.edit-link', function() {
        let linkId = $(this).data('id');
        isEditMode = true;
        $('#modalTitle').text('{{ __("Edit Custom Link") }}');
        
        // Fetch link data and populate form
        $.get(`/admin/edit-media/custom-links/${linkId}`, function(response) {
            if (response.success) {
                $('#link_id').val(response.data.id);
                $('#name').val(response.data.name);
                $('#url').val(response.data.url);
                $('#active').prop('checked', response.data.active);
                $('#customLinkModal').modal('show');
            }
        });
    });

    // Save Link
    $('#customLinkForm').on('submit', function(e) {
        e.preventDefault();
        
        let formData = {
            name: $('#name').val(),
            url: $('#url').val(),
            active: $('#active').is(':checked'),
            _token: $('meta[name="csrf-token"]').attr('content')
        };

        let url = isEditMode ? `/admin/edit-media/custom-links/${$('#link_id').val()}` : '{{ route("admin.edit-media.custom-links.store") }}';
        let method = isEditMode ? 'PUT' : 'POST';

        $.ajax({
            url: url,
            type: method,
            data: formData,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    $('#customLinkModal').modal('hide');
                    customLinksTable.ajax.reload();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                let errors = xhr.responseJSON?.errors;
                if (errors) {
                    Object.keys(errors).forEach(function(key) {
                        toastr.error(errors[key][0]);
                    });
                } else {
                    toastr.error('An error occurred');
                }
            }
        });
    });

    // Delete Link
    $(document).on('click', '.delete-link', function() {
        let linkId = $(this).data('id');
        
        if (confirm('{{ __("Are you sure you want to delete this custom link?") }}')) {
            $.ajax({
                url: `/admin/edit-media/custom-links/${linkId}`,
                type: 'DELETE',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                        customLinksTable.ajax.reload();
                    } else {
                        toastr.error(response.message);
                    }
                }
            });
        }
    });

    // Toggle Status
    $(document).on('change', '.status-toggle', function() {
        let linkId = $(this).data('id');
        
        $.ajax({
            url: `/admin/edit-media/custom-links/${linkId}/toggle`,
            type: 'POST',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                } else {
                    toastr.error(response.message);
                }
            }
        });
    });
});
</script>
@endpush
