<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class UpdateUserToPractitionerCategorySeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        try {
            // Find the Practitioner category by slug
            $practitionerCategory = DB::table('categories')
                ->where('slug', 'practitioner')
                ->first();

            if (!$practitionerCategory) {
                Log::error('Practitioner category not found');
                $this->command->error('❌ Error: Practitioner category (slug: practitioner) not found in categories table');
                return;
            }

            // Find the user by email
            $user = DB::table('users')
                ->where('email', 'm.thethrivingcoach@gmail.com')
                ->first();

            if (!$user) {
                Log::error('User m.thethrivingcoach@gmail.com not found');
                $this->command->error('❌ Error: User m.thethrivingcoach@gmail.com not found');
                return;
            }

            // Update user's category
            DB::table('users')
                ->where('email', 'm.thethrivingcoach@gmail.com')
                ->update([
                    'category_id' => $practitionerCategory->id,
                    'updated_at' => now()
                ]);

            Log::info('User category updated to Practitioner', [
                'user_email' => 'm.thethrivingcoach@gmail.com',
                'category_id' => $practitionerCategory->id,
                'category_name' => $practitionerCategory->name
            ]);

            $this->command->info('✅ Successfully updated m.thethrivingcoach@gmail.com to Practitioner category');

        } catch (\Exception $e) {
            Log::error('Failed to update user category', [
                'error' => $e->getMessage()
            ]);
            $this->command->error('❌ Error: ' . $e->getMessage());
        }
    }
}

