<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UpdateParadigmInvitationWhatsAppTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // New Content SID from approved WhatsApp template
        $newContentSid = 'HX5fa7c69bc75739ba998abf9cdb5be6f0';
        
        // Update the Paradigm Invitation WhatsApp template SID
        // This is stored in communication_settings table
        // settings_type = 2 (SMS settings)
        // type = 'twilio'
        // key = 'twilio_whatsapp_template_paradigm_invitation_sid'
        
        $updated = DB::table('communication_settings')
            ->where('settings_type', 2)
            ->where('type', 'twilio')
            ->where('key', 'twilio_whatsapp_template_paradigm_invitation_sid')
            ->update([
                'value' => $newContentSid,
                'updated_at' => Carbon::now(),
            ]);

        if ($updated) {
            echo "✅ Paradigm Invitation WhatsApp template SID updated successfully!\n";
            echo "   New Content SID: {$newContentSid}\n";
        } else {
            echo "❌ Template SID not found. Creating new record...\n";
            
            // If setting doesn't exist, create it
            DB::table('communication_settings')->insert([
                'settings_type' => 2,
                'type' => 'twilio',
                'key' => 'twilio_whatsapp_template_paradigm_invitation_sid',
                'value' => $newContentSid,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            
            echo "✅ Paradigm Invitation WhatsApp template SID created!\n";
            echo "   Content SID: {$newContentSid}\n";
        }
    }
}

