<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UpdateParadigmInvitationClientWhatsAppTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Content SID from approved WhatsApp template: userpurchaseassessment
        $contentSid = 'HXe111418b28108b2aa4e3db37565d694b';
        
        // Update or create the Paradigm Invitation CLIENT WhatsApp template SID
        // This is stored in communication_settings table
        // settings_type = 2 (SMS settings)
        // type = 'twilio'
        // key = 'twilio_whatsapp_template_paradigm_invitation_client_sid'
        
        $updated = DB::table('communication_settings')
            ->where('settings_type', 2)
            ->where('type', 'twilio')
            ->where('key', 'twilio_whatsapp_template_paradigm_invitation_client_sid')
            ->update([
                'value' => $contentSid,
                'updated_at' => Carbon::now(),
            ]);

        if ($updated) {
            echo "✅ Paradigm Invitation CLIENT WhatsApp template SID updated successfully!\n";
            echo "   Template: userpurchaseassessment\n";
            echo "   Content SID: {$contentSid}\n";
            echo "   Category: Utility (Approved)\n";
        } else {
            echo "❌ Template SID not found. Creating new record...\n";
            
            // If setting doesn't exist, create it
            DB::table('communication_settings')->insert([
                'settings_type' => 2,
                'type' => 'twilio',
                'key' => 'twilio_whatsapp_template_paradigm_invitation_client_sid',
                'value' => $contentSid,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            
            echo "✅ Paradigm Invitation CLIENT WhatsApp template SID created!\n";
            echo "   Template: userpurchaseassessment\n";
            echo "   Content SID: {$contentSid}\n";
            echo "   Category: Utility (Approved)\n";
        }
    }
}

