<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UpdateAntonPasswordSeeder extends Seeder
{
    public function run()
    {
        $staffEmail = 'anton@urbanbalancecounselling.co.za';
        $newPassword = 'happy123@';

        $this->command->info("========================================");
        $this->command->info("UPDATING STAFF PASSWORD");
        $this->command->info("Staff Email: {$staffEmail}");
        $this->command->info("========================================\n");

        $staff = User::where('email', $staffEmail)->first();

        if (!$staff) {
            $this->command->error("❌ Staff with email {$staffEmail} not found!");
            return;
        }

        $this->command->info("✅ Found Staff: {$staff->name} (ID: {$staff->id})");

        $staff->password = Hash::make($newPassword);
        $staff->setRememberToken(null);
        $staff->save();

        $this->command->info("🔐 Password updated successfully.");
        $this->command->info("Temporary Password: {$newPassword}");
        $this->command->info("========================================\n");
    }
}

