<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;

class RemoveAnoFernandesUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $email = 'anofernandes2018@gmail.com';
        
        $user = User::where('email', $email)->first();
        
        if ($user) {
            echo "Found user with email: {$email}\n";
            echo "User ID: {$user->id}\n";
            echo "User Name: {$user->name}\n";
            echo "Deleting user...\n";
            
            $user->delete();
            
            echo "User has been deleted successfully.\n";
        } else {
            echo "No user found with email: {$email}\n";
            echo "Checking all users with similar emails...\n";
            
            $similarUsers = User::where('email', 'like', '%anofernandes%')->get();
            
            if ($similarUsers->count() > 0) {
                echo "Found {$similarUsers->count()} user(s) with similar email:\n";
                foreach ($similarUsers as $similarUser) {
                    echo "  - ID: {$similarUser->id}, Email: {$similarUser->email}, Name: {$similarUser->name}\n";
                }
            } else {
                echo "No users found with similar email pattern.\n";
            }
        }
    }
}
