<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class PasswordResetTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if template already exists
        $existingTemplate = DB::table('templates')
            ->where('notification_type', 3) // Forget Password
            ->where('type', 1) // Email
            ->first();

        if ($existingTemplate) {
            echo "Password Reset Email template already exists (ID: {$existingTemplate->id})\n";
            return;
        }

        // Insert new Password Reset Email template
        DB::table('templates')->insert([
            'notification_type' => 3, // Forget Password
            'type' => 1, // Email
            'title' => 'Password Reset Email',
            'subject' => 'Reset Your Password - {{company_name}}',
            'content' => $this->getPasswordResetTemplate(),
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);

        echo "Password Reset Email template created successfully!\n";
    }

    /**
     * Get the password reset email template
     */
    private function getPasswordResetTemplate(): string
    {
        return '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Your Password</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background-color: #f4f4f4; }
        .container { max-width: 600px; margin: 20px auto; background: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .header { background: linear-gradient(135deg, #044f54 0%, #066a70 100%); color: #ffffff; padding: 30px 20px; text-align: center; }
        .header h1 { margin: 0; font-size: 24px; font-weight: 600; }
        .content { padding: 30px 20px; }
        .content h2 { color: #044f54; margin-top: 0; font-size: 20px; }
        .content p { margin: 15px 0; color: #555; }
        .button-container { text-align: center; margin: 30px 0; }
        .button { display: inline-block; padding: 14px 40px; background: #044f54; color: #ffffff !important; text-decoration: none; border-radius: 5px; font-weight: 600; font-size: 16px; transition: background 0.3s ease; }
        .button:hover { background: #066a70; }
        .info-box { background: #f8f9fa; border-left: 4px solid #044f54; padding: 15px; margin: 20px 0; border-radius: 4px; }
        .info-box p { margin: 5px 0; font-size: 14px; }
        .warning { background: #fff3cd; border-left-color: #ffc107; color: #856404; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; font-size: 13px; color: #6c757d; border-top: 1px solid #e9ecef; }
        .footer a { color: #044f54; text-decoration: none; }
        .divider { height: 1px; background: #e9ecef; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Password Reset Request</h1>
        </div>
        <div class="content">
            <h2>Hello {{user_name}},</h2>
            <p>We received a request to reset your password for your account at <strong>{{company_name}}</strong>.</p>
            
            <p>If you made this request, click the button below to reset your password:</p>
            
            <div class="button-container">
                <a href="{{link}}" class="button">Reset My Password</a>
            </div>
            
            <div class="info-box">
                <p><strong>Or copy and paste this link into your browser:</strong></p>
                <p style="word-break: break-all; color: #044f54;">{{link}}</p>
            </div>
            
            <div class="info-box warning">
                <p><strong>Important Security Notice:</strong></p>
                <p>This password reset link will expire in 60 minutes</p>
                <p>If you did not request a password reset, please ignore this email</p>
                <p>Your password will remain unchanged unless you click the link above</p>
            </div>
            
            <div class="divider"></div>
            
            <p style="font-size: 14px; color: #6c757d;">
                If you are having trouble clicking the button, you can also reset your password by visiting <a href="{{website_link}}" style="color: #044f54;">{{website_link}}</a> and clicking Forgot Password.
            </p>
        </div>
        <div class="footer">
            <p><strong>{{company_name}}</strong></p>
            <p>{{email}} | {{phone}}</p>
            <p><a href="{{website_link}}">Visit our website</a></p>
            <p style="margin-top: 15px; color: #999;">This is an automated email. Please do not reply to this message.</p>
        </div>
    </div>
</body>
</html>';
    }
}

