<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmQuestion;

class ParadigmPart7Seeder extends Seeder
{
    /**
     * Seed Part 7: Paradigm Balance (80 Questions across 8 Wellness Dimensions)
     * 
     * SAFE: Only INSERTS new records, does NOT modify existing parts
     * 
     * 8 Dimensions (10 questions each):
     * - Emotional Balance
     * - Spiritual Balance
     * - Physical Balance
     * - Social Balance
     * - Financial Balance
     * - Occupational Balance
     * - Intellectual Balance
     * - Environmental Balance
     * 
     * Rating Scale: 1-4 (NOT A/B/C)
     * - 1 = Rarely, if ever
     * - 2 = Sometimes
     * - 3 = Most of the time
     * - 4 = Always
     */
    public function run(): void
    {
        $templateId = 1;
        $displayOrder = 1;
        
        // DIMENSION 1: EMOTIONAL BALANCE (10 Questions)
        $emotionalQuestions = [
            'I cope with stress in healthy ways (e.g., mindfulness, movement, support, self-care).',
            'I ask for help when I need it from trusted people or professionals.',
            'I take responsibility for my thoughts, choices, and actions.',
            'I set clear priorities in my day-to-day life.',
            'I feel confident in who I am and believe others accept me.',
            'I adapt well to change and life\'s challenges.',
            'I express emotions (like anger, fear, joy, sadness) in a healthy way.',
            'I balance commitments between work, family, friends, and self.',
            'I manage emotions with thoughtfulness rather than impulse.',
            'I have a mindful relationship with digital and social media.',
        ];

        foreach ($emotionalQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_emotional',
                'question_type' => 'part7_emotional',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 2: SPIRITUAL BALANCE (10 Questions)
        $spiritualQuestions = [
            'I reflect on my values, identity, and life direction.',
            'I make time daily to slow down and recharge.',
            'I have a belief system or guiding life philosophy.',
            'My decisions are aligned with my core values.',
            'I feel a sense of purpose and direction.',
            'I respect diverse perspectives and beliefs.',
            'I use resources to support inner peace and meaning.',
            'I engage in causes or communities that matter to me.',
            'I create and communicate healthy boundaries.',
            'I seek peace in relationships, community, and the world.',
        ];

        foreach ($spiritualQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_spiritual',
                'question_type' => 'part7_spiritual',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 3: PHYSICAL BALANCE (10 Questions)
        $physicalQuestions = [
            'I maintain a healthy weight through lifestyle and nutrition.',
            'I engage in regular physical activity.',
            'I sleep 7–9 hours and feel refreshed.',
            'I seek professional medical support when needed.',
            'I avoid harmful use of substances.',
            'I drink alcohol responsibly or not at all.',
            'I protect my skin and overall health from environmental harm.',
            'I follow a nutritious diet rich in fruits and vegetables.',
            'I stay well-hydrated throughout the day.',
            'I practice safe sex or abstain from sexual behavior.',
        ];

        foreach ($physicalQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_physical',
                'question_type' => 'part7_physical',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 4: SOCIAL BALANCE (10 Questions)
        $socialQuestions = [
            'I\'m content with my social life.',
            'I actively participate in a community or group.',
            'I maintain strong and supportive connections.',
            'I have at least one deep, meaningful relationship.',
            'I embrace and respect diversity in others.',
            'I can say "no" to protect my energy and time.',
            'I have someone I confide in when I\'m struggling.',
            'I enjoy spending time with people who are different from me.',
            'I feel mutual support in my relationships.',
            'I plan quality time with friends or family regularly.',
        ];

        foreach ($socialQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_social',
                'question_type' => 'part7_social',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 5: FINANCIAL BALANCE (10 Questions)
        $financialQuestions = [
            'I budget well enough not to run out of money.',
            'I know the details of my debt and financial obligations.',
            'I pay bills on time.',
            'I seek and apply for financial aid or opportunities.',
            'I regularly save money.',
            'I know my credit score.',
            'I protect my financial information online.',
            'I feel optimistic about my financial future.',
            'I review my accounts each month.',
            'I use credit responsibly.',
        ];

        foreach ($financialQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_financial',
                'question_type' => 'part7_financial',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 6: OCCUPATIONAL BALANCE (10 Questions)
        $occupationalQuestions = [
            'I balance work, leisure, and other responsibilities.',
            'I learn skills that support my future goals.',
            'I understand what\'s needed for my dream job.',
            'I develop habits like initiative and dependability.',
            'I collaborate well with others.',
            'I feel confident in job-searching skills (resume, interviews).',
            'I\'ve explored different career paths.',
            'I know where to find job opportunities.',
            'I manage my time effectively.',
            'I\'ve done internships or volunteer work.',
        ];

        foreach ($occupationalQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_occupational',
                'question_type' => 'part7_occupational',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 7: INTELLECTUAL BALANCE (10 Questions)
        $intellectualQuestions = [
            'I know where to access study or learning resources.',
            'I feel mentally fulfilled by my personal or academic pursuits.',
            'I seek growth by learning new things.',
            'I apply creativity and critical thinking.',
            'I am open-minded and curious.',
            'I explore a variety of topics through reading or media.',
            'I use academic resources when needed.',
            'I engage with mentors, coaches, or teachers for help.',
            'I enjoy learning.',
            'I stay informed about local and global events.',
        ];

        foreach ($intellectualQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_intellectual',
                'question_type' => 'part7_intellectual',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // DIMENSION 8: ENVIRONMENTAL BALANCE (10 Questions)
        $environmentalQuestions = [
            'I spend time in nature regularly.',
            'I recycle and reduce waste.',
            'I actively lessen my environmental impact.',
            'I choose sustainable transportation when possible.',
            'I\'m aware of local/global climate issues.',
            'I have a space I can call my own.',
            'I feel at ease in the spaces I live and work.',
            'I feel content in my environment.',
            'I support local businesses.',
            'I get involved in community-based efforts to help others.',
        ];

        foreach ($environmentalQuestions as $questionText) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $questionText,
                'option_a_label' => '1 - Rarely, if ever',
                'option_b_label' => '2 - Sometimes',
                'option_c_label' => '3 - Most of the time',
                'option_d_label' => '4 - Always',
                'assessment_module' => 'paradigm_balance',
                'axis' => 'balance_environmental',
                'question_type' => 'part7_environmental',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $this->command->info('✅ Part 7: 80 Paradigm Balance questions seeded successfully (8 dimensions × 10 questions)');
    }
}

