<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmQuestion;

class ParadigmPart5Seeder extends Seeder
{
    /**
     * Seed Part 5: Paradigm Connection Styles (30 Questions)
     * 
     * SAFE: Only INSERTS new records, does NOT modify existing parts
     * 
     * 5 Connection Styles (letters represent styles):
     * - A = Verbal Validator
     * - B = Presence Seeker
     * - C = Symbolic Appreciator
     * - D = Practical Supporter
     * - E = Grounded Connector
     * 
     * Each question has 2 options labeled with these letters
     */
    public function run(): void
    {
        $templateId = 1;
        
        $part5Questions = [
            // Question 1: A vs E
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone sends me a sweet message just because.',
                'option_b_label' => 'I get a big hug from someone.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'A',
                'b_side' => 'E',
                'display_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 2: B vs D
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I get to spend quiet time alone with someone.',
                'option_b_label' => 'Someone help me with something I need to do.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'D',
                'display_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 3: C vs B
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone gives me a small gift to show they care.',
                'option_b_label' => 'I get to relax and have fun with someone.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'C',
                'b_side' => 'B',
                'display_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 4: D vs E
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone help me with something I\'m working on.',
                'option_b_label' => 'I hold hands or get a gentle touch from someone I love.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'D',
                'b_side' => 'E',
                'display_order' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 5: E vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone I love puts their arm around me where others can see.',
                'option_b_label' => 'Someone give me a surprise gift.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'E',
                'b_side' => 'C',
                'display_order' => 5,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 6: B vs E
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I\'m with someone I love even if we\'re not doing anything.',
                'option_b_label' => 'I feel good when I can hold hands or high-five someone I love.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'E',
                'display_order' => 6,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 7: C vs A
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I got a gift from someone.',
                'option_b_label' => 'Someone tells me that they care for me.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'C',
                'b_side' => 'A',
                'display_order' => 7,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 8: E vs A
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I get to sit close to someone I love.',
                'option_b_label' => 'Someone give me a nice compliment.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'E',
                'b_side' => 'A',
                'display_order' => 8,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 9: B vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I get to hang out with someone.',
                'option_b_label' => 'I got a surprise gift from someone.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'C',
                'display_order' => 9,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 10: A vs D
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone tells me, "I\'m proud of you."',
                'option_b_label' => 'Someone help me do something.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'A',
                'b_side' => 'D',
                'display_order' => 10,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 11: B vs A
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I do fun things with someone.',
                'option_b_label' => 'Someone says kind and helpful words to me.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'A',
                'display_order' => 11,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 12: D vs E
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone does something nice instead of just saying they will.',
                'option_b_label' => 'I get a warm hug from someone I love.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'D',
                'b_side' => 'E',
                'display_order' => 12,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 13: A vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone tell me something good about myself.',
                'option_b_label' => 'Someone gives me a gift that shows they were thinking about me.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'A',
                'b_side' => 'C',
                'display_order' => 13,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 14: B vs E
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I get to just be near someone.',
                'option_b_label' => 'Someone I love gives me a back rub.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'E',
                'display_order' => 14,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 15: A vs D
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone is happy when I do something great.',
                'option_b_label' => 'Someone helps me even if it\'s not their favorite thing to do.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'A',
                'b_side' => 'D',
                'display_order' => 15,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 16: E vs B
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I get to sit close or cuddle with someone I love.',
                'option_b_label' => 'Someone is interested in what I like.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'E',
                'b_side' => 'B',
                'display_order' => 16,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 17: D vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone help me finish a special project.',
                'option_b_label' => 'Someone gives me a cool gift.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'D',
                'b_side' => 'C',
                'display_order' => 17,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 18: A vs B
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone says I look nice.',
                'option_b_label' => 'Someone really listens and understands how I feel.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'A',
                'b_side' => 'B',
                'display_order' => 18,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 19: E vs D
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I hold hands or share a nice touch with someone I love in public.',
                'option_b_label' => 'Someone helps me by doing something I need.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'E',
                'b_side' => 'D',
                'display_order' => 19,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 20: D vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone does something nice to help me.',
                'option_b_label' => 'I got a gift that someone picked out just for me.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'D',
                'b_side' => 'C',
                'display_order' => 20,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 21: B vs D
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone looks at me when we talk and doesn\'t check their phone.',
                'option_b_label' => 'Someone help me so I don\'t feel too stressed.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'D',
                'display_order' => 21,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 22: C vs A
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I look forward to a holiday because I might get a gift.',
                'option_b_label' => 'Someone says, "I\'m thankful for you."',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'C',
                'b_side' => 'A',
                'display_order' => 22,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 23: C vs D
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone I haven\'t seen in a while gives me a small gift.',
                'option_b_label' => 'Someone helps with something I don\'t have the energy to do.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'C',
                'b_side' => 'D',
                'display_order' => 23,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 24: B vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone lets me talk without cutting me off.',
                'option_b_label' => 'Giving gifts is something special I do.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'B',
                'b_side' => 'C',
                'display_order' => 24,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 25: D vs B
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone helps me when I\'m tired.',
                'option_b_label' => 'I go out and do something fun with someone.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'D',
                'b_side' => 'B',
                'display_order' => 25,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 26: E vs C
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone touches my arm or shoulder to show they care.',
                'option_b_label' => 'Someone picks up a little gift for me during the day.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'E',
                'b_side' => 'C',
                'display_order' => 26,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 27: A vs B
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone says something nice to cheer me up.',
                'option_b_label' => 'I do a fun activity or hobby with someone.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'A',
                'b_side' => 'B',
                'display_order' => 27,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 28: C vs E
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone gives me a surprise to say thanks.',
                'option_b_label' => 'I get to touch or hug someone often.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'C',
                'b_side' => 'E',
                'display_order' => 28,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 29: D vs A
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'Someone helps me even when they\'re really busy.',
                'option_b_label' => 'Someone tells me they\'re thankful for me.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'D',
                'b_side' => 'A',
                'display_order' => 29,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 30: E vs A
            [
                'template_id' => $templateId,
                'question_text' => 'It means a lot to me when...',
                'option_a_label' => 'I get a big hug from someone I haven\'t seen in a long time.',
                'option_b_label' => 'Someone tells me how much I mean to them.',
                'assessment_module' => 'connection_styles',
                'axis' => 'connection',
                'question_type' => 'part5',
                'a_side' => 'E',
                'b_side' => 'A',
                'display_order' => 30,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($part5Questions as $question) {
            ParadigmQuestion::create($question);
        }

        $this->command->info('✅ Part 5: 30 Connection Styles questions seeded successfully');
    }
}

