<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmQuestion;

class ParadigmPart4Seeder extends Seeder
{
    /**
     * Seed Part 4: Paradigm Conflict Styles (30 Questions)
     * 
     * SAFE: Only INSERTS new records, does NOT modify existing parts
     * 
     * 5 Conflict Styles:
     * - Assertive Challenger
     * - Integrative Bridge Builder  
     * - Fair Negotiator
     * - Quiet Protector
     * - Peacekeeper
     */
    public function run(): void
    {
        $templateId = 1;
        
        $part4Questions = [
            // Question 1
            [
                'template_id' => $templateId,
                'question_text' => 'Sometimes I let others handle the problem. / Instead of talking about our disagreements, I focus on what we agree on.',
                'option_a_label' => 'Sometimes I let others handle the problem.',
                'option_b_label' => 'Instead of talking about our disagreements, I focus on what we agree on.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Quiet Protector',
                'b_side' => 'Peacekeeper',
                'display_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 2
            [
                'template_id' => $templateId,
                'question_text' => 'I try to find a solution where we both give a little. / I try to take care of both my needs and the other person\'s needs.',
                'option_a_label' => 'I try to find a solution where we both give a little.',
                'option_b_label' => 'I try to take care of both my needs and the other person\'s needs.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Fair Negotiator',
                'b_side' => 'Integrative Bridge Builder',
                'display_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 3
            [
                'template_id' => $templateId,
                'question_text' => 'I stick to my goals and don\'t give up easily. / I avoid tension even if the problem isn\'t fully discussed with the other person.',
                'option_a_label' => 'I stick to my goals and don\'t give up easily.',
                'option_b_label' => 'I avoid tension even if the problem isn\'t fully discussed with the other person.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Assertive Challenger',
                'b_side' => 'Quiet Protector',
                'display_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 4
            [
                'template_id' => $templateId,
                'question_text' => 'I try to find a solution that works for both of us. / I sometimes let go of what I want to make the other person happy.',
                'option_a_label' => 'I try to find a solution that works for both of us.',
                'option_b_label' => 'I sometimes let go of what I want to make the other person happy.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Fair Negotiator',
                'b_side' => 'Peacekeeper',
                'display_order' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 5
            [
                'template_id' => $templateId,
                'question_text' => 'I often ask the other person to help find a solution together. / I try to avoid unnecessary stress or arguments.',
                'option_a_label' => 'I often ask the other person to help find a solution together.',
                'option_b_label' => 'I try to avoid unnecessary stress or arguments.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Integrative Bridge Builder',
                'b_side' => 'Quiet Protector',
                'display_order' => 5,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 6
            [
                'template_id' => $templateId,
                'question_text' => 'I sometimes step back from conflict to allow others space and maintain harmony in the situation. / I focus on winning or proving my point.',
                'option_a_label' => 'I sometimes step back from conflict to allow others space and maintain harmony in the situation.',
                'option_b_label' => 'I focus on winning or proving my point.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Assertive Challenger',
                'display_order' => 6,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 7
            [
                'template_id' => $templateId,
                'question_text' => 'I like to delay the issue so I can think about it first. / I give up some things to get other things I want.',
                'option_a_label' => 'I like to delay the issue so I can think about it first.',
                'option_b_label' => 'I give up some things to get other things I want.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Quiet Protector',
                'b_side' => 'Fair Negotiator',
                'display_order' => 7,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 8
            [
                'template_id' => $templateId,
                'question_text' => 'I don\'t easily give up on my goals. / I like to talk openly about all the issues right away.',
                'option_a_label' => 'I don\'t easily give up on my goals.',
                'option_b_label' => 'I like to talk openly about all the issues right away.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Assertive Challenger',
                'b_side' => 'Integrative Bridge Builder',
                'display_order' => 8,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 9
            [
                'template_id' => $templateId,
                'question_text' => 'I think some differences aren\'t worth worrying about. / I try to get my way, at least a little.',
                'option_a_label' => 'I think some differences aren\'t worth worrying about.',
                'option_b_label' => 'I try to get my way, at least a little.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Quiet Protector',
                'b_side' => 'Assertive Challenger',
                'display_order' => 9,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 10
            [
                'template_id' => $templateId,
                'question_text' => 'I stay strong when going after what I want. / I look for a solution where both of us are happy.',
                'option_a_label' => 'I stay strong when going after what I want.',
                'option_b_label' => 'I look for a solution where both of us are happy.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Assertive Challenger',
                'b_side' => 'Fair Negotiator',
                'display_order' => 10,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 11
            [
                'template_id' => $templateId,
                'question_text' => 'I want everything out in the open immediately. / I try to protect the relationship by keeping things calm.',
                'option_a_label' => 'I want everything out in the open immediately.',
                'option_b_label' => 'I try to protect the relationship by keeping things calm.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Integrative Bridge Builder',
                'b_side' => 'Peacekeeper',
                'display_order' => 11,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 12
            [
                'template_id' => $templateId,
                'question_text' => 'I avoid saying things that might start a fight. / I\'m okay giving the other person some of what they want if I get something too.',
                'option_a_label' => 'I avoid saying things that might start a fight.',
                'option_b_label' => 'I\'m okay giving the other person some of what they want if I get something too.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Quiet Protector',
                'b_side' => 'Fair Negotiator',
                'display_order' => 12,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 13
            [
                'template_id' => $templateId,
                'question_text' => 'I suggest we meet halfway. / I push to get my ideas accepted.',
                'option_a_label' => 'I suggest we meet halfway.',
                'option_b_label' => 'I push to get my ideas accepted.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Fair Negotiator',
                'b_side' => 'Assertive Challenger',
                'display_order' => 13,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 14
            [
                'template_id' => $templateId,
                'question_text' => 'I share my ideas and ask what the other person thinks. / I will try to explain why my idea makes sense.',
                'option_a_label' => 'I share my ideas and ask what the other person thinks.',
                'option_b_label' => 'I will try to explain why my idea makes sense.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Integrative Bridge Builder',
                'b_side' => 'Assertive Challenger',
                'display_order' => 14,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 15
            [
                'template_id' => $templateId,
                'question_text' => 'I try to make the other person feel better, even if I give in. / I do what I can to avoid tension between us.',
                'option_a_label' => 'I try to make the other person feel better, even if I give in.',
                'option_b_label' => 'I do what I can to avoid tension between us.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Quiet Protector',
                'display_order' => 15,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 16
            [
                'template_id' => $templateId,
                'question_text' => 'I try not to upset the other person. / I try to convince them that my way is best.',
                'option_a_label' => 'I try not to upset the other person.',
                'option_b_label' => 'I try to convince them that my way is best.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Assertive Challenger',
                'display_order' => 16,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 17
            [
                'template_id' => $templateId,
                'question_text' => 'I stay focused on reaching my goals. / I try to avoid unnecessary stress.',
                'option_a_label' => 'I stay focused on reaching my goals.',
                'option_b_label' => 'I try to avoid unnecessary stress.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Assertive Challenger',
                'b_side' => 'Quiet Protector',
                'display_order' => 17,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 18
            [
                'template_id' => $templateId,
                'question_text' => 'If it makes them happy, I let them keep their opinion. / I\'ll give up something if they give up something too.',
                'option_a_label' => 'If it makes them happy, I let them keep their opinion.',
                'option_b_label' => 'I\'ll give up something if they give up something too.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Fair Negotiator',
                'display_order' => 18,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 19
            [
                'template_id' => $templateId,
                'question_text' => 'I want to talk about the issue right away. / I like to wait and think it through before talking.',
                'option_a_label' => 'I want to talk about the issue right away.',
                'option_b_label' => 'I like to wait and think it through before talking.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Integrative Bridge Builder',
                'b_side' => 'Quiet Protector',
                'display_order' => 19,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 20
            [
                'template_id' => $templateId,
                'question_text' => 'I like to work through problems quickly. / I try to find a fair balance where we both gain and lose something.',
                'option_a_label' => 'I like to work through problems quickly.',
                'option_b_label' => 'I try to find a fair balance where we both gain and lose something.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Integrative Bridge Builder',
                'b_side' => 'Fair Negotiator',
                'display_order' => 20,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 21
            [
                'template_id' => $templateId,
                'question_text' => 'I think about how the other person feels. / I believe in talking directly about the issue.',
                'option_a_label' => 'I think about how the other person feels.',
                'option_b_label' => 'I believe in talking directly about the issue.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Integrative Bridge Builder',
                'display_order' => 21,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 22
            [
                'template_id' => $templateId,
                'question_text' => 'I try to find a solution that\'s between what we both want. / I stand up for what I want.',
                'option_a_label' => 'I try to find a solution that\'s between what we both want.',
                'option_b_label' => 'I stand up for what I want.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Fair Negotiator',
                'b_side' => 'Assertive Challenger',
                'display_order' => 22,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 23
            [
                'template_id' => $templateId,
                'question_text' => 'I\'m determined to go after what I want. / Sometimes I let others take care of solving the problem.',
                'option_a_label' => 'I\'m determined to go after what I want.',
                'option_b_label' => 'Sometimes I let others take care of solving the problem.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Integrative Bridge Builder',
                'b_side' => 'Quiet Protector',
                'display_order' => 23,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 24
            [
                'template_id' => $templateId,
                'question_text' => 'If something is really important to them, I try to let them have it. / I encourage them to meet me halfway.',
                'option_a_label' => 'If something is really important to them, I try to let them have it.',
                'option_b_label' => 'I encourage them to meet me halfway.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Fair Negotiator',
                'display_order' => 24,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 25
            [
                'template_id' => $templateId,
                'question_text' => 'I explain why my idea makes sense and how it helps. / I think about what they want when solving the problem.',
                'option_a_label' => 'I explain why my idea makes sense and how it helps.',
                'option_b_label' => 'I think about what they want when solving the problem.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Assertive Challenger',
                'b_side' => 'Peacekeeper',
                'display_order' => 25,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 26
            [
                'template_id' => $templateId,
                'question_text' => 'I suggest something in the middle. / I focus a lot on getting what I want.',
                'option_a_label' => 'I suggest something in the middle.',
                'option_b_label' => 'I focus a lot on getting what I want.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Fair Negotiator',
                'b_side' => 'Integrative Bridge Builder',
                'display_order' => 26,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 27
            [
                'template_id' => $templateId,
                'question_text' => 'I avoid saying things that might start a disagreement. / If it makes them happy, I let them stick to their views.',
                'option_a_label' => 'I avoid saying things that might start a disagreement.',
                'option_b_label' => 'If it makes them happy, I let them stick to their views.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Quiet Protector',
                'b_side' => 'Peacekeeper',
                'display_order' => 27,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 28
            [
                'template_id' => $templateId,
                'question_text' => 'I stay strong when it comes to my goals. / I think some arguments are not worth the trouble.',
                'option_a_label' => 'I stay strong when it comes to my goals.',
                'option_b_label' => 'I think some arguments are not worth the trouble.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Assertive Challenger',
                'b_side' => 'Integrative Bridge Builder',
                'display_order' => 28,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 29
            [
                'template_id' => $templateId,
                'question_text' => 'I suggest we meet halfway. / I think some issues aren\'t worth worrying about.',
                'option_a_label' => 'I suggest we meet halfway.',
                'option_b_label' => 'I think some issues aren\'t worth worrying about.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Fair Negotiator',
                'b_side' => 'Quiet Protector',
                'display_order' => 29,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Question 30
            [
                'template_id' => $templateId,
                'question_text' => 'I try not to hurt their feelings. / I like to share the problem and work on it together.',
                'option_a_label' => 'I try not to hurt their feelings.',
                'option_b_label' => 'I like to share the problem and work on it together.',
                'assessment_module' => 'conflict_styles',
                'axis' => 'conflict',
                'question_type' => 'part4',
                'a_side' => 'Peacekeeper',
                'b_side' => 'Integrative Bridge Builder',
                'display_order' => 30,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($part4Questions as $question) {
            ParadigmQuestion::create($question);
        }

        $this->command->info('✅ Part 4: 30 Conflict Styles questions seeded successfully');
    }
}

