<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmQuestion;
use Illuminate\Support\Facades\DB;

class ParadigmPart3Seeder extends Seeder
{
    /**
     * Seed Part 3: Personality Blueprint (E/I Trait)
     * 
     * SAFE: Only INSERTS new records, does NOT modify existing Part 1 or Part 2
     */
    public function run(): void
    {
        // Template ID 1 = Paradigm Profile
        $templateId = 1;
        
        // Part 3: Personality Type (E/I) - 10 Questions
        $part3Questions = [
            [
                'template_id' => $templateId,
                'question_text' => 'At a party, are you the one who:',
                'option_a_label' => 'Chats with everyone, even new people',
                'option_b_label' => 'Sticks with the people you already know',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'At a party, do you:',
                'option_a_label' => 'Stay late and feed off the energy',
                'option_b_label' => 'Leave early once you\'ve had enough',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'With your friends, do you usually:',
                'option_a_label' => 'Know what\'s going on in their lives',
                'option_b_label' => 'Find out stuff late',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'When making a call, do you:',
                'option_a_label' => 'Just go for it',
                'option_b_label' => 'Run through what you\'re going to say first',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'In a group, do you:',
                'option_a_label' => 'Start conversations',
                'option_b_label' => 'Wait for someone else to approach you',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 5,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'Meeting new people:',
                'option_a_label' => 'Pumps you up',
                'option_b_label' => 'Drains your energy',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 6,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'When it comes to friendships:',
                'option_a_label' => 'Many friends, quick chats',
                'option_b_label' => 'A few deep friendships',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 7,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'When talking to strangers:',
                'option_a_label' => 'You can go on and on',
                'option_b_label' => 'You keep it short',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 8,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'When you enter a room full of strangers, do you:',
                'option_a_label' => 'Introduce yourself and start a conversation',
                'option_b_label' => 'Wait to be approached',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 9,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'Are you usually:',
                'option_a_label' => 'Approachable',
                'option_b_label' => 'A bit reserved',
                'assessment_module' => 'personality_blueprint',
                'axis' => 'E_I',
                'question_type' => 'part3',
                'a_side' => 'E',
                'b_side' => 'I',
                'is_required' => 1,
                'display_order' => 10,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        // Insert all Part 3 questions
        foreach ($part3Questions as $question) {
            ParadigmQuestion::create($question);
        }

        $this->command->info('✅ Part 3: 10 Personality Blueprint (E/I) questions seeded successfully');
    }
}

