<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ParadigmMainQuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first template ID (assuming it exists)
        $templateId = DB::table('paradigm_form_templates')->first()->id ?? 1;
        
        // Paradigm Main Part 1: 30 Questions (4-frame ranking) - EXACT as provided
        $part1Questions = [
            // Question 1
            [
                'template_id' => $templateId,
                'question_text' => 'When I study, I like to...',
                'option_a_label' => 'get an overall view of the material', // RU
                'option_b_label' => 'memorise important facts', // LU
                'option_c_label' => 'stay positive about what I\'m doing', // RL
                'option_d_label' => 'follow a set plan or method', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q1',
                'is_required' => true,
                'display_order' => 1
            ],
            // Question 2
            [
                'template_id' => $templateId,
                'question_text' => 'I\'m drawn to people who...',
                'option_a_label' => 'are well-organised', // LL
                'option_b_label' => 'take a practical approach', // LU
                'option_c_label' => 'are open to different ideas', // RU
                'option_d_label' => 'really listen and pay attention to me', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q2',
                'is_required' => true,
                'display_order' => 2
            ],
            // Question 3
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy situations that...',
                'option_a_label' => 'feel relaxed and friendly', // RL
                'option_b_label' => 'are tidy and well-arranged', // LL
                'option_c_label' => 'are new and exciting', // RU
                'option_d_label' => 'make me think on a deeper level', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RL',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q3',
                'is_required' => true,
                'display_order' => 3
            ],
            // Question 4
            [
                'template_id' => $templateId,
                'question_text' => 'When working on a task, I prefer to...',
                'option_a_label' => 'focus on getting it accurate', // LU
                'option_b_label' => 'discuss it with others', // RL
                'option_c_label' => 'finish quickly and move on', // RU
                'option_d_label' => 'work step by step until it\'s done', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q4',
                'is_required' => true,
                'display_order' => 4
            ],
            // Question 5
            [
                'template_id' => $templateId,
                'question_text' => 'I work best with people who...',
                'option_a_label' => 'plan things effectively', // LL
                'option_b_label' => 'give solid, useful information', // LU
                'option_c_label' => 'enjoy sharing ideas', // RU
                'option_d_label' => 'help build a positive team vibe', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q5',
                'is_required' => true,
                'display_order' => 5
            ]
        ];
        
        // Insert Part 1 questions
        foreach ($part1Questions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        // Paradigm Main Part 2: 16 Sections (2-option selection)
        $part2Questions = [
            [
                'template_id' => $templateId,
                'question_text' => 'Section 1 - I enjoy being clear and direct.',
                'option_a_label' => 'I enjoy being clear and direct.',
                'option_b_label' => 'I like evaluating my own work and others.',
                'option_c_label' => null,
                'option_d_label' => null,
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'LU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_s1_q1',
                'is_required' => true,
                'display_order' => 31
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'Section 1 - I prefer using proven methods.',
                'option_a_label' => 'I prefer using proven methods.',
                'option_b_label' => 'I like turning ideas into action.',
                'option_c_label' => null,
                'option_d_label' => null,
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'LL',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_s1_q2',
                'is_required' => true,
                'display_order' => 32
            ]
        ];
        
        // Insert Part 2 questions
        foreach ($part2Questions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        $this->command->info('Paradigm Main questions seeded successfully!');
        $this->command->info('Part 1: ' . count($part1Questions) . ' questions (4-frame ranking)');
        $this->command->info('Part 2: ' . count($part2Questions) . ' questions (2-option selection)');
    }
}
