<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ParadigmCreditPackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if package already exists
        $exists = DB::table('credit_packages')->where('is_paradigm_package', true)->exists();

        if (!$exists) {
            DB::table('credit_packages')->insert([
                'credits' => 1, // Placeholder, will be updated by admin
                'base_price_zar' => 17.50, // Placeholder
                'final_price_zar' => 17.50, // Placeholder
                'usd_equivalent' => 1.00, // Placeholder
                'discount_percentage' => 0,
                'discount_amount_zar' => 0,
                'is_active' => false, // Inactive by default
                'is_paradigm_package' => true,
                'sort_order' => 99,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}

