<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class InvoiceTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            ['type' => 'Leads', 'status' => 1],
            ['type' => 'Booking', 'status' => 1],
            ['type' => 'Payout', 'status' => 1],
            ['type' => 'Wallet Top-up', 'status' => 1],
            ['type' => 'Paradigm Purchase', 'status' => 1],
        ];

        foreach ($types as $type) {
            // Check if type already exists
            $exists = DB::table('invoice_type')
                ->where('type', $type['type'])
                ->exists();
            
            if (!$exists) {
                DB::table('invoice_type')->insert([
                    'type' => $type['type'],
                    'status' => $type['status'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}

