<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ExactParadigmMainQuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first template ID
        $templateId = DB::table('paradigm_form_templates')->first()->id ?? 1;
        
        // Clear existing Paradigm Main questions
        DB::table('paradigm_questions')->where('assessment_module', 'paradigm_main')->delete();
        
        // Add Section Instructions
        $instructionQuestions = [
            [
                'template_id' => $templateId,
                'question_text' => 'PART 1: PERSONALITY PREFERENCES',
                'option_a_label' => '',
                'option_b_label' => '',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_instructions',
                'a_side' => '',
                'b_side' => '',
                'element_key' => 'paradigm_main_part1_instructions',
                'is_required' => false,
                'display_order' => 0
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'For each question below, please rank the 4 options from MOST like you (1st choice) to LEAST like you (4th choice). You must select exactly 3 out of 4 options, ranking them 1st, 2nd, and 3rd. Leave the 4th option unranked.',
                'option_a_label' => '',
                'option_b_label' => '',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_instructions',
                'a_side' => '',
                'b_side' => '',
                'element_key' => 'paradigm_main_part1_instructions_detail',
                'is_required' => false,
                'display_order' => 0.5
            ]
        ];
        
        // Insert instruction questions
        foreach ($instructionQuestions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        // Part 1: 30 Questions with EXACT text and mappings from user
        $part1Questions = [
            // Question 1
            [
                'template_id' => $templateId,
                'question_text' => 'When I study, I like to...',
                'option_a_label' => 'get an overall view of the material', // RU
                'option_b_label' => 'memorise important facts', // LU
                'option_c_label' => 'stay positive about what I\'m doing', // RL
                'option_d_label' => 'follow a set plan or method', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'c_side' => 'RL',
                'd_side' => 'LL',
                'element_key' => 'paradigm_main_q1',
                'is_required' => true,
                'display_order' => 1
            ],
            // Question 2
            [
                'template_id' => $templateId,
                'question_text' => 'I\'m drawn to people who...',
                'option_a_label' => 'are well-organised', // LL
                'option_b_label' => 'take a practical approach', // LU
                'option_c_label' => 'are open to different ideas', // RU
                'option_d_label' => 'really listen and pay attention to me', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'c_side' => 'RU',
                'd_side' => 'RL',
                'element_key' => 'paradigm_main_q2',
                'is_required' => true,
                'display_order' => 2
            ],
            // Question 3
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy situations that...',
                'option_a_label' => 'feel relaxed and friendly', // RL
                'option_b_label' => 'are tidy and well-arranged', // LL
                'option_c_label' => 'are new and exciting', // RU
                'option_d_label' => 'make me think on a deeper level', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RL',
                'b_side' => 'LL',
                'c_side' => 'RU',
                'd_side' => 'LU',
                'element_key' => 'paradigm_main_q3',
                'is_required' => true,
                'display_order' => 3
            ],
            // Question 4
            [
                'template_id' => $templateId,
                'question_text' => 'When working on a task, I prefer to...',
                'option_a_label' => 'focus on getting it accurate', // LU
                'option_b_label' => 'discuss it with others', // RL
                'option_c_label' => 'finish quickly and move on', // RU
                'option_d_label' => 'work step by step until it\'s done', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q4',
                'is_required' => true,
                'display_order' => 4
            ],
            // Question 5
            [
                'template_id' => $templateId,
                'question_text' => 'I work best with people who...',
                'option_a_label' => 'plan things effectively', // LL
                'option_b_label' => 'give solid, useful information', // LU
                'option_c_label' => 'enjoy sharing ideas', // RU
                'option_d_label' => 'help build a positive team vibe', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q5',
                'is_required' => true,
                'display_order' => 5
            ],
            // Question 6
            [
                'template_id' => $templateId,
                'question_text' => 'If I had to move to a new location, I\'d...',
                'option_a_label' => 'look at the pros and cons objectively', // LU
                'option_b_label' => 'worry about how it might affect my routine', // LL
                'option_c_label' => 'think about the new and old people in my life', // RL
                'option_d_label' => 'try to see how it fits into my future goals', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'c_side' => 'RL',
                'd_side' => 'RU',
                'element_key' => 'paradigm_main_q6',
                'is_required' => true,
                'display_order' => 6
            ],
            // Question 7
            [
                'template_id' => $templateId,
                'question_text' => 'When I travel, I like to...',
                'option_a_label' => 'weigh the pros and cons of a few places', // LU
                'option_b_label' => 'have everything planned in advance', // LL
                'option_c_label' => 'spend quality time with family or friends', // RL
                'option_d_label' => 'go with the flow and be spontaneous', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q7',
                'is_required' => true,
                'display_order' => 7
            ],
            // Question 8
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to process information by...',
                'option_a_label' => 'putting it into groups or categories', // LL
                'option_b_label' => 'first checking if the facts are accurate', // LU
                'option_c_label' => 'asking others what they think', // RL
                'option_d_label' => 'linking it to past experiences or ideas', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q8',
                'is_required' => true,
                'display_order' => 8
            ],
            // Question 9
            [
                'template_id' => $templateId,
                'question_text' => 'I like to be told...',
                'option_a_label' => '"Here are several things you can work on at once"', // RU
                'option_b_label' => '"Test it before using it"', // LU
                'option_c_label' => '"Talk it through with your colleagues"', // RL
                'option_d_label' => '"Be sure the basics are correct"', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q9',
                'is_required' => true,
                'display_order' => 9
            ],
            // Question 10
            [
                'template_id' => $templateId,
                'question_text' => 'When I go for a walk, I like to...',
                'option_a_label' => 'know how far I\'ll be walking', // LU
                'option_b_label' => 'go with friends', // RL
                'option_c_label' => 'walk where I feel safe', // LL
                'option_d_label' => 'take a different route each time', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q10',
                'is_required' => true,
                'display_order' => 10
            ],
            // Question 11
            [
                'template_id' => $templateId,
                'question_text' => 'When starting a new project, I prefer to...',
                'option_a_label' => 'work on it with others', // RL
                'option_b_label' => 'Prefer factual information about the project', // LU
                'option_c_label' => 'explore hidden opportunities', // RU
                'option_d_label' => 'finish it within a set time frame', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q11',
                'is_required' => true,
                'display_order' => 11
            ],
            // Question 12
            [
                'template_id' => $templateId,
                'question_text' => 'During training sessions, I like...',
                'option_a_label' => 'a well-prepared and structured talk', // LU
                'option_b_label' => 'variety in the way it\'s presented', // RU
                'option_c_label' => 'getting notes and structure in advance', // LL
                'option_d_label' => 'a calm, easygoing setting', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RU',
                'element_key' => 'paradigm_main_q12',
                'is_required' => true,
                'display_order' => 12
            ],
            // Question 13
            [
                'template_id' => $templateId,
                'question_text' => 'In my job, I\'d enjoy a challenge that helps me...',
                'option_a_label' => 'design new programs for the team or company', // RU
                'option_b_label' => 'assist someone with a complex task', // RL
                'option_c_label' => 'create a checklist and track its completion', // LL
                'option_d_label' => 'gain knowledge that improves how I work', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q13',
                'is_required' => true,
                'display_order' => 13
            ],
            // Question 14
            [
                'template_id' => $templateId,
                'question_text' => 'When visiting somewhere new, I prefer to...',
                'option_a_label' => 'study how to get there in detail', // LU
                'option_b_label' => 'take a map and follow it carefully', // LL
                'option_c_label' => 'ask people for directions', // RL
                'option_d_label' => 'get a feel for the area and trust my gut', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q14',
                'is_required' => true,
                'display_order' => 14
            ],
            // Question 15
            [
                'template_id' => $templateId,
                'question_text' => 'If I won a large amount of money, I\'d...',
                'option_a_label' => 'explore what possibilities it could bring', // RU
                'option_b_label' => 'celebrate with my friends or family', // RL
                'option_c_label' => 'think about ways to invest it', // LU
                'option_d_label' => 'see it as financial security for the future', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q15',
                'is_required' => true,
                'display_order' => 15
            ],
            // Question 16
            [
                'template_id' => $templateId,
                'question_text' => 'When I listen to a speaker, I like it when they...',
                'option_a_label' => 'push me to think outside the box', // RU
                'option_b_label' => 'have a clear structure with a beginning, middle, and end', // LL
                'option_c_label' => 'show passion and energy for the topic', // RL
                'option_d_label' => 'stay focused and on track', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q16',
                'is_required' => true,
                'display_order' => 16
            ],
            // Question 17
            [
                'template_id' => $templateId,
                'question_text' => 'I\'d prefer to be part of an organisation that focuses on...',
                'option_a_label' => 'strategy and innovation', // RU
                'option_b_label' => 'efficiency and productivity', // LL
                'option_c_label' => 'fairness and strong values', // RL
                'option_d_label' => 'sound money management', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q17',
                'is_required' => true,
                'display_order' => 17
            ],
            // Question 18
            [
                'template_id' => $templateId,
                'question_text' => 'When reading about an event, I prefer...',
                'option_a_label' => 'a broad overview with few details', // RU
                'option_b_label' => 'a factual and precise report', // LU
                'option_c_label' => 'a step-by-step detailed report', // LL
                'option_d_label' => 'a story told with care and empathy', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q18',
                'is_required' => true,
                'display_order' => 18
            ],
            // Question 19
            [
                'template_id' => $templateId,
                'question_text' => 'I\'d like my friends to describe me as someone who...',
                'option_a_label' => 'gets things done', // LL
                'option_b_label' => 'always has fresh ideas', // RU
                'option_c_label' => 'is caring and thoughtful', // RL
                'option_d_label' => 'speaks directly and clearly', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'RU',
                'element_key' => 'paradigm_main_q19',
                'is_required' => true,
                'display_order' => 19
            ],
            // Question 20
            [
                'template_id' => $templateId,
                'question_text' => 'I like ideas that are...',
                'option_a_label' => 'well thought through', // LU
                'option_b_label' => 'put into action', // LL
                'option_c_label' => 'discussed with others', // RL
                'option_d_label' => 'explored in depth', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q20',
                'is_required' => true,
                'display_order' => 20
            ],
            // Question 21
            [
                'template_id' => $templateId,
                'question_text' => 'When thinking about what to do, I\'d prefer to...',
                'option_a_label' => 'try something totally new', // RU
                'option_b_label' => 'understand the facts', // LU
                'option_c_label' => 'create a specific step-by-step action plan', // LL
                'option_d_label' => 'help resolve a conflict between people', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q21',
                'is_required' => true,
                'display_order' => 21
            ],
            // Question 22
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy spending time with people who...',
                'option_a_label' => 'are kind and speak gently', // RL
                'option_b_label' => 'know what they want', // LU
                'option_c_label' => 'respect time and are punctual', // LL
                'option_d_label' => 'are full of imagination and creativity', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q22',
                'is_required' => true,
                'display_order' => 22
            ],
            // Question 23
            [
                'template_id' => $templateId,
                'question_text' => 'As a new employee, I\'d value...',
                'option_a_label' => 'clear and logical guidance', // LU
                'option_b_label' => 'being accepted by others', // RL
                'option_c_label' => 'growth opportunities', // RU
                'option_d_label' => 'organised and efficient leadership', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q23',
                'is_required' => true,
                'display_order' => 23
            ],
            // Question 24
            [
                'template_id' => $templateId,
                'question_text' => 'At work, I like to...',
                'option_a_label' => 'be fully prepared', // LL
                'option_b_label' => 'make fair and balanced decisions', // LU
                'option_c_label' => 'look out for my colleagues\' needs', // RL
                'option_d_label' => 'explore and be curious', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q24',
                'is_required' => true,
                'display_order' => 24
            ],
            // Question 25
            [
                'template_id' => $templateId,
                'question_text' => 'I\'d prefer people to describe me as...',
                'option_a_label' => 'someone who never slips up', // LU
                'option_b_label' => 'warm and kind-hearted', // RL
                'option_c_label' => 'hardworking and thorough', // LL
                'option_d_label' => 'different and original', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q25',
                'is_required' => true,
                'display_order' => 25
            ],
            // Question 26
            [
                'template_id' => $templateId,
                'question_text' => 'I like the saying...',
                'option_a_label' => '"Take it apart"', // LU
                'option_b_label' => '"Surprise me"', // RU
                'option_c_label' => '"Put the team first"', // RL
                'option_d_label' => '"Experience teaches us"', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RU',
                'element_key' => 'paradigm_main_q26',
                'is_required' => true,
                'display_order' => 26
            ],
            // Question 27
            [
                'template_id' => $templateId,
                'question_text' => 'When meeting people, I prefer to...',
                'option_a_label' => 'find common ground and work together', // RL
                'option_b_label' => 'choose words carefully and avoid mistakes', // LU
                'option_c_label' => 'give full explanations without leaving anything out', // LL
                'option_d_label' => 'talk about future possibilities', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q27',
                'is_required' => true,
                'display_order' => 27
            ],
            // Question 28
            [
                'template_id' => $templateId,
                'question_text' => 'My style is...',
                'option_a_label' => 'just enough detail to see the bigger picture', // RU
                'option_b_label' => 'try it first and see how it goes', // LL
                'option_c_label' => 'straight to the point', // LU
                'option_d_label' => 'listen and learn from others', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q28',
                'is_required' => true,
                'display_order' => 28
            ],
            // Question 29
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy magazines that...',
                'option_a_label' => 'give stats and facts on topics I like', // LU
                'option_b_label' => 'offer lots of practical "how-to" tips', // LL
                'option_c_label' => 'give insider stories about people', // RL
                'option_d_label' => 'surprise me with new and unusual content', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q29',
                'is_required' => true,
                'display_order' => 29
            ],
            // Question 30
            [
                'template_id' => $templateId,
                'question_text' => 'When I think about the future, I like to...',
                'option_a_label' => 'think in broader terms and not specifics', // RU
                'option_b_label' => 'have a clear roadmap', // LL
                'option_c_label' => 'be sensible and practical', // LU
                'option_d_label' => 'see how it connects with those around me', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q30',
                'is_required' => true,
                'display_order' => 30
            ]
        ];
        
        // Insert Part 1 questions
        foreach ($part1Questions as $question) {
            // Ensure c_side and d_side are included
            $questionData = array_merge($question, [
                'c_side' => $question['c_side'] ?? '',
                'd_side' => $question['d_side'] ?? '',
                'created_at' => now(),
                'updated_at' => now()
            ]);
            DB::table('paradigm_questions')->insert($questionData);
        }
        
        $this->command->info('Exact Paradigm Main Part 1 questions seeded successfully!');
        $this->command->info('Instructions: 2 instruction questions');
        $this->command->info('Part 1: 30 questions with exact text and correct quadrant mappings');
        $this->command->info('Total: 32 questions');
        $this->command->info('Answer Options: 120 answers (30 × 4)');
    }
}
