<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmQuestion;

class CorrectParadigmPart2Seeder extends Seeder
{
    public function run(): void
    {
        $questions = [
            // Section 1 (Questions 1-4)
            [
                'question_text' => 'Section 1 - Question 1',
                'option_a_text' => 'I enjoy being clear and direct.',
                'option_b_text' => 'I like evaluating my own work and others.',
                'a_side' => 'LU – The Question Asker',
                'b_side' => 'LU – The Fact Finder',
            ],
            [
                'question_text' => 'Section 1 - Question 2',
                'option_a_text' => 'I prefer using proven methods.',
                'option_b_text' => 'I like turning ideas into action.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 1 - Question 3',
                'option_a_text' => 'I enjoy experimenting with new ideas.',
                'option_b_text' => 'I sometimes enjoy thinking in unusual and imaginative ways.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 1 - Question 4',
                'option_a_text' => 'I like being around people.',
                'option_b_text' => 'I enjoy supporting others.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 2 (Questions 5-8)
            [
                'question_text' => 'Section 2 - Question 1',
                'option_a_text' => 'I prefer to work or study without any interruptions.',
                'option_b_text' => 'I like checking every detail to see if it\'s accurate.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 2 - Question 2',
                'option_a_text' => 'I enjoy environments with structure and discipline.',
                'option_b_text' => 'I prefer doing things over just thinking about them.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 2 - Question 3',
                'option_a_text' => 'I often think ahead to what\'s coming.',
                'option_b_text' => 'I trust my gut, even if I don\'t have all the facts.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 2 - Question 4',
                'option_a_text' => 'I like working in group settings.',
                'option_b_text' => 'I prefer interacting with just one or two people at a time.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 3 (Questions 9-12)
            [
                'question_text' => 'Section 3 - Question 1',
                'option_a_text' => 'I prefer focusing on one task at a time.',
                'option_b_text' => 'I like getting to the root of a problem.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 3 - Question 2',
                'option_a_text' => 'I enjoy spaces where neatness and thoroughness are valued.',
                'option_b_text' => 'I like sorting and organizing thoughts or information.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 3 - Question 3',
                'option_a_text' => 'I enjoy listening to people who talk about what\'s ahead.',
                'option_b_text' => 'I naturally think in visual images.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 3 - Question 4',
                'option_a_text' => 'I enjoy conversations with others.',
                'option_b_text' => 'I like being helpful to those around me.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 4 (Questions 13-16)
            [
                'question_text' => 'Section 4 - Question 1',
                'option_a_text' => 'I prefer having clear goals to work toward.',
                'option_b_text' => 'I like reflecting deeply on issues before acting.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 4 - Question 2',
                'option_a_text' => 'I feel comfortable in environments that value tradition.',
                'option_b_text' => 'I enjoy making plans and organizing tasks.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 4 - Question 3',
                'option_a_text' => 'I like pondering big ideas even while handling small tasks.',
                'option_b_text' => 'I\'m comfortable thinking on my feet.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 4 - Question 4',
                'option_a_text' => 'I enjoy meeting and spending time with new people.',
                'option_b_text' => 'I go out of my way to show care and concern for others.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 5 (Questions 17-20)
            [
                'question_text' => 'Section 5 - Question 1',
                'option_a_text' => 'I like going beyond just the facts.',
                'option_b_text' => 'I enjoy making sense of the facts I come across.',
                'a_side' => 'LU – The Question Asker',
                'b_side' => 'LU – The Fact Finder',
            ],
            [
                'question_text' => 'Section 5 - Question 2',
                'option_a_text' => 'I like to always be on time.',
                'option_b_text' => 'I like ensuring that rules are followed.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 5 - Question 3',
                'option_a_text' => 'I often daydream about unfamiliar places.',
                'option_b_text' => 'I frequently think about where I want to be in the future.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 5 - Question 4',
                'option_a_text' => 'I like listening to everyone\'s thoughts and opinions.',
                'option_b_text' => 'I feel energized when I\'m surrounded by others.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 6 (Questions 21-24)
            [
                'question_text' => 'Section 6 - Question 1',
                'option_a_text' => 'I enjoy taking things apart to explore them.',
                'option_b_text' => 'I prefer staying focused on one task at a time.',
                'a_side' => 'LU – The Question Asker',
                'b_side' => 'LU – The Fact Finder',
            ],
            [
                'question_text' => 'Section 6 - Question 2',
                'option_a_text' => 'I like organizing and initiating things.',
                'option_b_text' => 'I enjoy working or studying in clean and tidy surroundings.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 6 - Question 3',
                'option_a_text' => 'I love imagining things that might seem impossible.',
                'option_b_text' => 'I like coming up with new ways to solve old problems.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 6 - Question 4',
                'option_a_text' => 'I value being around people who genuinely care.',
                'option_b_text' => 'I learn a lot from interacting with different kinds of people.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 7 (Questions 25-28)
            [
                'question_text' => 'Section 7 - Question 1',
                'option_a_text' => 'I like uncovering the real cause behind a problem.',
                'option_b_text' => 'I focus on what\'s most important at any given time.',
                'a_side' => 'LU – The Question Asker',
                'b_side' => 'LU – The Fact Finder',
            ],
            [
                'question_text' => 'Section 7 - Question 2',
                'option_a_text' => 'I don\'t mind repeating something until I get it right.',
                'option_b_text' => 'I feel most comfortable in safe and secure environments.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 7 - Question 3',
                'option_a_text' => 'I use my imagination to think outside the box.',
                'option_b_text' => 'I gain new understanding by exploring different perspectives.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 7 - Question 4',
                'option_a_text' => 'I enjoy making others feel happy.',
                'option_b_text' => 'I like encouraging others and boosting their confidence.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 8 (Questions 29-32)
            [
                'question_text' => 'Section 8 - Question 1',
                'option_a_text' => 'I like breaking down complex issues into smaller parts.',
                'option_b_text' => 'Accuracy is very important to me.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 8 - Question 2',
                'option_a_text' => 'I prefer to prepare well for meetings, exams, and tasks.',
                'option_b_text' => 'I\'m careful and avoid unnecessary risks.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 8 - Question 3',
                'option_a_text' => 'I enjoy sketching or doodling while thinking or listening.',
                'option_b_text' => 'I\'m always searching for fresh, different approaches.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 8 - Question 4',
                'option_a_text' => 'I feel fulfilled when I can serve and support others.',
                'option_b_text' => 'I prefer working in environments full of life and energy.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 9 (Questions 33-36)
            [
                'question_text' => 'Section 9 - Question 1',
                'option_a_text' => 'I like having clear, easy-to-follow instructions.',
                'option_b_text' => 'I always want to understand the deeper meaning behind things.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 9 - Question 2',
                'option_a_text' => 'I want others to see me as reliable and trustworthy.',
                'option_b_text' => 'I enjoy following structured schedules and timetables.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 9 - Question 3',
                'option_a_text' => 'I often imagine what the future might hold.',
                'option_b_text' => 'I explain things in a way that helps others visualize them.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 9 - Question 4',
                'option_a_text' => 'I prefer working in a team rather than alone.',
                'option_b_text' => 'I like sharing ideas with one or two close people.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 10 (Questions 37-40)
            [
                'question_text' => 'Section 10 - Question 1',
                'option_a_text' => 'I like knowing the exact goal or purpose before starting something.',
                'option_b_text' => 'I prefer asking questions to fully understand things.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 10 - Question 2',
                'option_a_text' => 'I value loyalty and responsibility in others.',
                'option_b_text' => 'I enjoy using checklists to make sure nothing gets missed.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 10 - Question 3',
                'option_a_text' => 'I tend to ask "Why" and "Why not" before "What" and "How."',
                'option_b_text' => 'I enjoy relaxed environments without too many rules.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 10 - Question 4',
                'option_a_text' => 'I like being surrounded by people I can engage with.',
                'option_b_text' => 'I enjoy spending free time with those closest to me.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 11 (Questions 41-44)
            [
                'question_text' => 'Section 11 - Question 1',
                'option_a_text' => 'I appreciate simple, clear explanations.',
                'option_b_text' => 'I like figuring out what\'s right and wrong.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 11 - Question 2',
                'option_a_text' => 'I thrive where dedication and hard work are rewarded.',
                'option_b_text' => 'I prefer taking action when something needs to be done.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 11 - Question 3',
                'option_a_text' => 'I enjoy settings where there\'s variety and change.',
                'option_b_text' => 'I\'m drawn to doing things that break the routine.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 11 - Question 4',
                'option_a_text' => 'I like expanding my social circle by meeting new people.',
                'option_b_text' => 'I enjoy connecting with familiar people.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 12 (Questions 45-48)
            [
                'question_text' => 'Section 12 - Question 1',
                'option_a_text' => 'I like ideas that are practical and meaningful.',
                'option_b_text' => 'I tend to analyze and measure things before making decisions.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 12 - Question 2',
                'option_a_text' => 'I work well with people who are committed and reliable.',
                'option_b_text' => 'I like making sure everything is functioning properly.',
                'a_side' => 'LL – The Rule Keeper',
                'b_side' => 'LL – The Task Manager',
            ],
            [
                'question_text' => 'Section 12 - Question 3',
                'option_a_text' => 'I enjoy sharing my thoughts about the future.',
                'option_b_text' => 'I like generating fresh, original ideas instead of recycling old ones.',
                'a_side' => 'RU – The Big Thinker',
                'b_side' => 'RU – The Creator',
            ],
            [
                'question_text' => 'Section 12 - Question 4',
                'option_a_text' => 'I enjoy being part of a positive, uplifting group.',
                'option_b_text' => 'I prefer having a few deep and meaningful friendships.',
                'a_side' => 'RL – The Friend Maker',
                'b_side' => 'RL – The Empath',
            ],

            // Section 13 (Questions 49-52)
            [
                'question_text' => 'Section 13 - Question 1',
                'option_a_text' => 'I like doing research before reaching a final conclusion.',
                'option_b_text' => 'I prefer keeping my opinions grounded and realistic.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 13 - Question 2',
                'option_a_text' => 'I enjoy making detailed to-do lists for tasks.',
                'option_b_text' => 'I like being part of environments that value tradition.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 13 - Question 3',
                'option_a_text' => 'I often visualize what people say when they explain things.',
                'option_b_text' => 'I enjoy the thrill that comes with change and progress.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 13 - Question 4',
                'option_a_text' => 'I feel driven to help those in need.',
                'option_b_text' => 'I like bringing people together to talk, celebrate, or collaborate.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 14 (Questions 53-56)
            [
                'question_text' => 'Section 14 - Question 1',
                'option_a_text' => 'I dig deep to uncover the truth.',
                'option_b_text' => 'I only like starting once I\'m sure of the direction.',
                'a_side' => 'LU – The Question Asker',
                'b_side' => 'LU – The Fact Finder',
            ],
            [
                'question_text' => 'Section 14 - Question 2',
                'option_a_text' => 'I prefer reading or studying step-by-step, from beginning to end.',
                'option_b_text' => 'I like visiting safe, reliable places.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 14 - Question 3',
                'option_a_text' => 'I sometimes imagine things that don\'t yet exist.',
                'option_b_text' => 'I often think about how to improve the world.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 14 - Question 4',
                'option_a_text' => 'I choose to stay hopeful and positive.',
                'option_b_text' => 'I enjoy being around lighthearted, easy going people.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 15 (Questions 57-60)
            [
                'question_text' => 'Section 15 - Question 1',
                'option_a_text' => 'I carefully examine problems before trying to solve them.',
                'option_b_text' => 'I prefer setting simple, realistic goals.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 15 - Question 2',
                'option_a_text' => 'I like overseeing tasks to ensure they stay on track.',
                'option_b_text' => 'I believe in solving problems slowly but surely.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 15 - Question 3',
                'option_a_text' => 'I work best when I have the freedom to do things my way.',
                'option_b_text' => 'I enjoy new experiences and the unknown.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 15 - Question 4',
                'option_a_text' => 'I like spending time in places that feel warm and welcoming.',
                'option_b_text' => 'I enjoy being social and having fun.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],

            // Section 16 (Questions 61-64)
            [
                'question_text' => 'Section 16 - Question 1',
                'option_a_text' => 'I prefer to fully understand things before moving forward.',
                'option_b_text' => 'I like knowing exactly what to expect in my environment.',
                'a_side' => 'LU – The Fact Finder',
                'b_side' => 'LU – The Question Asker',
            ],
            [
                'question_text' => 'Section 16 - Question 2',
                'option_a_text' => 'I believe consistent practice leads to improvement.',
                'option_b_text' => 'I value lessons learned from past experiences.',
                'a_side' => 'LL – The Task Manager',
                'b_side' => 'LL – The Rule Keeper',
            ],
            [
                'question_text' => 'Section 16 - Question 3',
                'option_a_text' => 'I enjoy thinking in unconventional and creative ways.',
                'option_b_text' => 'I like finding ideas that make life better.',
                'a_side' => 'RU – The Creator',
                'b_side' => 'RU – The Big Thinker',
            ],
            [
                'question_text' => 'Section 16 - Question 4',
                'option_a_text' => 'I enjoy comforting and encouraging the people I care about.',
                'option_b_text' => 'I like having a good time.',
                'a_side' => 'RL – The Empath',
                'b_side' => 'RL – The Friend Maker',
            ],
        ];

        $displayOrder = 1;
        foreach ($questions as $q) {
            ParadigmQuestion::create([
                'question_text' => $q['question_text'],
                'option_a_label' => $q['option_a_text'],
                'option_b_label' => $q['option_b_text'],
                'template_id' => 1,
                'assessment_module' => 'paradigm_main',
                'element_key' => 'paradigm_main_part2_q' . $displayOrder,
                'is_required' => 1,
                'a_side' => $q['a_side'],
                'b_side' => $q['b_side'],
                'question_type' => 'part2',
                'axis' => 'part2',
                'display_order' => $displayOrder++,
            ]);
        }
    }
}
