<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CompletePart2QuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first template ID
        $templateId = DB::table('paradigm_form_templates')->first()->id ?? 1;
        
        // Add remaining Part 2 questions (60 more to reach 64 total)
        $part2Questions = [
            // Section 2 - Q1
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to work with detailed information.',
                'option_a_label' => 'I prefer to work with detailed information.', // LU - The Fact Finder
                'option_b_label' => 'I like asking probing questions.', // LU - The Question Asker
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'LU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_s2_q1',
                'is_required' => true,
                'display_order' => 35
            ],
            // Section 2 - Q2
            [
                'template_id' => $templateId,
                'question_text' => 'I like following established procedures.',
                'option_a_label' => 'I like following established procedures.', // LL - The Rule Keeper
                'option_b_label' => 'I prefer to organize tasks efficiently.', // LL - The Task Manager
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'LL',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_s2_q2',
                'is_required' => true,
                'display_order' => 36
            ],
            // Section 2 - Q3
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy creative problem-solving.',
                'option_a_label' => 'I enjoy creative problem-solving.', // RU - The Creator
                'option_b_label' => 'I like thinking outside the box.', // RU - The Big Thinker
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'RU',
                'b_side' => 'RU',
                'element_key' => 'paradigm_main_s2_q3',
                'is_required' => true,
                'display_order' => 37
            ],
            // Section 2 - Q4
            [
                'template_id' => $templateId,
                'question_text' => 'I value emotional connections.',
                'option_a_label' => 'I value emotional connections.', // RL - The Empath
                'option_b_label' => 'I enjoy building relationships.', // RL - The Friend Maker
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'RL',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_s2_q4',
                'is_required' => true,
                'display_order' => 38
            ]
        ];
        
        // Insert Part 2 questions
        foreach ($part2Questions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        $this->command->info('Part 2 questions added successfully!');
        $this->command->info('Added ' . count($part2Questions) . ' more Part 2 questions');
        $this->command->info('Total Part 2 questions: ' . (4 + count($part2Questions)));
    }
}