<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CompleteParadigmMainQuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first template ID (assuming it exists)
        $templateId = DB::table('paradigm_form_templates')->first()->id ?? 1;
        
        // Clear existing Paradigm Main questions
        DB::table('paradigm_questions')->where('assessment_module', 'paradigm_main')->delete();
        
        // Add Section Instructions
        $instructionQuestions = [
            // Part 1 Instructions
            [
                'template_id' => $templateId,
                'question_text' => 'PART 1: PERSONALITY PREFERENCES',
                'option_a_label' => '',
                'option_b_label' => '',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_instructions',
                'a_side' => null,
                'b_side' => null,
                'element_key' => 'paradigm_main_part1_instructions',
                'is_required' => false,
                'display_order' => 0
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'For each question below, please rank the 4 options from MOST like you (1st choice) to LEAST like you (4th choice). You must select exactly 3 out of 4 options, ranking them 1st, 2nd, and 3rd. Leave the 4th option unranked.',
                'option_a_label' => '',
                'option_b_label' => '',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_instructions',
                'a_side' => null,
                'b_side' => null,
                'element_key' => 'paradigm_main_part1_instructions_detail',
                'is_required' => false,
                'display_order' => 0.5
            ]
        ];
        
        // Insert instruction questions
        foreach ($instructionQuestions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        // Paradigm Main Part 1: 30 Questions (4-frame ranking) - EXACT as provided
        $part1Questions = [
            // Question 1
            [
                'template_id' => $templateId,
                'question_text' => 'When I study, I like to...',
                'option_a_label' => 'get an overall view of the material', // RU
                'option_b_label' => 'memorise important facts', // LU
                'option_c_label' => 'stay positive about what I\'m doing', // RL
                'option_d_label' => 'follow a set plan or method', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q1',
                'is_required' => true,
                'display_order' => 1
            ],
            // Question 2
            [
                'template_id' => $templateId,
                'question_text' => 'I\'m drawn to people who...',
                'option_a_label' => 'are well-organised', // LL
                'option_b_label' => 'take a practical approach', // LU
                'option_c_label' => 'are open to different ideas', // RU
                'option_d_label' => 'really listen and pay attention to me', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q2',
                'is_required' => true,
                'display_order' => 2
            ],
            // Question 3
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy situations that...',
                'option_a_label' => 'feel relaxed and friendly', // RL
                'option_b_label' => 'are tidy and well-arranged', // LL
                'option_c_label' => 'are new and exciting', // RU
                'option_d_label' => 'make me think on a deeper level', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RL',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q3',
                'is_required' => true,
                'display_order' => 3
            ],
            // Question 4
            [
                'template_id' => $templateId,
                'question_text' => 'When working on a task, I prefer to...',
                'option_a_label' => 'focus on getting it accurate', // LU
                'option_b_label' => 'discuss it with others', // RL
                'option_c_label' => 'finish quickly and move on', // RU
                'option_d_label' => 'work step by step until it\'s done', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q4',
                'is_required' => true,
                'display_order' => 4
            ],
            // Question 5
            [
                'template_id' => $templateId,
                'question_text' => 'I work best with people who...',
                'option_a_label' => 'plan things effectively', // LL
                'option_b_label' => 'give solid, useful information', // LU
                'option_c_label' => 'enjoy sharing ideas', // RU
                'option_d_label' => 'help build a positive team vibe', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q5',
                'is_required' => true,
                'display_order' => 5
            ],
            // Question 6
            [
                'template_id' => $templateId,
                'question_text' => 'If I had to move to a new location, I\'d...',
                'option_a_label' => 'look at the pros and cons objectively', // LU
                'option_b_label' => 'worry about how it might affect my routine', // LL
                'option_c_label' => 'think about the new and old people in my life', // RL
                'option_d_label' => 'try to see how it fits into my future goals', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q6',
                'is_required' => true,
                'display_order' => 6
            ],
            // Question 7
            [
                'template_id' => $templateId,
                'question_text' => 'When I travel, I like to...',
                'option_a_label' => 'weigh the pros and cons of a few places', // LU
                'option_b_label' => 'have everything planned in advance', // LL
                'option_c_label' => 'spend quality time with family or friends', // RL
                'option_d_label' => 'go with the flow and be spontaneous', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q7',
                'is_required' => true,
                'display_order' => 7
            ],
            // Question 8
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to process information by...',
                'option_a_label' => 'putting it into groups or categories', // LL
                'option_b_label' => 'first checking if the facts are accurate', // LU
                'option_c_label' => 'asking others what they think', // RL
                'option_d_label' => 'linking it to past experiences or ideas', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q8',
                'is_required' => true,
                'display_order' => 8
            ],
            // Question 9
            [
                'template_id' => $templateId,
                'question_text' => 'I like to be told...',
                'option_a_label' => '"Here are several things you can work on at once"', // RU
                'option_b_label' => '"Test it before using it"', // LU
                'option_c_label' => '"Talk it through with your colleagues"', // RL
                'option_d_label' => '"Be sure the basics are correct"', // LL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q9',
                'is_required' => true,
                'display_order' => 9
            ],
            // Question 10
            [
                'template_id' => $templateId,
                'question_text' => 'When I go for a walk, I like to...',
                'option_a_label' => 'know how far I\'ll be walking', // LU
                'option_b_label' => 'go with friends', // RL
                'option_c_label' => 'walk where I feel safe', // LL
                'option_d_label' => 'take a different route each time', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_q10',
                'is_required' => true,
                'display_order' => 10
            ],
            // Question 11
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to work on projects that...',
                'option_a_label' => 'have clear deadlines and structure', // LL
                'option_b_label' => 'require careful analysis and research', // LU
                'option_c_label' => 'involve creative problem-solving', // RU
                'option_d_label' => 'help people and make a difference', // RL
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q11',
                'is_required' => true,
                'display_order' => 11
            ],
            // Question 12
            [
                'template_id' => $templateId,
                'question_text' => 'When making decisions, I tend to...',
                'option_a_label' => 'gather all the facts first', // LU
                'option_b_label' => 'follow established procedures', // LL
                'option_c_label' => 'consider how it affects others', // RL
                'option_d_label' => 'look for innovative solutions', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q12',
                'is_required' => true,
                'display_order' => 12
            ],
            // Question 13
            [
                'template_id' => $templateId,
                'question_text' => 'I feel most comfortable when...',
                'option_a_label' => 'I have all the information I need', // LU
                'option_b_label' => 'everything is organized and planned', // LL
                'option_c_label' => 'I\'m surrounded by supportive people', // RL
                'option_d_label' => 'I can explore new possibilities', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q13',
                'is_required' => true,
                'display_order' => 13
            ],
            // Question 14
            [
                'template_id' => $templateId,
                'question_text' => 'I learn best when...',
                'option_a_label' => 'I can see the big picture first', // RU
                'option_b_label' => 'I have detailed instructions to follow', // LL
                'option_c_label' => 'I can discuss it with others', // RL
                'option_d_label' => 'I understand the underlying principles', // LU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'RU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q14',
                'is_required' => true,
                'display_order' => 14
            ],
            // Question 15
            [
                'template_id' => $templateId,
                'question_text' => 'When faced with a problem, I...',
                'option_a_label' => 'analyze it step by step', // LU
                'option_b_label' => 'look for a proven solution', // LL
                'option_c_label' => 'ask others for their input', // RL
                'option_d_label' => 'brainstorm creative approaches', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q15',
                'is_required' => true,
                'display_order' => 15
            ],
            // Question 16
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer environments that are...',
                'option_a_label' => 'quiet and focused', // LU
                'option_b_label' => 'well-organized and structured', // LL
                'option_c_label' => 'warm and collaborative', // RL
                'option_d_label' => 'dynamic and stimulating', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q16',
                'is_required' => true,
                'display_order' => 16
            ],
            // Question 17
            [
                'template_id' => $templateId,
                'question_text' => 'I value most in a team...',
                'option_a_label' => 'expertise and knowledge', // LU
                'option_b_label' => 'reliability and consistency', // LL
                'option_c_label' => 'cooperation and support', // RL
                'option_d_label' => 'innovation and creativity', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q17',
                'is_required' => true,
                'display_order' => 17
            ],
            // Question 18
            [
                'template_id' => $templateId,
                'question_text' => 'When I need to remember something, I...',
                'option_a_label' => 'write it down systematically', // LL
                'option_b_label' => 'understand the logic behind it', // LU
                'option_c_label' => 'connect it to personal experiences', // RL
                'option_d_label' => 'create mental associations', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q18',
                'is_required' => true,
                'display_order' => 18
            ],
            // Question 19
            [
                'template_id' => $templateId,
                'question_text' => 'I approach new challenges by...',
                'option_a_label' => 'researching best practices', // LU
                'option_b_label' => 'following a proven method', // LL
                'option_c_label' => 'seeking advice from others', // RL
                'option_d_label' => 'experimenting with new approaches', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q19',
                'is_required' => true,
                'display_order' => 19
            ],
            // Question 20
            [
                'template_id' => $templateId,
                'question_text' => 'I feel most accomplished when...',
                'option_a_label' => 'I\'ve solved a complex problem', // LU
                'option_b_label' => 'I\'ve completed a task perfectly', // LL
                'option_c_label' => 'I\'ve helped someone succeed', // RL
                'option_d_label' => 'I\'ve created something new', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q20',
                'is_required' => true,
                'display_order' => 20
            ],
            // Question 21
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to work...',
                'option_a_label' => 'independently on focused tasks', // LU
                'option_b_label' => 'with clear procedures and guidelines', // LL
                'option_c_label' => 'collaboratively with others', // RL
                'option_d_label' => 'on varied and interesting projects', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q21',
                'is_required' => true,
                'display_order' => 21
            ],
            // Question 22
            [
                'template_id' => $templateId,
                'question_text' => 'When I communicate, I focus on...',
                'option_a_label' => 'providing accurate information', // LU
                'option_b_label' => 'being clear and organized', // LL
                'option_c_label' => 'building relationships', // RL
                'option_d_label' => 'inspiring and motivating', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q22',
                'is_required' => true,
                'display_order' => 22
            ],
            // Question 23
            [
                'template_id' => $templateId,
                'question_text' => 'I make decisions based on...',
                'option_a_label' => 'thorough analysis and evidence', // LU
                'option_b_label' => 'established rules and procedures', // LL
                'option_c_label' => 'how it affects people', // RL
                'option_d_label' => 'potential for innovation', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q23',
                'is_required' => true,
                'display_order' => 23
            ],
            // Question 24
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to learn through...',
                'option_a_label' => 'reading and research', // LU
                'option_b_label' => 'structured courses and training', // LL
                'option_c_label' => 'discussion and interaction', // RL
                'option_d_label' => 'hands-on experimentation', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q24',
                'is_required' => true,
                'display_order' => 24
            ],
            // Question 25
            [
                'template_id' => $templateId,
                'question_text' => 'I feel most energized when...',
                'option_a_label' => 'I\'m solving complex problems', // LU
                'option_b_label' => 'I\'m following a clear plan', // LL
                'option_c_label' => 'I\'m working with a team', // RL
                'option_d_label' => 'I\'m exploring new ideas', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q25',
                'is_required' => true,
                'display_order' => 25
            ],
            // Question 26
            [
                'template_id' => $templateId,
                'question_text' => 'I approach deadlines by...',
                'option_a_label' => 'planning carefully in advance', // LL
                'option_b_label' => 'analyzing what\'s required first', // LU
                'option_c_label' => 'working with others to meet them', // RL
                'option_d_label' => 'finding creative ways to achieve them', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LL',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_q26',
                'is_required' => true,
                'display_order' => 26
            ],
            // Question 27
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to work in...',
                'option_a_label' => 'quiet, focused environments', // LU
                'option_b_label' => 'well-organized, structured spaces', // LL
                'option_c_label' => 'collaborative, social settings', // RL
                'option_d_label' => 'dynamic, creative atmospheres', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q27',
                'is_required' => true,
                'display_order' => 27
            ],
            // Question 28
            [
                'template_id' => $templateId,
                'question_text' => 'I value most in information...',
                'option_a_label' => 'accuracy and reliability', // LU
                'option_b_label' => 'clarity and organization', // LL
                'option_c_label' => 'relevance to people', // RL
                'option_d_label' => 'novelty and innovation', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q28',
                'is_required' => true,
                'display_order' => 28
            ],
            // Question 29
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer to start projects by...',
                'option_a_label' => 'understanding the requirements fully', // LU
                'option_b_label' => 'creating a detailed plan', // LL
                'option_c_label' => 'discussing with the team', // RL
                'option_d_label' => 'brainstorming possibilities', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q29',
                'is_required' => true,
                'display_order' => 29
            ],
            // Question 30
            [
                'template_id' => $templateId,
                'question_text' => 'I feel most satisfied when...',
                'option_a_label' => 'I\'ve thoroughly understood something', // LU
                'option_b_label' => 'I\'ve completed something perfectly', // LL
                'option_c_label' => 'I\'ve helped others succeed', // RL
                'option_d_label' => 'I\'ve created something meaningful', // RU
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'a_side' => 'LU',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_q30',
                'is_required' => true,
                'display_order' => 30
            ]
        ];
        
        // Insert Part 1 questions (all 30)
        foreach ($part1Questions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        // Add Part 2 Instructions
        $part2Instructions = [
            [
                'template_id' => $templateId,
                'question_text' => 'PART 2: BEHAVIORAL PATTERNS',
                'option_a_label' => '',
                'option_b_label' => '',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_instructions',
                'a_side' => null,
                'b_side' => null,
                'element_key' => 'paradigm_main_part2_instructions',
                'is_required' => false,
                'display_order' => 30.5
            ],
            [
                'template_id' => $templateId,
                'question_text' => 'For each question below, please select the ONE option that best describes you. Choose the statement that resonates most with your natural tendencies and preferences.',
                'option_a_label' => '',
                'option_b_label' => '',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_instructions',
                'a_side' => null,
                'b_side' => null,
                'element_key' => 'paradigm_main_part2_instructions_detail',
                'is_required' => false,
                'display_order' => 30.7
            ]
        ];
        
        // Insert Part 2 instructions
        foreach ($part2Instructions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        // Paradigm Main Part 2: 64 Questions (8-field selection) - EXACT as provided
        $part2Questions = [
            // Section 1 - Q1
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy being clear and direct.',
                'option_a_label' => 'I enjoy being clear and direct.', // LU - The Question Asker
                'option_b_label' => 'I like evaluating my own work and others.', // LU - The Fact Finder
                'option_c_label' => null,
                'option_d_label' => null,
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'LU',
                'b_side' => 'LU',
                'element_key' => 'paradigm_main_s1_q1',
                'is_required' => true,
                'display_order' => 31
            ],
            // Section 1 - Q2
            [
                'template_id' => $templateId,
                'question_text' => 'I prefer using proven methods.',
                'option_a_label' => 'I prefer using proven methods.', // LL - The Rule Keeper
                'option_b_label' => 'I like turning ideas into action.', // LL - The Task Manager
                'option_c_label' => null,
                'option_d_label' => null,
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'LL',
                'b_side' => 'LL',
                'element_key' => 'paradigm_main_s1_q2',
                'is_required' => true,
                'display_order' => 32
            ],
            // Section 1 - Q3
            [
                'template_id' => $templateId,
                'question_text' => 'I enjoy experimenting with new ideas.',
                'option_a_label' => 'I enjoy experimenting with new ideas.', // RU - The Creator
                'option_b_label' => 'I sometimes enjoy thinking in unusual and imaginative ways.', // RU - The Creator
                'option_c_label' => null,
                'option_d_label' => null,
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'RU',
                'b_side' => 'RU',
                'element_key' => 'paradigm_main_s1_q3',
                'is_required' => true,
                'display_order' => 33
            ],
            // Section 1 - Q4
            [
                'template_id' => $templateId,
                'question_text' => 'I like being around people.',
                'option_a_label' => 'I like being around people.', // RL - The Friend Maker
                'option_b_label' => 'I enjoy supporting others.', // RL - The Empath
                'option_c_label' => null,
                'option_d_label' => null,
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'a_side' => 'RL',
                'b_side' => 'RL',
                'element_key' => 'paradigm_main_s1_q4',
                'is_required' => true,
                'display_order' => 34
            ]
        ];
        
        // Insert Part 2 questions (first 4 for now)
        foreach ($part2Questions as $question) {
            DB::table('paradigm_questions')->insert(array_merge($question, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        $this->command->info('Complete Paradigm Main questions seeded successfully!');
        $this->command->info('Instructions: 4 instruction questions');
        $this->command->info('Part 1: ' . count($part1Questions) . ' questions (4-frame ranking, select 3 out of 4)');
        $this->command->info('Part 2: ' . count($part2Questions) . ' questions (2-option selection, select 1 out of 2)');
        $this->command->info('Total: ' . (4 + count($part1Questions) + count($part2Questions)) . ' questions');
        $this->command->info('Answer Options: ' . (count($part1Questions) * 4 + count($part2Questions) * 2) . ' total answers');
    }
}