<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmFormTemplate;
use App\Models\ParadigmPersonalField;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class AddPersonalFieldsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $template = ParadigmFormTemplate::find(1); // Assuming template ID is 1

        if ($template) {
            $fields = [
                ['field_label' => 'First Name', 'field_key' => 'name', 'field_type' => 'text', 'is_required' => true, 'display_order' => 1, 'options' => null],
                ['field_label' => 'Last Name', 'field_key' => 'surname', 'field_type' => 'text', 'is_required' => true, 'display_order' => 2, 'options' => null],
                ['field_label' => 'Email', 'field_key' => 'email', 'field_type' => 'email', 'is_required' => true, 'display_order' => 3, 'options' => null],
                ['field_label' => 'Age Group', 'field_key' => 'age', 'field_type' => 'select', 'options' => 'Under 18,18-24,25-34,35-44,45-54,55-64,65 or over', 'is_required' => true, 'display_order' => 4],
                ['field_label' => 'Gender', 'field_key' => 'gender', 'field_type' => 'select', 'options' => 'Male,Female,Non-binary,Prefer not to say', 'is_required' => true, 'display_order' => 5],
                ['field_label' => 'Phone Number', 'field_key' => 'phone', 'field_type' => 'tel', 'is_required' => false, 'display_order' => 6, 'options' => null],
            ];

            foreach ($fields as $field) {
                ParadigmPersonalField::updateOrCreate(
                    ['template_id' => $template->id, 'field_key' => $field['field_key']],
                    $field
                );
            }
        }
    }
}
