<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_help_form_responses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('lead_id');
            $table->unsignedBigInteger('question_id');
            $table->unsignedBigInteger('answer_id')->nullable();
            $table->text('answer_text')->nullable();
            $table->timestamps();
            
            $table->foreign('lead_id')->references('id')->on('user_form_inputs')->onDelete('cascade');
            $table->foreign('question_id')->references('id')->on('help_form_questions')->onDelete('cascade');
            $table->foreign('answer_id')->references('id')->on('help_form_answers')->onDelete('set null');
            
            $table->index('lead_id');
            $table->index('question_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_help_form_responses');
    }
};

