<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * Updates the marketplace_status enum to include the correct values
     *
     * @return void
     */
    public function up(): void
    {
        // For MySQL, we need to use raw SQL to modify the enum
        DB::statement("ALTER TABLE user_form_inputs MODIFY COLUMN marketplace_status ENUM('marketplace', 'pending', 'unlocked', 'connected', 'expired', 'declined') DEFAULT 'pending'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        // Revert to the old enum values
        DB::statement("ALTER TABLE user_form_inputs MODIFY COLUMN marketplace_status ENUM('pending', 'unlocked', 'in_progress', 'completed', 'expired', 'cancelled') DEFAULT 'pending'");
    }
};

