<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_client_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('provider_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->foreignId('payment_id')->constrained('paradigm_payments')->onDelete('cascade');
            $table->foreignId('result_id')->constrained('paradigm_assessment_results')->onDelete('cascade');
            $table->enum('status', ['in_progress', 'completed', 'expired'])->default('in_progress');
            $table->timestamp('started_at')->nullable(); // When client started the assessment
            $table->timestamp('completed_at')->nullable(); // When assessment was completed
            $table->timestamp('expires_at')->nullable(); // When access expires
            $table->boolean('can_retake')->default(false); // Whether client can retake (requires new payment)
            $table->timestamps();
            
            $table->index(['client_id', 'status']);
            $table->index(['provider_id', 'status']);
            $table->index(['template_id', 'status']);
            $table->index(['payment_id']);
            $table->index(['expires_at']);
            
            // Ensure one result per payment (unless retake is allowed)
            $table->unique(['payment_id', 'result_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_client_results');
    }
};