<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_access_tokens', function (Blueprint $table) {
            $table->id();
            $table->string('token', 64)->unique(); // Unique access token
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->foreignId('provider_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('client_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('payment_id')->constrained('paradigm_payments')->onDelete('cascade');
            $table->enum('status', ['active', 'used', 'expired'])->default('active');
            $table->timestamp('used_at')->nullable(); // When token was used to access assessment
            $table->timestamp('expires_at')->nullable(); // Token expiration
            $table->timestamps();
            
            $table->index(['token']);
            $table->index(['client_id', 'status']);
            $table->index(['provider_id', 'status']);
            $table->index(['template_id', 'status']);
            $table->index(['expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_access_tokens');
    }
};