<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->foreignId('provider_id')->constrained('users')->onDelete('cascade'); // Provider who generated the link
            $table->foreignId('client_id')->nullable()->constrained('users')->onDelete('set null'); // Client who paid (null until payment)
            $table->decimal('amount', 10, 2)->default(0.00); // Payment amount (0.00 = free)
            $table->string('currency', 3)->default('USD'); // ISO currency code
            $table->enum('status', ['pending', 'paid', 'failed', 'expired', 'refunded', 'free'])->default('pending');
            $table->string('payment_link', 500)->unique(); // Unique payment link
            $table->string('payment_reference')->nullable(); // External payment system reference
            $table->string('payment_method')->nullable(); // paypal, stripe, etc.
            $table->json('payment_data')->nullable(); // Store additional payment data
            $table->timestamp('expires_at')->nullable(); // Link expiration
            $table->timestamp('paid_at')->nullable(); // When payment was completed
            $table->timestamps();
            
            $table->index(['provider_id', 'status']);
            $table->index(['client_id', 'status']);
            $table->index(['template_id', 'status']);
            $table->index(['payment_link']);
            $table->index(['expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_payments');
    }
};